/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.SubtypingRepresentatives;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CapturedType
extends DelegatingType
implements SubtypingRepresentatives {
    private final KotlinTypeImpl delegateType;
    private final TypeProjection typeProjection;

    @Override
    @NotNull
    protected KotlinType getDelegate() {
        return this.delegateType;
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Object object;
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        if (Intrinsics.areEqual(capabilityClass, SubtypingRepresentatives.class)) {
            CapturedType capturedType = this;
            if (capturedType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            object = capturedType;
        } else {
            object = super.getCapability(capabilityClass);
        }
        return object;
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns(this).getNullableAnyType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.nullableAnyType");
        KotlinType kotlinType2 = this.representative(Variance.OUT_VARIANCE, kotlinType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "representative(OUT_VARIA\u2026builtIns.nullableAnyType)");
        return kotlinType2;
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns(this).getNothingType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.nothingType");
        KotlinType kotlinType2 = this.representative(Variance.IN_VARIANCE, kotlinType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "representative(IN_VARIANCE, builtIns.nothingType)");
        return kotlinType2;
    }

    private final KotlinType representative(Variance variance, KotlinType kotlinType) {
        return Intrinsics.areEqual((Object)this.typeProjection.getProjectionKind(), (Object)variance) ? this.typeProjection.getType() : kotlinType;
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return this.delegateType.getConstructor() == type2.getConstructor();
    }

    @Override
    @NotNull
    public String toString() {
        return "Captured(" + this.typeProjection + ")";
    }

    /*
     * WARNING - void declaration
     */
    public CapturedType(@NotNull TypeProjection typeProjection) {
        KotlinTypeImpl kotlinTypeImpl;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        this.typeProjection = typeProjection;
        CapturedType capturedType = this;
        CapturedType capturedType2 = this;
        CapturedType $receiver = (CapturedType)$receiver$iv;
        MemberScope scope2 = ErrorUtils.createErrorScope("No member resolution should be done on captured type, it used only during constraint system resolution", true);
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = new CapturedTypeConstructor($receiver.typeProjection);
        List list = CollectionsKt.listOf();
        MemberScope memberScope2 = scope2;
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "scope");
        capturedType2.delegateType = kotlinTypeImpl = KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, false, list, memberScope2);
    }
}

