/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Generics;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.NotNull;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.AsmCacheFields;
import com.esotericsoftware.kryo.serializers.FieldSerializerGenericsUtil;
import com.esotericsoftware.kryo.serializers.FieldSerializerUnsafeUtil;
import com.esotericsoftware.kryo.serializers.ObjectField;
import com.esotericsoftware.kryo.serializers.UnsafeCacheFields;
import com.esotericsoftware.kryo.util.IntArray;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    private final TypeVariable[] typeParameters;
    private CachedField[] fields = new CachedField[0];
    private CachedField[] transientFields = new CachedField[0];
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;
    private boolean ignoreSyntheticFields = true;
    private boolean fixedFieldTypes;
    private boolean useAsmEnabled = UnsafeUtil.unsafe() != null;
    private FieldSerializerUnsafeUtil unsafeUtil;
    private FieldSerializerGenericsUtil genericsUtil;
    private Class[] generics;
    private Generics genericsScope;
    private boolean varIntsEnabled = true;
    private boolean useMemRegions = false;
    private final boolean copyTransient = true;
    private final boolean serializeTransient = false;
    private boolean hasObjectFields = false;

    public FieldSerializer(Kryo kryo, Class clazz) {
        this.kryo = kryo;
        this.type = clazz;
        this.typeParameters = clazz.getTypeParameters();
        this.useAsmEnabled = kryo.getAsmEnabled();
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = new FieldSerializerUnsafeUtil(this);
        this.rebuildCachedFields();
    }

    public FieldSerializer(Kryo kryo, Class clazz, Class[] classArray) {
        this.kryo = kryo;
        this.type = clazz;
        this.generics = classArray;
        this.typeParameters = clazz.getTypeParameters();
        this.useAsmEnabled = kryo.getAsmEnabled();
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = new FieldSerializerUnsafeUtil(this);
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        Object object2;
        Generics generics;
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        this.hasObjectFields = false;
        this.genericsScope = generics = this.genericsUtil.buildGenericsScope(this.type, this.generics);
        if (this.genericsScope != null) {
            this.kryo.pushGenericsScope(this.type, this.genericsScope);
        }
        List<Field> list = new ArrayList<Field>();
        for (Class clazz = this.type; clazz != Object.class; clazz = clazz.getSuperclass()) {
            object2 = clazz.getDeclaredFields();
            if (object2 == null) continue;
            for (Field object3 : object2) {
                if (Modifier.isStatic(object3.getModifiers())) continue;
                list.add(object3);
            }
        }
        object2 = this.kryo.getContext();
        IntArray intArray = new IntArray();
        if (this.useMemRegions && !this.useAsmEnabled && UnsafeUtil.unsafe() != null) {
            Field[] fieldArray = UnsafeUtil.sortFieldsByOffset(list);
            list = Arrays.asList(fieldArray);
        }
        List<Field> list2 = this.buildValidFields(false, list, (ObjectMap)object2, intArray);
        List<Field> list3 = this.buildValidFields(true, list, (ObjectMap)object2, intArray);
        if (this.useAsmEnabled && !Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && intArray.indexOf(1) != -1) {
            try {
                this.access = FieldAccess.get((Class)this.type);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        ArrayList<CachedField> arrayList = new ArrayList<CachedField>(list2.size());
        ArrayList<CachedField> arrayList2 = new ArrayList<CachedField>(list3.size());
        this.createCachedFields(intArray, list2, arrayList, 0);
        this.createCachedFields(intArray, list3, arrayList2, list2.size());
        Collections.sort(arrayList, this);
        this.fields = arrayList.toArray(new CachedField[arrayList.size()]);
        Collections.sort(arrayList2, this);
        this.transientFields = arrayList2.toArray(new CachedField[arrayList2.size()]);
        this.initializeCachedFields();
        if (this.genericsScope != null) {
            this.kryo.popGenericsScope();
        }
    }

    private List<Field> buildValidFields(boolean bl, List<Field> list, ObjectMap objectMap, IntArray intArray) {
        ArrayList<Field> arrayList = new ArrayList<Field>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Optional optional;
            Field field = list.get(i);
            int n2 = field.getModifiers();
            if (Modifier.isTransient(n2) && !bl || Modifier.isStatic(n2) || field.isSynthetic() && this.ignoreSyntheticFields) continue;
            if (!field.isAccessible()) {
                if (!this.setFieldsAsAccessible) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && !objectMap.containsKey(optional.value())) continue;
            arrayList.add(field);
            intArray.add(!Modifier.isFinal(n2) && Modifier.isPublic(n2) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
        }
        return arrayList;
    }

    private void createCachedFields(IntArray intArray, List<Field> list, List<CachedField> list2, int n) {
        if (this.useAsmEnabled || !this.useMemRegions) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Field field = list.get(i);
                int n3 = -1;
                if (this.access != null && intArray.get(n + i) == 1) {
                    n3 = ((FieldAccess)this.access).getIndex(field.getName());
                }
                list2.add(this.newCachedField(field, list2.size(), n3));
            }
        } else {
            this.unsafeUtil.createUnsafeCacheFieldsAndRegions(list, list2, n, intArray);
        }
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] classArray) {
        this.generics = classArray;
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            this.rebuildCachedFields();
        }
    }

    protected void initializeCachedFields() {
    }

    CachedField newCachedField(Field field, int n, int n2) {
        Class[] classArray = new Class[]{field.getType()};
        Type type = field.getGenericType();
        CachedField cachedField = type == classArray[0] ? this.newMatchingCachedField(field, n2, classArray[0], type, null) : this.genericsUtil.newCachedFieldOfGenericType(field, n2, classArray, type);
        if (cachedField instanceof ObjectField) {
            this.hasObjectFields = true;
        }
        cachedField.field = field;
        cachedField.varIntsEnabled = this.varIntsEnabled;
        if (!this.useAsmEnabled) {
            cachedField.offset = this.unsafeUtil.getObjectFieldOffset(field);
        }
        cachedField.access = (FieldAccess)this.access;
        cachedField.accessIndex = n2;
        boolean bl = cachedField.canBeNull = this.fieldsCanBeNull && !classArray[0].isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(classArray[0]) || this.fixedFieldTypes) {
            cachedField.valueClass = classArray[0];
        }
        return cachedField;
    }

    CachedField newMatchingCachedField(Field field, int n, Class clazz, Type type, Class[] classArray) {
        CachedField cachedField;
        if (n != -1) {
            cachedField = clazz.isPrimitive() ? (clazz == Boolean.TYPE ? new AsmCacheFields.BooleanField() : (clazz == Byte.TYPE ? new AsmCacheFields.ByteField() : (clazz == Character.TYPE ? new AsmCacheFields.CharField() : (clazz == Short.TYPE ? new AsmCacheFields.ShortField() : (clazz == Integer.TYPE ? new AsmCacheFields.IntField() : (clazz == Long.TYPE ? new AsmCacheFields.LongField() : (clazz == Float.TYPE ? new AsmCacheFields.FloatField() : (clazz == Double.TYPE ? new AsmCacheFields.DoubleField() : new AsmCacheFields.AsmObjectField(this))))))))) : (!(clazz != String.class || this.kryo.getReferences() && this.kryo.getReferenceResolver().useReferences(String.class)) ? new AsmCacheFields.StringField() : new AsmCacheFields.AsmObjectField(this));
        } else if (!this.useAsmEnabled) {
            cachedField = clazz.isPrimitive() ? (clazz == Boolean.TYPE ? new UnsafeCacheFields.UnsafeBooleanField(field) : (clazz == Byte.TYPE ? new UnsafeCacheFields.UnsafeByteField(field) : (clazz == Character.TYPE ? new UnsafeCacheFields.UnsafeCharField(field) : (clazz == Short.TYPE ? new UnsafeCacheFields.UnsafeShortField(field) : (clazz == Integer.TYPE ? new UnsafeCacheFields.UnsafeIntField(field) : (clazz == Long.TYPE ? new UnsafeCacheFields.UnsafeLongField(field) : (clazz == Float.TYPE ? new UnsafeCacheFields.UnsafeFloatField(field) : (clazz == Double.TYPE ? new UnsafeCacheFields.UnsafeDoubleField(field) : new UnsafeCacheFields.UnsafeObjectField(this))))))))) : (!(clazz != String.class || this.kryo.getReferences() && this.kryo.getReferenceResolver().useReferences(String.class)) ? new UnsafeCacheFields.UnsafeStringField(field) : new UnsafeCacheFields.UnsafeObjectField(this));
        } else {
            cachedField = clazz.isPrimitive() ? (clazz == Boolean.TYPE ? new ObjectField.ObjectBooleanField(this) : (clazz == Byte.TYPE ? new ObjectField.ObjectByteField(this) : (clazz == Character.TYPE ? new ObjectField.ObjectCharField(this) : (clazz == Short.TYPE ? new ObjectField.ObjectShortField(this) : (clazz == Integer.TYPE ? new ObjectField.ObjectIntField(this) : (clazz == Long.TYPE ? new ObjectField.ObjectLongField(this) : (clazz == Float.TYPE ? new ObjectField.ObjectFloatField(this) : (clazz == Double.TYPE ? new ObjectField.ObjectDoubleField(this) : new ObjectField(this))))))))) : new ObjectField(this);
            if (classArray != null) {
                ((ObjectField)cachedField).generics = classArray;
            } else {
                Class[] classArray2 = FieldSerializerGenericsUtil.getGenerics(type, this.kryo);
                ((ObjectField)cachedField).generics = classArray2;
            }
        }
        return cachedField;
    }

    @Override
    public int compare(CachedField cachedField, CachedField cachedField2) {
        return cachedField.field.getName().compareTo(cachedField2.field.getName());
    }

    public void setFieldsCanBeNull(boolean bl) {
        this.fieldsCanBeNull = bl;
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean bl) {
        this.setFieldsAsAccessible = bl;
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean bl) {
        this.ignoreSyntheticFields = bl;
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean bl) {
        this.fixedFieldTypes = bl;
        this.rebuildCachedFields();
    }

    public void setUseAsm(boolean bl) {
        this.useAsmEnabled = bl;
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T t) {
        if (this.typeParameters != null && this.generics != null) {
            this.rebuildCachedFields();
        }
        if (this.genericsScope != null) {
            kryo.pushGenericsScope(this.type, this.genericsScope);
        }
        CachedField[] cachedFieldArray = this.fields;
        int n = cachedFieldArray.length;
        for (int i = 0; i < n; ++i) {
            cachedFieldArray[i].write(output, t);
        }
        if (this.genericsScope != null) {
            kryo.popGenericsScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        try {
            if (this.typeParameters != null && this.generics != null) {
                this.rebuildCachedFields();
            }
            if (this.genericsScope != null) {
                kryo.pushGenericsScope(clazz, this.genericsScope);
            }
            T t = this.create(kryo, input, clazz);
            kryo.reference(t);
            CachedField[] cachedFieldArray = this.fields;
            int n = cachedFieldArray.length;
            for (int i = 0; i < n; ++i) {
                cachedFieldArray[i].read(input, t);
            }
            T t2 = t;
            return t2;
        }
        finally {
            if (this.genericsScope != null && kryo.getGenericsScope() != null) {
                kryo.popGenericsScope();
            }
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> clazz) {
        return kryo.newInstance(clazz);
    }

    public CachedField getField(String string) {
        for (CachedField cachedField : this.fields) {
            if (!cachedField.field.getName().equals(string)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String string) {
        for (int i = 0; i < this.fields.length; ++i) {
            CachedField cachedField = this.fields[i];
            if (!cachedField.field.getName().equals(string)) continue;
            CachedField[] cachedFieldArray = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, cachedFieldArray, 0, i);
            System.arraycopy(this.fields, i + 1, cachedFieldArray, i, cachedFieldArray.length - i);
            this.fields = cachedFieldArray;
            return;
        }
        throw new IllegalArgumentException("Field \"" + string + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public boolean getUseAsmEnabled() {
        return this.useAsmEnabled;
    }

    public boolean getUseMemRegions() {
        return this.useMemRegions;
    }

    protected T createCopy(Kryo kryo, T t) {
        return (T)kryo.newInstance(t.getClass());
    }

    @Override
    public T copy(Kryo kryo, T t) {
        int n;
        T t2 = this.createCopy(kryo, t);
        kryo.reference(t2);
        int n2 = this.transientFields.length;
        for (n = 0; n < n2; ++n) {
            this.transientFields[n].copy(t, t2);
        }
        n2 = this.fields.length;
        for (n = 0; n < n2; ++n) {
            this.fields[n].copy(t, t2);
        }
        return t2;
    }

    public final Generics getGenericsScope() {
        return this.genericsScope;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    public static abstract class CachedField<X> {
        Field field;
        FieldAccess access;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;
        long offset = -1L;
        boolean varIntsEnabled = true;

        public void setClass(Class clazz) {
            this.valueClass = clazz;
            this.serializer = null;
        }

        public void setClass(Class clazz, Serializer serializer) {
            this.valueClass = clazz;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean bl) {
            this.canBeNull = bl;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

