/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\"\u0015\t\u0001bB\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u001d!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e1\u0001rA\u0007\u0005\u0013\tI\u0011\u0001'\u0003\u0019\t\u0015r\u0001\"B\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011D\u0002E\u0004\u001b\u0011I!!C\u0001\u0019\na!QE\u0003E\u0006\u001b\u0011I!!C\u0001\u0019\na1\u0011d\u0001E\u0003\u001b\u0005A2!\n\u0007\u0005\b!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u000fe\u0019\u0001\u0002C\u0007\u00021\u0013)C\u0002b\u0002\t\u00125\t\u0001dB\r\u0004\u0011\u001fi\u0011\u0001G\u0004\u001a\u0007!AQ\"\u0001M\u0005"}, strings={"Lorg/jetbrains/kotlin/jps/build/JpsJsModuleUtils;", "", "()V", "getDependencyModulesAndSources", "", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "result", "", "", "getLibraryFiles", "getLibraryFilesAndDependencies", "", "getOutputFile", "Ljava/io/File;", "outputDir", "moduleName", "getOutputMetaFile"}, moduleName="jps-plugin")
public final class JpsJsModuleUtils {
    public static final JpsJsModuleUtils INSTANCE;
    public static final JpsJsModuleUtils INSTANCE$;

    @NotNull
    public final List<String> getLibraryFilesAndDependencies(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        ArrayList result = new ArrayList();
        this.getLibraryFiles(target, result);
        this.getDependencyModulesAndSources(target, result);
        return result;
    }

    public final void getLibraryFiles(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Set libraries = JpsUtils.getAllDependencies(target).getLibraries();
        for (JpsLibrary library : libraries) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String path = JpsPathUtil.urlToPath((String)root.getUrl());
                if (StringsKt.startsWith$default((String)path, (String)(KotlinJavascriptMetadataUtils.INSTANCE.getVFS_PROTOCOL() + "://"), (boolean)false, (int)2)) continue;
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                result.add(string);
            }
        }
    }

    public final void getDependencyModulesAndSources(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        JpsUtils.getAllDependencies(target).processModules((Consumer)new Consumer<JpsModule>(target, result){
            final /* synthetic */ ModuleBuildTarget $target;
            final /* synthetic */ List $result;

            public void consume(@NotNull JpsModule module) {
                File outputDir;
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                if (Intrinsics.areEqual((Object)module, (Object)this.$target.getModule()) || Intrinsics.areEqual((Object)module.getModuleType(), (Object)JpsJavaModuleType.INSTANCE) ^ true) {
                    return;
                }
                ModuleBuildTarget moduleBuildTarget = new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION);
                File file = outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(moduleBuildTarget);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
                String string = module.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.getName()");
                File metaInfoFile = JpsJsModuleUtils.getOutputMetaFile(file, string);
                String string2 = metaInfoFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"metaInfoFile.getAbsolutePath()");
                this.$result.add(string2);
            }
            {
                this.$target = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final File getOutputFile(@NotNull File outputDir, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir, moduleName + KotlinJavascriptMetadataUtils.INSTANCE.getJS_EXT());
    }

    @JvmStatic
    @NotNull
    public static final File getOutputMetaFile(@NotNull File outputDir, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir, moduleName + KotlinJavascriptMetadataUtils.INSTANCE.getMETA_JS_SUFFIX());
    }

    private JpsJsModuleUtils() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new JpsJsModuleUtils();
    }
}

