/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.dialogs.SelectFilesDialog;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class MarkResolvedAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.actions.MarkResolvedAction");

    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.name.mark.resolved", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return false;
    }

    @Override
    protected boolean isEnabled(Project project, @NotNull SvnVcs vcs, VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/MarkResolvedAction", "isEnabled"));
        }
        if (file.isDirectory()) {
            return SvnStatusUtil.isUnderControl(project, file);
        }
        FileStatus fStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        return FileStatus.MERGED_WITH_CONFLICTS.equals(fStatus) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(fStatus) || FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(fStatus);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.batchPerform(project, activeVcs, new VirtualFile[]{file}, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
        SvnVcs vcs = SvnVcs.getInstance(project);
        ApplicationManager.getApplication().saveAll();
        Collection<String> paths = MarkResolvedAction.collectResolvablePaths(vcs, files);
        if (paths.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)SvnBundle.message("message.text.no.conflicts.found", new Object[0]), (String)SvnBundle.message("message.title.no.conflicts.found", new Object[0]));
            return;
        }
        String[] pathsArray = ArrayUtil.toStringArray(paths);
        SelectFilesDialog dialog = new SelectFilesDialog(project, SvnBundle.message("label.select.files.and.directories.to.mark.resolved", new Object[0]), SvnBundle.message("dialog.title.mark.resolved", new Object[0]), SvnBundle.message("action.name.mark.resolved", new Object[0]), pathsArray, "vcs.subversion.resolve");
        if (!dialog.showAndGet()) {
            return;
        }
        pathsArray = dialog.getSelectedPaths();
        try {
            for (String string : pathsArray) {
                File ioFile = new File(string);
                ConflictClient client = vcs.getFactory(ioFile).createConflictClient();
                client.resolve(ioFile, Depth.EMPTY, true, true, true);
            }
        }
        finally {
            for (String string : files) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty((VirtualFile)string);
                string.refresh(true, false);
                if (string.getParent() == null) continue;
                string.getParent().refresh(true, false);
            }
        }
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    private static Collection<String> collectResolvablePaths(SvnVcs vcs, VirtualFile[] files) {
        final TreeSet<String> target = new TreeSet<String>();
        for (VirtualFile file : files) {
            try {
                File path = new File(file.getPath());
                StatusClient client = vcs.getFactory(path).createStatusClient();
                client.doStatus(path, SVNRevision.UNDEFINED, Depth.INFINITY, false, false, false, false, new StatusConsumer(){

                    public void consume(Status status) {
                        if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == StatusType.STATUS_CONFLICTED) {
                            target.add(status.getFile().getAbsolutePath());
                        }
                    }
                }, null);
            }
            catch (SvnBindException e) {
                LOG.warn((Throwable)((Object)e));
            }
        }
        return target;
    }
}

