/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.status.Status;

class SvnChangedFile {
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final Status myStatus;
    @Nullable
    private final String myCopyFromURL;

    public SvnChangedFile(@NotNull FilePath filePath, @NotNull Status status) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangedFile", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangedFile", "<init>"));
        }
        this(filePath, status, null);
    }

    public SvnChangedFile(@NotNull FilePath filePath, @NotNull Status status, @Nullable String copyFromURL) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnChangedFile", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/idea/svn/SvnChangedFile", "<init>"));
        }
        this.myFilePath = filePath;
        this.myStatus = status;
        this.myCopyFromURL = copyFromURL;
    }

    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangedFile", "getFilePath"));
        }
        return filePath;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangedFile", "getStatus"));
        }
        return status;
    }

    @Nullable
    public String getCopyFromURL() {
        return (String)ObjectUtils.chooseNotNull((Object)this.myCopyFromURL, (Object)this.myStatus.getCopyFromURL());
    }

    public String toString() {
        return this.myFilePath.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnChangedFile that = (SvnChangedFile)o;
        return this.myFilePath.equals(that.myFilePath);
    }

    public int hashCode() {
        return this.myFilePath.hashCode();
    }
}

