/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.BaseGenerator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesIndexGenerator
extends BaseGenerator {
    public ClassesIndexGenerator(@NotNull TemplateProcessor templateFactory, @NotNull LocalGeneratorPaths paths) {
        if (templateFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ClassesIndexGenerator.<init> must not be null");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/ClassesIndexGenerator.<init> must not be null");
        }
        super(templateFactory, paths);
    }

    public void generateNamespaceIndex(ModuleInfo module, String ns, Collection<ClassInfo> nsClasses, StatisticsCalculator covStatsCalculator) throws IOException {
        for (SortOption sortOption : this.getGenerateSortOptions(covStatsCalculator)) {
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put("module", module);
            templateModel.put("namespace", ns);
            templateModel.put("classes", this.prepareClasses(nsClasses, covStatsCalculator, sortOption));
            templateModel.put("statsCalculator", covStatsCalculator);
            templateModel.put("sortOption", (Object)sortOption);
            this.myTemplateFactory.renderTemplate(templateModel, this.myPaths.getClassesIndexPath(module, ns, sortOption));
        }
    }

    private List<ClassInfo> prepareClasses(Collection<ClassInfo> classes, StatisticsCalculator covStatsCalculator, SortOption sortOption) {
        List<ClassInfo> result = this.removeClassesWithoutStats(classes, covStatsCalculator);
        Collections.sort(result, sortOption.createClassComparator(covStatsCalculator));
        return result;
    }

    private List<ClassInfo> removeClassesWithoutStats(@NotNull Collection<ClassInfo> classes, final @NotNull StatisticsCalculator covStatsCalculator) {
        if (classes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ClassesIndexGenerator.removeClassesWithoutStats must not be null");
        }
        if (covStatsCalculator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/ClassesIndexGenerator.removeClassesWithoutStats must not be null");
        }
        return this.filterCovered(classes, new BaseGenerator.Converter<ClassInfo>(){

            @Override
            @NotNull
            public CoverageStatistics convert(ClassInfo classInfo) {
                CoverageStatistics coverageStatistics = covStatsCalculator.getForClassWithInnerClasses(classInfo);
                if (coverageStatistics == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ClassesIndexGenerator$1.convert must not return null");
                }
                return coverageStatistics;
            }
        });
    }
}

