/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.csv.ClassRowWriter;

class CSVGroupHandler
implements IReportGroupVisitor {
    private final ClassRowWriter writer;
    private final String groupName;

    public CSVGroupHandler(ClassRowWriter writer) {
        this(writer, null);
    }

    private CSVGroupHandler(ClassRowWriter writer, String groupName) {
        this.writer = writer;
        this.groupName = groupName;
    }

    public void visitBundle(IBundleCoverage bundle, ISourceFileLocator locator) throws IOException {
        String name = this.appendName(bundle.getName());
        for (IPackageCoverage p : bundle.getPackages()) {
            String packageName = p.getName();
            for (IClassCoverage c : p.getClasses()) {
                this.writer.writeRow(name, packageName, c);
            }
        }
    }

    public IReportGroupVisitor visitGroup(String name) throws IOException {
        return new CSVGroupHandler(this.writer, this.appendName(name));
    }

    private String appendName(String name) {
        return this.groupName == null ? name : this.groupName + "/" + name;
    }
}

