/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1\u0001\u00034\u0019\u0001\u00012!G\u0001\u0019\u0002u\u00051!K\u0005\u0005'\"A\u0011!D\u0001\u0019\u0004E\u001b1!\u0004\u0002\u0005\u0005!\u0015\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion"}, moduleName="kotlin-compiler")
public interface ExpressionReceiver
extends ReceiverValue {
    public static final Companion Companion = org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver$Companion.INSTANCE;

    @NotNull
    public KtExpression getExpression();

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\u001e\u0003\u00171\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\u0010\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "ExpressionReceiverImpl", "ThisExpressionClassReceiver"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final ExpressionReceiver create(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext bindingContext2) {
            DeclarationDescriptor descriptor2;
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
            KtReferenceExpression referenceExpression = null;
            if (expression instanceof KtThisExpression) {
                referenceExpression = ((KtThisExpression)expression).getInstanceReference();
            } else if (expression instanceof KtConstructorDelegationReferenceExpression) {
                referenceExpression = (KtReferenceExpression)expression;
            }
            if (referenceExpression != null && (descriptor2 = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, referenceExpression)) instanceof ClassDescriptor) {
                DeclarationDescriptorWithSource declarationDescriptorWithSource = ((ClassDescriptor)descriptor2).getOriginal();
                if (declarationDescriptorWithSource == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                return new ThisExpressionClassReceiver((ClassDescriptor)declarationDescriptorWithSource, expression, type2);
            }
            return new ExpressionReceiverImpl(expression, type2);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }

        @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001b\u0002\u0003\n\u0019\u0001I\u0012\u0001'\u0001\u001a\u0003a\t\u0011UC\u0005\u0004\u0011\u0007i\u0011\u0001\u0007\u0002\n\u0007!\u0015Q\"\u0001\r\u0004#\u000e\t\u0001rA\u0013\u0005\t-AQ!D\u0001\u0019\f%RAa\u0013\u0005\t\u00045\t\u0001DA)\u0004\t\u0015\u0001QB\u0001\u0003\u0005\u0011\u0013\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "toString", ""}, moduleName="kotlin-compiler")
        private static class ExpressionReceiverImpl
        extends AbstractReceiverValue
        implements ExpressionReceiver {
            @NotNull
            private final KtExpression expression;

            @NotNull
            public String toString() {
                return this.getType() + " {" + this.getExpression() + ": " + this.getExpression().getText() + "}";
            }

            @Override
            @NotNull
            public KtExpression getExpression() {
                return this.expression;
            }

            public ExpressionReceiverImpl(@NotNull KtExpression expression, @NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(type2);
                this.expression = expression;
            }
        }

        @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\t\u0005a\u0001!G\u0001\u0019\u0002e\t\u0001$AQ\u000f\u0013\rA\u0019!D\u0001\u0019\u0005%\u0019\u0001RA\u0007\u00021\rI1\u0001c\u0002\u000e\u0003a!\u0011kA\u0001\t\n%RAa\u0013\u0005\t\u00045\t\u0001DA)\u0004\t\u0015\u0001QB\u0001\u0003\u0006\u0011\u0017\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ThisExpressionClassReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ThisClassReceiver;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;"}, moduleName="kotlin-compiler")
        private static final class ThisExpressionClassReceiver
        extends ExpressionReceiverImpl
        implements ThisClassReceiver {
            @NotNull
            private final ClassDescriptor classDescriptor;

            @Override
            @NotNull
            public ClassDescriptor getClassDescriptor() {
                return this.classDescriptor;
            }

            public ThisExpressionClassReceiver(@NotNull ClassDescriptor classDescriptor, @NotNull KtExpression expression, @NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(expression, type2);
                this.classDescriptor = classDescriptor;
            }
        }
    }
}

