/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.ProtectedInSuperClassCompanionCallChecker$check$;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&)\u0011Y\u00012A\u0007\u00021\t\tB\u0001\u0002\u0001\t\u0006U\t\u0001dA\r\u0007\u0011\u000fiA!\u0003\u0002\n\u0003\u0011\u0016\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedInSuperClassCompanionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-compiler")
public final class ProtectedInSuperClassCompanionCallChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor targetDescriptor = resolvedCall.getResultingDescriptor().getOriginal();
        if (Intrinsics.areEqual(targetDescriptor.getVisibility(), Visibilities.PROTECTED) ^ true) {
            return;
        }
        if (AnnotationUtilKt.hasJvmStaticAnnotation(targetDescriptor)) {
            return;
        }
        DeclarationDescriptor containerDescriptor = targetDescriptor.getContainingDeclaration();
        if (containerDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containerDescriptor).isCompanionObject()) {
            boolean bl;
            Sequence parentClassDescriptors;
            ClassDescriptor companionOwnerDescriptor;
            DeclarationDescriptor companionDescriptor;
            block9: {
                Sequence $receiver$iv;
                companionDescriptor = containerDescriptor;
                DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)companionDescriptor).getContainingDeclaration();
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                if (classDescriptor == null) {
                    return;
                }
                companionOwnerDescriptor = classDescriptor;
                Sequence<DeclarationDescriptor> sequence2 = DescriptorUtilsKt.getParentsWithSelf(context.scope.getOwnerDescriptor());
                Sequence sequence3 = SequencesKt.filter($receiver$iv, check$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Sequence<R>");
                }
                $receiver$iv = parentClassDescriptors = sequence3;
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    if (!DescriptorUtils.isSubclass(it, companionOwnerDescriptor)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (!bl) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = companionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "companionDescriptor");
            if (SequencesKt.contains(parentClassDescriptors, declarationDescriptor) ^ true && SequencesKt.contains(parentClassDescriptors, companionOwnerDescriptor) ^ true) {
                context.trace.report(ErrorsJvm.SUBCLASS_CANT_CALL_COMPANION_PROTECTED_NON_STATIC.on((KtElement)((PsiElement)resolvedCall.getCall().getCallElement())));
            }
        }
    }
}

