/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005!1\u0003\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0003\u0003\u0002\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004K%!1\u0002c\u0002\u000e\u00051\u0005\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0002&\u0013\u0011Y\u0001rA\u0007\u0003\u0019\u0003AB!G\u0002\t\u000b5\t\u00014\u0002"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/JvmVirtualFileFinder;", "()V", "classFileName", "", "jClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "findKotlinClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "javaClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;"}, moduleName="kotlin-compiler")
public abstract class VirtualFileKotlinClassFinder
implements JvmVirtualFileFinder {
    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClass$default(KotlinBinaryClassCache.Companion, file, null, 2);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        JavaClass javaClass2 = javaClass;
        if (javaClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl");
        }
        PsiFile psiFile = ((PsiClass)((JavaClassImpl)javaClass2).getPsi()).getContainingFile();
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (javaClass.getOuterClass() != null) {
            VirtualFile virtualFile2 = file.getParent();
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile $receiver$iv = virtualFile2.findChild(this.classFileName(javaClass) + ".class");
            VirtualFile virtualFile3 = $receiver$iv;
            if (virtualFile3 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "Virtual file not found for " + javaClass;
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "file.getParent()!!.findC\u2026t found for $javaClass\" }");
            file = virtualFile3;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClass$default(KotlinBinaryClassCache.Companion, file, null, 2);
    }

    private final String classFileName(JavaClass jClass) {
        JavaClass outerClass = jClass.getOuterClass();
        if (outerClass == null) {
            String string = jClass.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "jClass.getName().asString()");
            return string;
        }
        return this.classFileName(outerClass) + "$" + jClass.getName().asString();
    }
}

