/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaDeprecatedAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaRetentionAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaTargetAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaAnnotationDescriptorKt;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005A!#B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0005\u0005\b\u001b\ta\t\u0001g\u0004\u001a\u0007!AQ\"\u0001\r\u00033\rA\t\"D\u0001\u0019\u0013e\u0019\u00012C\u0007\u00021))C\u0002#\u0006\u000e\u00051\u0005\u0001tB\r\u0004\u0011-i\u0011\u0001g\u0006\u001a\u0007!MQ\"\u0001\r\u000bS\u001d!\u0011\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u000bi\u0011\u0001\u0007\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A1!D\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002c\u0002\u000e\u0003a\u0011\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\t5\t\u0001DA)\u0004\u0003\u0015\u0001\u0011\u0006\u0005\u0003D\u0011!%QbB\u0005\u0003\u0013\u0005A\"!\u0003\u0002\n\u0003a\u0011\u0001$B)\u0004\t\u0015\u0001QB\u0001C\u0006\u0011\u0019IS\u0002B!\t\u0011\u001biq!\u0003\u0002\n\u0003a\u0011\u0011BA\u0005\u00021\tAR!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/components/JavaAnnotationMapper;", "", "()V", "JAVA_DEPRECATED_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JAVA_DOCUMENTED_FQ_NAME", "JAVA_REPEATABLE_FQ_NAME", "JAVA_RETENTION_FQ_NAME", "JAVA_TARGET_FQ_NAME", "javaToKotlinNameMap", "", "getJavaToKotlinNameMap", "()Ljava/util/Map;", "kotlinToJavaNameMap", "findMappedJavaAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "kotlinName", "annotationOwner", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationOwner;", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "mapOrResolveJavaAnnotation", "annotation", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;"}, moduleName="kotlin-compiler")
public final class JavaAnnotationMapper {
    private static final FqName JAVA_TARGET_FQ_NAME;
    private static final FqName JAVA_RETENTION_FQ_NAME;
    private static final FqName JAVA_DEPRECATED_FQ_NAME;
    private static final FqName JAVA_DOCUMENTED_FQ_NAME;
    private static final FqName JAVA_REPEATABLE_FQ_NAME;
    private static final Map<FqName, FqName> kotlinToJavaNameMap;
    @NotNull
    public static final Map<FqName, FqName> javaToKotlinNameMap;
    public static final JavaAnnotationMapper INSTANCE;
    public static final JavaAnnotationMapper INSTANCE$;

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation2, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        Intrinsics.checkParameterIsNotNull(c, "c");
        ClassId classId = annotation2.getClassId();
        if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_TARGET_FQ_NAME))) {
            annotationDescriptor = new JavaTargetAnnotationDescriptor(annotation2, c);
        } else if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_RETENTION_FQ_NAME))) {
            annotationDescriptor = new JavaRetentionAnnotationDescriptor(annotation2, c);
        } else if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_REPEATABLE_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getRepeatableAnnotation();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "c.module.builtIns.repeatableAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation2, classDescriptor);
        } else if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_DOCUMENTED_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getMustBeDocumentedAnnotation();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "c.module.builtIns.mustBeDocumentedAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation2, classDescriptor);
        } else {
            annotationDescriptor = Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_DEPRECATED_FQ_NAME)) ? (AnnotationDescriptor)null : (AnnotationDescriptor)LazyJavaAnnotationDescriptorKt.resolveAnnotation(c, annotation2);
        }
        return annotationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Object javaAnnotation;
        Intrinsics.checkParameterIsNotNull(kotlinName, "kotlinName");
        Intrinsics.checkParameterIsNotNull(annotationOwner, "annotationOwner");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (Intrinsics.areEqual(kotlinName, KotlinBuiltIns.FQ_NAMES.deprecated) && ((javaAnnotation = annotationOwner.findAnnotation(JAVA_DEPRECATED_FQ_NAME)) != null || annotationOwner.isDeprecatedInJavaDoc())) {
            return new JavaDeprecatedAnnotationDescriptor((JavaAnnotation)javaAnnotation, c);
        }
        FqName fqName2 = kotlinToJavaNameMap.get(kotlinName);
        if (fqName2 != null) {
            AnnotationDescriptor annotationDescriptor2;
            void $receiver$iv;
            javaAnnotation = fqName2;
            FqName it = (FqName)$receiver$iv;
            JavaAnnotation javaAnnotation2 = annotationOwner.findAnnotation(it);
            if (javaAnnotation2 != null) {
                void $receiver$iv2;
                JavaAnnotation it2;
                JavaAnnotation javaAnnotation3 = javaAnnotation2;
                JavaAnnotation javaAnnotation4 = it2 = (JavaAnnotation)$receiver$iv2;
                Intrinsics.checkExpressionValueIsNotNull(javaAnnotation4, "it");
                annotationDescriptor2 = INSTANCE.mapOrResolveJavaAnnotation(javaAnnotation4, c);
            } else {
                annotationDescriptor2 = null;
            }
            annotationDescriptor = annotationDescriptor2;
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    @NotNull
    public final Map<FqName, FqName> getJavaToKotlinNameMap() {
        return javaToKotlinNameMap;
    }

    private JavaAnnotationMapper() {
        INSTANCE = this;
        INSTANCE$ = this;
        JAVA_TARGET_FQ_NAME = new FqName(Target.class.getCanonicalName());
        JAVA_RETENTION_FQ_NAME = new FqName(Retention.class.getCanonicalName());
        JAVA_DEPRECATED_FQ_NAME = new FqName(Deprecated.class.getCanonicalName());
        JAVA_DOCUMENTED_FQ_NAME = new FqName(Documented.class.getCanonicalName());
        JAVA_REPEATABLE_FQ_NAME = new FqName("java.lang.annotation.Repeatable");
        kotlinToJavaNameMap = MapsKt.mapOf(TuplesKt.to(KotlinBuiltIns.FQ_NAMES.target, JAVA_TARGET_FQ_NAME), TuplesKt.to(KotlinBuiltIns.FQ_NAMES.retention, JAVA_RETENTION_FQ_NAME), TuplesKt.to(KotlinBuiltIns.FQ_NAMES.repeatable, JAVA_REPEATABLE_FQ_NAME), TuplesKt.to(KotlinBuiltIns.FQ_NAMES.mustBeDocumented, JAVA_DOCUMENTED_FQ_NAME));
        javaToKotlinNameMap = MapsKt.mapOf(TuplesKt.to(JAVA_TARGET_FQ_NAME, KotlinBuiltIns.FQ_NAMES.target), TuplesKt.to(JAVA_RETENTION_FQ_NAME, KotlinBuiltIns.FQ_NAMES.retention), TuplesKt.to(JAVA_DEPRECATED_FQ_NAME, KotlinBuiltIns.FQ_NAMES.deprecated), TuplesKt.to(JAVA_REPEATABLE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.repeatable), TuplesKt.to(JAVA_DOCUMENTED_FQ_NAME, KotlinBuiltIns.FQ_NAMES.mustBeDocumented));
    }

    static {
        new JavaAnnotationMapper();
    }
}

