/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"-\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\t!\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q2\u0003\u0003\u0002\u0011\u0001i\u0011\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u0002)\u000e\u0011Q2\u0003\u0003\u0002\u0011\u000bi\u0011\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u0002)\u000e\u0011Q\u0012\u0003\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u00014\u0001+\u0004\u00055]\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001g\u0003\u0019\u000be\u0019\u0001\"A\u0007\u00021\u0007!6AAG\f\u0011\u0019iA!\u0003\u0002\n\u0003a-\u0001$B\r\u0004\u0011\u001bi\u0011\u0001G\u0004U\u0007\ti9\u0002c\u0004\u000e\t%\u0011\u0011\"\u0001M\u00061\u0015I2\u0001\u0003\u0005\u000e\u0003a-Ak\u0001\u0002\u000e !=Q\u0002B\u0005\u0003\u0013\u0005AZ\u0001G\u0003\u001a\u0007!EQ\"\u0001M\u00023\rA\u0011\"D\u0001\u0019\u0004Q\u001b!\u0001"}, strings={"getEndOffset", "", "element", "Lcom/intellij/psi/PsiElement;", "PositioningStrategyKt", "getStartOffset", "hasSyntaxErrors", "", "psiElement", "markElement", "", "Lcom/intellij/openapi/util/TextRange;", "markNode", "node", "Lcom/intellij/lang/ASTNode;", "markRange", "range", "from", "to"}, moduleName="kotlin-compiler")
public final class PositioningStrategyKt {
    @NotNull
    public static final List<TextRange> markElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return CollectionsKt.listOf(new TextRange(PositioningStrategyKt.getStartOffset(element), PositioningStrategyKt.getEndOffset(element)));
    }

    @NotNull
    public static final List<TextRange> markNode(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        PsiElement psiElement2 = node.getPsi();
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "node.getPsi()");
        return PositioningStrategyKt.markElement(psiElement2);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull(range, "range");
        return CollectionsKt.listOf(range);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        return PositioningStrategyKt.markRange(new TextRange(PositioningStrategyKt.getStartOffset(from), PositioningStrategyKt.getEndOffset(to)));
    }

    private static final int getStartOffset(PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getStartOffset(child);
            }
        }
        return PsiUtilsKt.getStartOffset(element);
    }

    private static final int getEndOffset(PsiElement element) {
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getEndOffset(child);
            }
        }
        return PsiUtilsKt.getEndOffset(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasSyntaxErrors(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull(psiElement2, "psiElement");
        if (psiElement2 instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] children = psiElement2.getChildren();
        if (!ArraysKt.isNotEmpty((Object[])children)) return false;
        PsiElement psiElement3 = (PsiElement)ArraysKt.last((Object[])children);
        Intrinsics.checkExpressionValueIsNotNull(psiElement3, "children.last()");
        if (!PositioningStrategyKt.hasSyntaxErrors(psiElement3)) return false;
        return true;
    }
}

