/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.output;

import java.io.File;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\b\u0015\t\u0001\"C\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005\u000e\u0012B\u0002\u0005\u0002\u001b\u0011I!!C\u0001\u0019\u0005a\r\u0011b\u0001E\u0003\u001b\u0005A2!C\u0002\t\b5\t\u0001dA)\u0004\u0003!!Q\u0005\u0002\u0003\f\u0011\u001bi\u0011\u0001G\u0004&\t\u0011Y\u0001rB\u0007\u00021\r)C\u0001B\u0006\t\u00115\t\u0001dA\u0015\b\t\u0005C\u0001rA\u0007\u00021\r\t6!A\u0003\u0001S)!1\n\u0003E\u0003\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001\"\u0003\t\u000b%jAa\u0013\u0005\t\u00035!\u0011BA\u0005\u00021\tA\u001a!U\u0002\u0005\u000b\u0001i!\u0001b\u0003\t\r\u0001"}, strings={"Lorg/jetbrains/kotlin/backend/common/output/SimpleOutputFile;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "sourceFiles", "", "Ljava/io/File;", "relativePath", "", "content", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getRelativePath", "()Ljava/lang/String;", "getSourceFiles", "()Ljava/util/List;", "asByteArray", "", "asText", "toString"}, moduleName="kotlin-compiler")
public final class SimpleOutputFile
implements OutputFile {
    @NotNull
    private final List<File> sourceFiles;
    @NotNull
    private final String relativePath;
    private final String content;

    @Override
    @NotNull
    public byte[] asByteArray() {
        return StringsKt.toByteArray$default(this.content, null, 1);
    }

    @Override
    @NotNull
    public String asText() {
        return this.content;
    }

    @NotNull
    public String toString() {
        return this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
    }

    @Override
    @NotNull
    public List<File> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    public SimpleOutputFile(@NotNull List<? extends File> sourceFiles, @NotNull String relativePath, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull(sourceFiles, "sourceFiles");
        Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
        Intrinsics.checkParameterIsNotNull(content, "content");
        this.sourceFiles = sourceFiles;
        this.relativePath = relativePath;
        this.content = content;
    }
}

