/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import com.intellij.rt.coverage.util.classFinder.ClassPathEntry;
import com.intellij.util.lang.UrlClassLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

class IdeaClassFinder
extends ClassFinder {
    private static final Logger LOG = Logger.getInstance((String)("#" + IdeaClassFinder.class.getName()));
    private final Project myProject;
    private final CoverageSuitesBundle myCurrentSuite;

    public IdeaClassFinder(Project project, CoverageSuitesBundle currentSuite) {
        super(IdeaClassFinder.obtainPatternsFromSuite(currentSuite), new ArrayList());
        this.myProject = project;
        this.myCurrentSuite = currentSuite;
    }

    private static List<Pattern> obtainPatternsFromSuite(CoverageSuitesBundle currentSuiteBundle) {
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        for (CoverageSuite currentSuite : currentSuiteBundle.getSuites()) {
            for (String pattern : ((JavaCoverageSuite)currentSuite).getFilteredPackageNames()) {
                includePatterns.add(Pattern.compile(pattern + ".*"));
            }
            for (String pattern : ((JavaCoverageSuite)currentSuite).getFilteredClassNames()) {
                includePatterns.add(Pattern.compile(pattern));
            }
        }
        return includePatterns;
    }

    protected Collection getClassPathEntries() {
        Module[] modules;
        Collection entries = super.getClassPathEntries();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
            if (extension == null) continue;
            VirtualFile outputFile = extension.getCompilerOutputPath();
            try {
                VirtualFile testOutput;
                if (outputFile != null) {
                    URL outputURL = VfsUtilCore.virtualToIoFile((VirtualFile)outputFile).toURI().toURL();
                    entries.add(new ClassPathEntry(outputFile.getPath(), (ClassLoader)UrlClassLoader.build().urls(new URL[]{outputURL}).get()));
                }
                if (!this.myCurrentSuite.isTrackTestFolders() || (testOutput = extension.getCompilerOutputPathForTests()) == null) continue;
                URL testOutputURL = VfsUtilCore.virtualToIoFile((VirtualFile)testOutput).toURI().toURL();
                entries.add(new ClassPathEntry(testOutput.getPath(), (ClassLoader)UrlClassLoader.build().urls(new URL[]{testOutputURL}).get()));
            }
            catch (MalformedURLException e1) {
                LOG.error((Throwable)e1);
            }
        }
        return entries;
    }
}

