/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CoverageHelper {
    private CoverageHelper() {
    }

    public static void attachToProcess(@NotNull RunConfigurationBase configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/coverage/CoverageHelper", "attachToProcess"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/coverage/CoverageHelper", "attachToProcess"));
        }
        CoverageHelper.resetCoverageSuit(configuration);
        CoverageDataManager.getInstance(configuration.getProject()).attachToProcess(handler, configuration, runnerSettings);
    }

    public static void resetCoverageSuit(RunConfigurationBase configuration) {
        CoverageEnabledConfiguration covConfig = CoverageEnabledConfiguration.getOrCreate(configuration);
        covConfig.setCurrentCoverageSuite(null);
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(configuration.getProject());
        covConfig.setCurrentCoverageSuite(coverageDataManager.addCoverageSuite(covConfig));
    }

    public static void doReadExternal(RunConfigurationBase runConfiguration, Element element) throws InvalidDataException {
        CoverageEnabledConfiguration covConf = CoverageEnabledConfiguration.getOrCreate(runConfiguration);
        covConf.readExternal(element);
    }

    public static void doWriteExternal(RunConfigurationBase runConfiguration, Element element) throws WriteExternalException {
        CoverageEnabledConfiguration covConf = CoverageEnabledConfiguration.getOrCreate(runConfiguration);
        covConf.writeExternal(element);
    }
}

