/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class WeakList<E>
extends AbstractList<E> {
    private ArrayList<WeakReference<E>> refs = new ArrayList();

    private E deref(WeakReference<E> o) {
        if (o != null) {
            return (E)o.get();
        }
        return null;
    }

    @Override
    public E get(int index) {
        return this.deref(this.refs.get(index));
    }

    @Override
    public int size() {
        return this.refs.size();
    }

    @Override
    public E set(int index, E element) {
        return this.deref(this.refs.set(index, new WeakReference<E>(element)));
    }

    @Override
    public void add(int index, E element) {
        this.refs.add(index, new WeakReference<E>(element));
    }

    @Override
    public E remove(int index) {
        return this.deref(this.refs.remove(index));
    }

    public List<E> hardList() {
        ArrayList<E> result = new ArrayList<E>();
        for (int i = 0; i < this.size(); ++i) {
            E tmp = this.get(i);
            if (tmp == null) continue;
            result.add(tmp);
        }
        return result;
    }

    public void trimToSize() {
        int i = this.size();
        while (i-- > 0) {
            if (this.get(i) != null) continue;
            this.remove(i);
        }
    }
}

