/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;

public class PolicyEntry {
    private final String codebase;
    private final Set<PolicyEditorPermissions> permissions = new HashSet<PolicyEditorPermissions>();
    private final Set<CustomPermission> customPermissions = new HashSet<CustomPermission>();

    public PolicyEntry(String codebase, Collection<PolicyEditorPermissions> permissions, Collection<CustomPermission> customPermissions) {
        this.codebase = codebase == null ? "" : codebase;
        this.permissions.addAll(permissions);
        this.permissions.remove(null);
        this.customPermissions.addAll(customPermissions);
        this.customPermissions.remove(null);
    }

    public String toString() {
        if (this.codebase.isEmpty() && this.permissions.isEmpty() && this.customPermissions.isEmpty()) {
            return "";
        }
        String newline = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(newline);
        result.append("grant");
        if (!this.codebase.isEmpty()) {
            result.append(" codeBase \"");
            result.append(this.codebase);
            result.append("\"");
        }
        result.append(" {");
        result.append(newline);
        for (PolicyEditorPermissions perm : this.permissions) {
            result.append("\t");
            result.append(perm.toPermissionString());
            result.append(newline);
        }
        for (CustomPermission customPerm : this.customPermissions) {
            result.append("\t");
            result.append(customPerm.toString().trim());
            result.append(newline);
        }
        result.append("};");
        result.append(newline);
        return result.toString();
    }
}

