/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteAppletAction;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.security.dialogs.TemporaryPermissionsButton;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningPanel;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.tools.JarCertVerifier;

public class PartiallySignedAppTrustWarningPanel
extends AppTrustWarningPanel {
    private final JarCertVerifier jcv;
    private final JButton sandboxButton;
    private final JButton advancedOptionsButton;

    public PartiallySignedAppTrustWarningPanel(JNLPFile file, AppTrustWarningPanel.ActionChoiceListener actionChoiceListener, SecurityDialog securityDialog, JNLPClassLoader.SecurityDelegate securityDelegate) {
        super(file, actionChoiceListener);
        this.jcv = (JarCertVerifier)securityDialog.getCertVerifier();
        this.INFO_PANEL_HEIGHT = 200;
        this.sandboxButton = new JButton();
        this.sandboxButton.setText(Translator.R("ButSandbox"));
        this.sandboxButton.addActionListener(this.chosenActionSetter(ExecuteAppletAction.SANDBOX));
        this.advancedOptionsButton = new TemporaryPermissionsButton(file, securityDelegate, this.sandboxButton);
        this.buttons.add(1, this.sandboxButton);
        this.buttons.add(2, this.advancedOptionsButton);
        this.addComponents();
    }

    @Override
    protected String getAppletTitle() {
        String title;
        try {
            title = this.file instanceof PluginBridge ? this.file.getTitle() : this.file.getInformation().getTitle();
        }
        catch (Exception e) {
            title = "";
        }
        return Translator.R("SAppletTitle", title);
    }

    private String getAppletInfo() {
        Certificate c = this.jcv.getPublisher(null);
        String publisher = "";
        String from = "";
        try {
            if (c instanceof X509Certificate) {
                publisher = SecurityUtil.getCN(((X509Certificate)c).getSubjectX500Principal().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            from = this.file instanceof PluginBridge ? this.file.getCodeBase().getHost() : this.file.getInformation().getHomepage().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "<br>" + Translator.R("Publisher") + ":  " + publisher + "<br>" + Translator.R("From") + ": " + from;
    }

    private String getSigningInfo() {
        CertInformation info = this.jcv.getCertInformation(this.jcv.getCertPath(null));
        if (info != null && info.isRootInCacerts() && !info.hasSigningIssues()) {
            return Translator.R("SSigVerified");
        }
        if (info != null && info.isRootInCacerts()) {
            return Translator.R("SSigUnverified");
        }
        return Translator.R("SSignatureError");
    }

    @Override
    protected ImageIcon getInfoImage() {
        String location = "net/sourceforge/jnlp/resources/warning.png";
        return new ImageIcon(ClassLoader.getSystemClassLoader().getResource("net/sourceforge/jnlp/resources/warning.png"));
    }

    protected static String getTopPanelTextKey() {
        return "SPartiallySignedSummary";
    }

    protected static String getInfoPanelTextKey() {
        return "SPartiallySignedDetail";
    }

    protected static String getQuestionPanelTextKey() {
        return "SPartiallySignedQuestion";
    }

    @Override
    protected String getTopPanelText() {
        return PartiallySignedAppTrustWarningPanel.htmlWrap(Translator.R(PartiallySignedAppTrustWarningPanel.getTopPanelTextKey()));
    }

    @Override
    protected String getInfoPanelText() {
        String text = this.getAppletInfo();
        text = text + "<br><br>" + Translator.R(PartiallySignedAppTrustWarningPanel.getInfoPanelTextKey(), this.file.getCodeBase(), this.file.getSourceLocation());
        text = text + "<br><br>" + this.getSigningInfo();
        ExecuteAppletAction rememberedAction = UnsignedAppletTrustConfirmation.getStoredAction(this.file);
        if (rememberedAction == ExecuteAppletAction.YES) {
            text = text + "<br>" + Translator.R("SUnsignedAllowedBefore");
        } else if (rememberedAction == ExecuteAppletAction.NO) {
            text = text + "<br>" + Translator.R("SUnsignedRejectedBefore");
        }
        return PartiallySignedAppTrustWarningPanel.htmlWrap(text);
    }

    @Override
    protected String getQuestionPanelText() {
        return PartiallySignedAppTrustWarningPanel.htmlWrap(Translator.R(PartiallySignedAppTrustWarningPanel.getQuestionPanelTextKey()));
    }
}

