/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.Arrays;
import java.util.List;

public class ParserSettings {
    private static ParserSettings globalParserSettings = new ParserSettings();
    private final boolean isStrict;
    private final boolean extensionAllowed;
    private final boolean malformedXmlAllowed;

    public ParserSettings() {
        this(false, true, true);
    }

    public ParserSettings(boolean strict, boolean extensionAllowed, boolean malformedXmlAllowed) {
        this.isStrict = strict;
        this.extensionAllowed = extensionAllowed;
        this.malformedXmlAllowed = malformedXmlAllowed;
    }

    public boolean isExtensionAllowed() {
        return this.extensionAllowed;
    }

    public boolean isMalformedXmlAllowed() {
        return this.malformedXmlAllowed;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public static ParserSettings getGlobalParserSettings() {
        return globalParserSettings;
    }

    public static void setGlobalParserSettings(ParserSettings parserSettings) {
        globalParserSettings = parserSettings;
    }

    public static ParserSettings setGlobalParserSettingsFromArgs(String[] cmdArgs) {
        List<String> argList = Arrays.asList(cmdArgs);
        boolean strict = argList.contains("-strict");
        boolean malformedXmlAllowed = !argList.contains("-xml");
        globalParserSettings = new ParserSettings(strict, true, malformedXmlAllowed);
        return globalParserSettings;
    }
}

