#!/bin/sh
export PATH='/usr/obj/ports/hs-scientific-0.3.3.8/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: scientific
version: 0.3.3.8
id: scientific-0.3.3.8-dfcdc9ad09f428d65befc0a560a69ba3
key: scien_41jKKjOL3MC1wNr2vTak8T
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides a space efficient and arbitrary precision
    scientific number type.
    .
    '\''Scientific'\'' numbers are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>. It
    uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent @e :: '\''Int'\''@ (do
    note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision). A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
exposed-modules:
    Data.Scientific Data.Text.Lazy.Builder.Scientific
    Data.ByteString.Builder.Scientific
hidden-modules: Math.NumberTheory.Logarithms
trusted: False
import-dirs: /usr/local/lib/ghc/scientific-0.3.3.8
library-dirs: /usr/local/lib/ghc/scientific-0.3.3.8
data-dir: /usr/local/share/hs-scientific-0.3.3.8
hs-libraries: HSscientific-0.3.3.8-41jKKjOL3MC1wNr2vTak8T
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
    hashable-1.2.3.3-60475b705ff927627e382b8063d6b2f0
    integer-gmp-1.0.0.0-3c8c40657a9870f5c33be17496806d8d
    text-1.2.1.3-d050b6e0fc32994b2ea423ca0ac22057
haddock-interfaces: /usr/local/share/doc/hs-scientific-0.3.3.8/html/scientific.haddock
haddock-html: /usr/local/share/doc/hs-scientific-0.3.3.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
