/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int offset = this.bitOffset;
            int partial = this.read();
            if (partial < 0) {
                partial = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
                partial &= -1 << 8 - offset;
            }
            this.write(partial);
        }
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(int var1) throws IOException;

    public void writeBit(int bit) throws IOException {
        this.writeBits(1L & (long)bit, 1);
    }

    public void writeBits(long bits, int numBits) throws IOException {
        int shift;
        this.checkClosed();
        if (this.getStreamPosition() > 0L || this.bitOffset > 0) {
            int mask;
            int offs = this.bitOffset;
            int partial = this.read();
            if (partial != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                partial = 0;
            }
            if (numBits + offs < 8) {
                shift = 8 - (offs + numBits);
                mask = -1 >>> 32 - numBits;
                partial &= ~(mask << shift);
                partial = (int)((long)partial | (bits & (long)mask) << shift);
                this.write(partial);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = offs + numBits;
                numBits = 0;
            } else {
                int num = 8 - offs;
                mask = -1 >>> 32 - num;
                partial &= ~mask;
                partial = (int)((long)partial | bits >> numBits - num & (long)mask);
                this.write(partial);
                numBits -= num;
            }
        }
        if (numBits > 7) {
            int remaining = numBits % 8;
            int numBytes = numBits / 8;
            while (numBytes > 0) {
                shift = (numBytes - 1) * 8 + remaining;
                int value = (int)(shift == 0 ? bits & 0xFFL : bits >> shift & 0xFFL);
                this.write(value);
                --numBytes;
            }
            numBits = remaining;
        }
        if (numBits != 0) {
            int partial = this.read();
            if (partial == -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                partial = 0;
            }
            int shift2 = 8 - numBits;
            int mask = -1 >>> 32 - numBits;
            partial &= ~(mask << shift2);
            partial = (int)((long)partial | (bits & (long)mask) << shift2);
            this.write(partial);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = numBits;
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeByte(value ? 1 : 0);
    }

    public void writeByte(int value) throws IOException {
        this.write(value & 0xFF);
    }

    public void writeBytes(String data) throws IOException {
        int len = data.length();
        int i = 0;
        while (i < len) {
            this.writeByte(data.charAt(i));
            ++i;
        }
    }

    public void writeChar(int value) throws IOException {
        this.writeShort(value);
    }

    public void writeChars(char[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeChar(data[offset + i]);
            ++len;
        }
    }

    public void writeChars(String data) throws IOException {
        int len = data.length();
        int i = 0;
        while (i < len) {
            this.writeChar(data.charAt(i));
            ++i;
        }
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeDoubles(double[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeDouble(data[offset + i]);
            ++len;
        }
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeFloats(float[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeFloat(data[offset + i]);
            ++len;
        }
    }

    public void writeInt(int value) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.buffer[2] = (byte)(value >> 16);
            this.buffer[3] = (byte)(value >> 24);
        } else {
            this.buffer[0] = (byte)(value >> 24);
            this.buffer[1] = (byte)(value >> 16);
            this.buffer[2] = (byte)(value >> 8);
            this.buffer[3] = (byte)value;
        }
        this.write(this.buffer, 0, 4);
    }

    public void writeInts(int[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeInt(data[offset + i]);
            ++len;
        }
    }

    public void writeLong(long value) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.buffer[2] = (byte)(value >> 16);
            this.buffer[3] = (byte)(value >> 24);
            this.buffer[4] = (byte)(value >> 32);
            this.buffer[5] = (byte)(value >> 40);
            this.buffer[6] = (byte)(value >> 48);
            this.buffer[7] = (byte)(value >> 56);
        } else {
            this.buffer[0] = (byte)(value >> 56);
            this.buffer[1] = (byte)(value >> 48);
            this.buffer[2] = (byte)(value >> 40);
            this.buffer[3] = (byte)(value >> 32);
            this.buffer[4] = (byte)(value >> 24);
            this.buffer[5] = (byte)(value >> 16);
            this.buffer[6] = (byte)(value >> 8);
            this.buffer[7] = (byte)value;
        }
        this.write(this.buffer, 0, 8);
    }

    public void writeLongs(long[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeLong(data[offset + i]);
            ++len;
        }
    }

    public void writeShort(int value) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
        } else {
            this.buffer[0] = (byte)(value >> 8);
            this.buffer[1] = (byte)value;
        }
        this.write(this.buffer, 0, 2);
    }

    public void writeShorts(short[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeShort(data[offset + i]);
            ++len;
        }
    }

    public void writeUTF(String value) throws IOException {
        int len = value.length();
        int sum = 0;
        int i = 0;
        while (i < len && sum <= 65535) {
            char c = value.charAt(i);
            sum = c >= '\u0001' && c <= '\u007f' ? ++sum : (c == '\u0000' || c >= '\u0080' && c <= '\u07ff' ? (sum += 2) : (sum += 3));
            ++i;
        }
        if (sum > 65535) {
            throw new UTFDataFormatException();
        }
        int pos = 0;
        byte[] buf = new byte[sum];
        int i2 = 0;
        while (i2 < len) {
            char c = value.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                buf[pos++] = (byte)c;
            } else if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                buf[pos++] = (byte)(0x80 | 0x3F & c);
            } else {
                buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                buf[pos++] = (byte)(0x80 | 0x3F & c);
            }
            ++i2;
        }
        this.writeShort(sum);
        this.write(buf, 0, sum);
    }
}

