/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
extends AbstractStringBuffer
implements Serializable,
CharSequence,
Appendable {
    private static final long serialVersionUID = 3388685877147921107L;
    boolean shared;

    public StringBuffer() {
    }

    public StringBuffer(int capacity) {
        super(capacity);
    }

    public StringBuffer(String str) {
        super(str);
    }

    public StringBuffer(CharSequence seq) {
        super(seq);
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        this.ensureCapacity_unsynchronized(minimumCapacity);
    }

    public synchronized void setLength(int newLength) {
        super.setLength(newLength);
    }

    public synchronized char charAt(int index) {
        return super.charAt(index);
    }

    public synchronized int codePointAt(int index) {
        return super.codePointAt(index);
    }

    public synchronized int codePointBefore(int index) {
        return super.codePointBefore(index);
    }

    public synchronized void getChars(int srcOffset, int srcEnd, char[] dst, int dstOffset) {
        super.getChars(srcOffset, srcEnd, dst, dstOffset);
    }

    public synchronized void setCharAt(int index, char ch) {
        super.setCharAt(index, ch);
    }

    public synchronized StringBuffer append(Object obj) {
        super.append(obj);
        return this;
    }

    public synchronized StringBuffer append(String str) {
        super.append(str);
        return this;
    }

    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        super.append(stringBuffer);
        return this;
    }

    public synchronized StringBuffer append(char[] data) {
        super.append(data, 0, data.length);
        return this;
    }

    public synchronized StringBuffer append(char[] data, int offset, int count) {
        super.append(data, offset, count);
        return this;
    }

    public synchronized StringBuffer append(boolean bool) {
        super.append(bool);
        return this;
    }

    public synchronized StringBuffer append(char ch) {
        super.append(ch);
        return this;
    }

    public synchronized StringBuffer append(CharSequence seq) {
        super.append(seq, 0, seq.length());
        return this;
    }

    public synchronized StringBuffer append(CharSequence seq, int start, int end) {
        super.append(seq, start, end);
        return this;
    }

    public synchronized StringBuffer append(int inum) {
        super.append(inum);
        return this;
    }

    public synchronized StringBuffer append(long lnum) {
        super.append(lnum);
        return this;
    }

    public synchronized StringBuffer append(float fnum) {
        super.append(fnum);
        return this;
    }

    public synchronized StringBuffer append(double dnum) {
        super.append(dnum);
        return this;
    }

    public synchronized StringBuffer appendCodePoint(int code) {
        super.appendCodePoint(code);
        return this;
    }

    public synchronized StringBuffer delete(int start, int end) {
        super.delete(start, end);
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int index) {
        super.deleteCharAt(index);
        return this;
    }

    public synchronized StringBuffer replace(int start, int end, String str) {
        super.replace(start, end, str);
        return this;
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.count);
    }

    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public synchronized String substring(int beginIndex, int endIndex) {
        boolean share_buffer;
        int len = endIndex - beginIndex;
        if (beginIndex < 0 || endIndex > this.count || endIndex < beginIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len == 0) {
            return "";
        }
        boolean bl = share_buffer = len << 2 >= this.value.length;
        if (share_buffer) {
            this.shared = true;
        }
        return new String(this.value, beginIndex, len, share_buffer);
    }

    public synchronized StringBuffer insert(int offset, char[] str, int str_offset, int len) {
        super.insert(offset, str, str_offset, len);
        return this;
    }

    public synchronized StringBuffer insert(int offset, Object obj) {
        super.insert(offset, obj);
        return this;
    }

    public synchronized StringBuffer insert(int offset, String str) {
        super.insert(offset, str);
        return this;
    }

    public synchronized StringBuffer insert(int offset, CharSequence sequence) {
        super.insert(offset, sequence);
        return this;
    }

    public synchronized StringBuffer insert(int offset, CharSequence sequence, int start, int end) {
        super.insert(offset, sequence, start, end);
        return this;
    }

    public synchronized StringBuffer insert(int offset, char[] data) {
        super.insert(offset, data, 0, data.length);
        return this;
    }

    public synchronized StringBuffer insert(int offset, boolean bool) {
        super.insert(offset, bool);
        return this;
    }

    public synchronized StringBuffer insert(int offset, char ch) {
        super.insert(offset, ch);
        return this;
    }

    public synchronized StringBuffer insert(int offset, int inum) {
        super.insert(offset, inum);
        return this;
    }

    public synchronized StringBuffer insert(int offset, long lnum) {
        super.insert(offset, lnum);
        return this;
    }

    public synchronized StringBuffer insert(int offset, float fnum) {
        super.insert(offset, fnum);
        return this;
    }

    public synchronized StringBuffer insert(int offset, double dnum) {
        super.insert(offset, dnum);
        return this;
    }

    public synchronized int indexOf(String str) {
        return super.indexOf(str, 0);
    }

    public synchronized int indexOf(String str, int fromIndex) {
        return super.indexOf(str, fromIndex);
    }

    public synchronized int lastIndexOf(String str) {
        return super.lastIndexOf(str, this.count - str.count);
    }

    public synchronized int lastIndexOf(String str, int fromIndex) {
        return super.lastIndexOf(str, fromIndex);
    }

    public synchronized StringBuffer reverse() {
        super.reverse();
        return this;
    }

    public String toString() {
        return new String(this);
    }

    public synchronized void trimToSize() {
        super.trimToSize();
    }

    public synchronized int codePointCount(int start, int end) {
        return super.codePointCount(start, end);
    }

    public synchronized int offsetByCodePoints(int start, int codePoints) {
        return super.offsetByCodePoints(start, codePoints);
    }

    void ensureCapacity_unsynchronized(int minimumCapacity) {
        if (this.shared || minimumCapacity > this.value.length) {
            int max = minimumCapacity > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            minimumCapacity = minimumCapacity < max ? max : minimumCapacity;
            char[] nb = new char[minimumCapacity];
            System.arraycopy(this.value, 0, nb, 0, this.count);
            this.value = nb;
            this.shared = false;
        }
    }
}

