/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class HexBinaryType
extends AtomicSimpleType {
    static final String HEX = "0123456789ABCDEF";
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    HexBinaryType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "hexBinary"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (HEX.indexOf(c) == -1) {
                throw new DatatypeException(i, "invalid hexBinary value");
            }
            ++i;
        }
    }
}

