/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Node;

public class Bindings
implements XPathVariableResolver,
Cloneable {
    static final int VARIABLE = 0;
    static final int PARAM = 1;
    static final int WITH_PARAM = 2;
    final Stylesheet stylesheet;
    final LinkedList<Map<QName, Object>> variables;
    final LinkedList<Map<QName, Object>> parameters;
    final LinkedList<Map<QName, Object>> withParameters;
    boolean global;

    Bindings(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
        this.variables = new LinkedList();
        this.parameters = new LinkedList();
        this.withParameters = new LinkedList();
        int i = 0;
        while (i < 3) {
            this.push(i);
            ++i;
        }
    }

    public Object clone() {
        try {
            return (Bindings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.getMessage());
        }
    }

    void push(int type) {
        switch (type) {
            case 0: {
                this.variables.addFirst(new HashMap());
                break;
            }
            case 1: {
                this.parameters.addFirst(new HashMap());
                break;
            }
            case 2: {
                this.withParameters.addFirst(new HashMap());
            }
        }
    }

    void pop(int type) {
        switch (type) {
            case 0: {
                this.variables.removeFirst();
                break;
            }
            case 1: {
                this.parameters.removeFirst();
                break;
            }
            case 2: {
                this.withParameters.removeFirst();
            }
        }
    }

    public boolean containsKey(QName name, int type) {
        if (this.global) {
            Map<QName, Object> ctx1 = this.variables.getLast();
            Map<QName, Object> ctx2 = this.parameters.getLast();
            return ctx1.containsKey(name) || ctx2.containsKey(name);
        }
        Iterator i = null;
        switch (type) {
            case 0: {
                i = this.variables.iterator();
                break;
            }
            case 1: {
                i = this.parameters.iterator();
                break;
            }
            case 2: {
                Map<QName, Object> ctx = this.withParameters.getFirst();
                return ctx.containsKey(name);
            }
        }
        if (i != null) {
            while (i.hasNext()) {
                Map ctx = (Map)i.next();
                if (!ctx.containsKey(name)) continue;
                return true;
            }
        }
        return false;
    }

    public Object get(QName name, Node context, int pos, int len) {
        Iterator i;
        if (this.global) {
            Map<QName, Object> ctx = this.variables.getLast();
            Object ret = ctx.get(name);
            if (ret == null) {
                ctx = this.parameters.getLast();
                ret = ctx.get(name);
            }
            return ret;
        }
        Set<Object> ret = null;
        Map<QName, Object> cwp = this.withParameters.getFirst();
        ret = cwp.get(name);
        if (ret == null) {
            i = this.variables.iterator();
            while (i.hasNext() && ret == null) {
                Map vctx = (Map)i.next();
                ret = vctx.get(name);
            }
        }
        if (ret == null) {
            i = this.parameters.iterator();
            while (i.hasNext() && ret == null) {
                Map pctx = (Map)i.next();
                ret = pctx.get(name);
            }
        }
        if (ret instanceof Node) {
            ret = Collections.singleton(ret);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    void set(QName name, Object value, int type) {
        switch (type) {
            case 0: {
                Map<QName, Object> vctx = this.variables.getFirst();
                vctx.put(name, value);
                break;
            }
            case 1: {
                Map<QName, Object> pctx = this.parameters.getFirst();
                pctx.put(name, value);
                break;
            }
            case 2: {
                Map<QName, Object> wctx = this.withParameters.getFirst();
                wctx.put(name, value);
            }
        }
    }

    public Object resolveVariable(QName qName) {
        return this.get(qName, null, 1, 1);
    }

    public String toString() {
        QName key;
        CPStringBuilder buf = new CPStringBuilder();
        boolean next = false;
        HashSet seen = new HashSet();
        Map<QName, Object> wctx = this.withParameters.getFirst();
        buf.append('(');
        for (Map.Entry<QName, Object> entry : wctx.entrySet()) {
            if (next) {
                buf.append(',');
            } else {
                next = true;
            }
            QName key2 = entry.getKey();
            if (seen.contains(key2)) continue;
            buf.append(key2);
            buf.append('=');
            buf.append(entry.getValue());
            seen.add(key2);
        }
        buf.append(')');
        next = false;
        seen.clear();
        buf.append('{');
        for (Map map : this.variables) {
            for (Map.Entry entry : map.entrySet()) {
                if (next) {
                    buf.append(',');
                } else {
                    next = true;
                }
                key = (QName)entry.getKey();
                if (seen.contains(key)) continue;
                buf.append(key);
                buf.append('=');
                buf.append(entry.getValue());
                seen.add(key);
            }
        }
        buf.append('}');
        next = false;
        seen.clear();
        buf.append('[');
        for (Map map : this.parameters) {
            for (Map.Entry entry : map.entrySet()) {
                if (next) {
                    buf.append(',');
                } else {
                    next = true;
                }
                key = (QName)entry.getKey();
                if (seen.contains(key)) continue;
                buf.append(key);
                buf.append('=');
                buf.append(entry.getValue());
                seen.add(key);
            }
        }
        buf.append(']');
        return buf.toString();
    }
}

