/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.swing.text.html.parser.htmlAttributeSet;
import gnu.javax.swing.text.html.parser.models.node;
import gnu.javax.swing.text.html.parser.models.transformer;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.TagElement;

public abstract class htmlValidator {
    protected final DTD dtd;
    protected final LinkedList stack = new LinkedList();

    public htmlValidator(DTD a_dtd) {
        this.dtd = a_dtd;
    }

    public void closeAll() {
        while (!this.stack.isEmpty()) {
            hTag h = (hTag)this.stack.getLast();
            if (!h.forcibly_closed && !h.element.omitEnd()) {
                this.s_error("Unclosed <" + h.tag + ">, closing at the end of stream");
            }
            this.handleSupposedEndTag(h.element);
            this.closeTag(h.tgElement);
        }
    }

    public boolean closeTag(TagElement tElement) {
        HTML.Tag tag = tElement.getHTMLTag();
        if (!this.stack.isEmpty()) {
            ListIterator iter = this.stack.listIterator(this.stack.size());
            while (iter.hasPrevious()) {
                hTag x = (hTag)iter.previous();
                if (!tag.equals(x.tag)) continue;
                if (x.forcibly_closed && !x.element.omitEnd()) {
                    this.s_error("The tag <" + x.tag + "> has already been forcibly closed");
                }
                if (x.element.content != null) {
                    iter = this.stack.listIterator(this.stack.size());
                    while (iter.hasPrevious()) {
                        hTag close = (hTag)iter.previous();
                        if (close == x) break;
                        this.handleSupposedEndTag(close.element);
                        iter.remove();
                    }
                }
                this.stack.remove(x);
                return true;
            }
        }
        this.s_error("Closing unopened <" + tag + ">");
        return false;
    }

    public void openTag(TagElement tElement, htmlAttributeSet parameters) {
        Object v;
        if (tElement.fictional()) {
            return;
        }
        this.validateParameters(tElement, parameters);
        if (this.stack.isEmpty() && tElement.getHTMLTag() != HTML.Tag.HTML) {
            Element html = this.dtd.getElement(HTML.Tag.HTML.toString());
            this.openFictionalTag(html);
        }
        if ((v = this.tagIsValidForContext(tElement)) != Boolean.TRUE) {
            if (v instanceof Element) {
                int n = 0;
                while (v instanceof Element && n++ < 100) {
                    Element fe = (Element)v;
                    node ccm = this.getCurrentContentModel();
                    if (ccm != null) {
                        ccm.show(fe);
                    }
                    this.openFictionalTag(fe);
                    Object vv = this.tagIsValidForContext(tElement);
                    if (vv instanceof Element) {
                        this.openFictionalTag((Element)vv);
                        Object vx = this.tagIsValidForContext(tElement);
                        if (vx instanceof Element) {
                            this.openFictionalTag((Element)vx);
                        }
                    } else if (vv == Boolean.FALSE && fe.omitEnd()) {
                        this.closeLast();
                        vv = this.tagIsValidForContext(tElement);
                        if (vv instanceof Element) {
                            this.openFictionalTag((Element)vv);
                        }
                    }
                    v = this.tagIsValidForContext(tElement);
                }
            } else if (!this.stack.isEmpty()) {
                do {
                    hTag last = (hTag)this.stack.getLast();
                    if (!last.element.omitEnd()) break;
                    this.closeLast();
                    v = this.tagIsValidForContext(tElement);
                    if (!(v instanceof Element)) continue;
                    this.openFictionalTag((Element)v);
                    break;
                } while (v == Boolean.FALSE && !this.stack.isEmpty());
            }
        }
        this.stack.add(new hTag(tElement));
    }

    public void restart() {
        this.stack.clear();
    }

    public Object tagIsValidForContext(TagElement tElement) {
        node cv = this.getCurrentContentModel();
        if (cv != null) {
            return cv.show(tElement.getElement());
        }
        ListIterator iter = this.stack.listIterator(this.stack.size());
        hTag t = null;
        int idx = tElement.getElement().index;
        if (idx >= 0) {
            BitSet inclusions = new BitSet();
            while (iter.hasPrevious()) {
                t = (hTag)iter.previous();
                if (t.forcibly_closed) continue;
                if (t.element.exclusions != null && t.element.exclusions.get(idx)) {
                    return Boolean.FALSE;
                }
                if (t.element.inclusions == null) continue;
                inclusions.or(t.element.inclusions);
            }
            if (!inclusions.get(idx)) {
                Element P = this.dtd.getElement("p");
                if (inclusions.get(P.index)) {
                    return P;
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public void validateTag(TagElement tElement, htmlAttributeSet parameters) {
        this.openTag(tElement, parameters);
        this.closeTag(tElement);
    }

    protected void checkContentModel(TagElement tElement, boolean first) {
        if (this.stack.isEmpty()) {
            return;
        }
        hTag last = (hTag)this.stack.getLast();
        if (last.validationTrace == null) {
            return;
        }
        Object r = last.validationTrace.show(tElement.getElement());
        if (r == Boolean.FALSE) {
            this.s_error("The <" + last.element + "> does not match the content model " + last.validationTrace);
        } else if (r instanceof Element) {
            if (!first) {
                this.closeTag(last.tgElement);
            }
            this.handleSupposedStartTag((Element)r);
            this.openTag(new TagElement((Element)r), null);
        }
    }

    protected abstract void handleSupposedEndTag(Element var1);

    protected abstract void handleSupposedStartTag(Element var1);

    protected abstract void s_error(String var1);

    protected void validateParameters(TagElement tag, htmlAttributeSet parameters) {
        if (parameters == null || parameters == htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET || parameters == SimpleAttributeSet.EMPTY) {
            return;
        }
        Enumeration enumeration = parameters.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.validateAttribute(tag, parameters, enumeration);
        }
        AttributeList a = tag.getElement().getAttributes();
        while (a != null) {
            if (a.getModifier() == 2 && parameters.getAttribute(a.getName()) == null) {
                this.s_error("Missing required attribute '" + a.getName() + "' for <" + tag.getHTMLTag() + ">");
            }
            a = a.next;
        }
    }

    private node getCurrentContentModel() {
        if (!this.stack.isEmpty()) {
            hTag last = (hTag)this.stack.getLast();
            return last.validationTrace;
        }
        return null;
    }

    private void closeLast() {
        this.handleSupposedEndTag(((hTag)this.stack.getLast()).element);
        this.stack.removeLast();
    }

    private void openFictionalTag(Element e) {
        this.handleSupposedStartTag(e);
        this.stack.add(new hTag(new TagElement(e, true)));
        if (!e.omitStart()) {
            this.s_error("<" + e + "> is expected (supposing it)");
        }
    }

    private void validateAttribute(TagElement tag, htmlAttributeSet parameters, Enumeration enumeration) {
        Object foundAttribute = enumeration.nextElement();
        AttributeList dtdAttribute = tag.getElement().getAttribute(foundAttribute.toString());
        if (dtdAttribute == null) {
            CPStringBuilder valid = new CPStringBuilder("The tag <" + tag.getHTMLTag() + "> cannot contain the attribute '" + foundAttribute + "'. The valid attributes for this tag are: ");
            AttributeList a = tag.getElement().getAttributes();
            while (a != null) {
                valid.append(a.name.toUpperCase());
                valid.append(' ');
                a = a.next;
            }
            this.s_error(valid.toString());
        } else {
            String value = parameters.getAttribute(foundAttribute).toString();
            if (dtdAttribute.type == 12) {
                this.validateNumberAttribute(tag, foundAttribute, value);
            }
            if (dtdAttribute.type == 7 || dtdAttribute.type == 4) {
                this.validateNameOrIdAttribute(tag, foundAttribute, value);
            }
            if (dtdAttribute.values != null) {
                this.validateAttributeWithValueList(tag, foundAttribute, dtdAttribute, value);
            }
        }
    }

    private void validateAttributeWithValueList(TagElement tag, Object foundAttribute, AttributeList dtdAttribute, String value) {
        if (!dtdAttribute.values.contains(value.toLowerCase()) && !dtdAttribute.values.contains(value.toUpperCase())) {
            CPStringBuilder valid = dtdAttribute.values.size() == 1 ? new CPStringBuilder("The attribute '" + foundAttribute + "' of the tag <" + tag.getHTMLTag() + "> cannot have the value '" + value + "'. The only valid value is ") : new CPStringBuilder("The attribute '" + foundAttribute + "' of the tag <" + tag.getHTMLTag() + "> cannot have the value '" + value + "'. The " + dtdAttribute.values.size() + " valid values are: ");
            Enumeration<?> vv = dtdAttribute.values.elements();
            while (vv.hasMoreElements()) {
                valid.append('\"');
                valid.append(vv.nextElement());
                valid.append("\"  ");
            }
            this.s_error(valid.toString());
        }
    }

    private void validateNameOrIdAttribute(TagElement tag, Object foundAttribute, String value) {
        boolean ok = true;
        if (!Character.isLetter(value.charAt(0))) {
            ok = false;
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && "".indexOf(c) < 0) {
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            this.s_error("The '" + foundAttribute + "' attribute of the tag <" + tag.getHTMLTag() + "> must start from letter and consist of " + "letters, digits, hypens, colons, underscores and periods. " + "It cannot be '" + value + "'");
        }
    }

    private void validateNumberAttribute(TagElement tag, Object foundAttribute, String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.s_error("The '" + foundAttribute + "' attribute of the tag <" + tag.getHTMLTag() + "> must be a valid number and not '" + value + "'");
        }
    }

    protected class hTag {
        protected final Element element;
        protected final HTML.Tag tag;
        protected final TagElement tgElement;
        protected boolean forcibly_closed;
        protected node validationTrace;

        protected hTag(TagElement an_element) {
            this.element = an_element.getElement();
            this.tag = an_element.getHTMLTag();
            this.tgElement = an_element;
            if (this.element.content != null) {
                this.validationTrace = transformer.transform(this.element.content, htmlValidator.this.dtd);
            }
        }

        protected void forciblyCloseDueContext() {
            this.forcibly_closed = true;
        }

        protected void forciblyCloseDueEndOfStream() {
            this.forcibly_closed = true;
            htmlValidator.this.handleSupposedEndTag(this.element);
        }
    }
}

