/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainSocketImpl;
import gnu.java.nio.PipeImpl;
import gnu.java.nio.channels.FileChannelImpl;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VMChannel {
    private final int fd;

    static {
        VMChannel.initIDs();
    }

    private VMChannel(int fd) {
        this.fd = fd;
    }

    public static VMChannel getVMChannel(PlainSocketImpl socket) {
        return new VMChannel(socket.getNativeFD());
    }

    public static VMChannel getVMChannel(PipeImpl.SourceChannelImpl source) {
        return new VMChannel(source.getNativeFD());
    }

    public static VMChannel getVMChannel(PipeImpl.SinkChannelImpl sink) {
        return new VMChannel(sink.getNativeFD());
    }

    public static VMChannel getVMChannel(FileChannelImpl file) {
        return new VMChannel(file.getNativeFD());
    }

    public native void setBlocking(int var1, boolean var2);

    public void setBlocking(boolean blocking) {
        this.setBlocking(this.fd, blocking);
    }

    native int read(int var1, ByteBuffer var2) throws IOException;

    public int read(ByteBuffer dst) throws IOException {
        return this.read(this.fd, dst);
    }

    native long readScattering(int var1, ByteBuffer[] var2, int var3, int var4) throws IOException;

    public long readScattering(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset + length > dsts.length) {
            throw new IndexOutOfBoundsException("offset + length > dsts.length");
        }
        return this.readScattering(this.fd, dsts, offset, length);
    }

    native int write(int var1, ByteBuffer var2) throws IOException;

    public int write(ByteBuffer src) throws IOException {
        return this.write(this.fd, src);
    }

    native long writeGathering(int var1, ByteBuffer[] var2, int var3, int var4) throws IOException;

    public long writeGathering(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset + length > srcs.length) {
            throw new IndexOutOfBoundsException("offset + length > srcs.length");
        }
        return this.writeGathering(this.fd, srcs, offset, length);
    }

    private static native void initIDs();
}

