/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.loader;

import gnu.java.net.loader.JarURLLoader;
import gnu.java.net.loader.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;

public final class JarURLResource
extends Resource {
    private final JarEntry entry;
    private final String name;

    public JarURLResource(JarURLLoader loader, String name, JarEntry entry) {
        super(loader);
        this.entry = entry;
        this.name = name;
    }

    public InputStream getInputStream() throws IOException {
        return ((JarURLLoader)this.loader).jarfile.getInputStream(this.entry);
    }

    public int getLength() {
        return (int)this.entry.getSize();
    }

    public Certificate[] getCertificates() {
        return ((JarEntry)((JarURLLoader)this.loader).jarfile.getEntry(this.name)).getCertificates();
    }

    public URL getURL() {
        try {
            return new URL(((JarURLLoader)this.loader).baseJarURL, this.name, this.loader.cache.get(this.loader.factory, "jar"));
        }
        catch (MalformedURLException e) {
            InternalError ie = new InternalError();
            ie.initCause(e);
            throw ie;
        }
    }
}

