/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractElementHandler;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.ConstructorContext;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.ElementHandler;
import gnu.java.beans.decoder.IndexContext;
import gnu.java.beans.decoder.MethodContext;
import gnu.java.beans.decoder.ObjectContext;
import gnu.java.beans.decoder.PropertyContext;
import gnu.java.beans.decoder.StaticMethodContext;
import java.beans.ExceptionListener;
import org.xml.sax.Attributes;

public class ObjectHandler
extends AbstractElementHandler {
    ObjectHandler(ElementHandler parent) {
        super(parent, true);
    }

    protected Context startElement(Attributes attributes, ExceptionListener exceptionListener) throws AssemblyException {
        String className = attributes.getValue("class");
        String methodName = attributes.getValue("method");
        String fieldName = attributes.getValue("field");
        String index = attributes.getValue("index");
        String propertyName = attributes.getValue("property");
        String id = attributes.getValue("id");
        String idRef = attributes.getValue("idref");
        if (idRef != null) {
            return new ObjectContext(id, this.getObject(idRef));
        }
        if (className != null) {
            try {
                Class klass = this.instantiateClass(className);
                if (fieldName != null) {
                    try {
                        return new ObjectContext(id, klass.getField(fieldName).get(null));
                    }
                    catch (NoSuchFieldException nsfe) {
                        throw new AssemblyException(nsfe);
                    }
                    catch (IllegalAccessException iae) {
                        throw new AssemblyException(iae);
                    }
                }
                if (methodName == null || methodName.equals("new")) {
                    return new ConstructorContext(id, klass);
                }
                return new StaticMethodContext(id, klass, methodName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssemblyException(cnfe);
            }
        }
        if (index != null) {
            try {
                return new IndexContext(id, Integer.parseInt(index));
            }
            catch (NumberFormatException nfe) {
                throw new AssemblyException(nfe);
            }
        }
        if (methodName != null) {
            return new MethodContext(id, methodName);
        }
        if (propertyName != null && propertyName.length() > 0) {
            return new PropertyContext(id, propertyName);
        }
        throw new AssemblyException(new IllegalArgumentException("Wrong or missing attributes for <object> tag."));
    }
}

