/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.Segment;
import java.awt.geom.Point2D;

public class LineSegment
extends Segment {
    public LineSegment(double x1, double y1, double x2, double y2) {
        this.P1 = new Point2D.Double(x1, y1);
        this.P2 = new Point2D.Double(x2, y2);
    }

    public LineSegment(Point2D p1, Point2D p2) {
        this.P1 = (Point2D)p1.clone();
        this.P2 = (Point2D)p2.clone();
    }

    public Object clone() {
        LineSegment segment = null;
        try {
            segment = (LineSegment)super.clone();
            segment.P1 = (Point2D)this.P1.clone();
            segment.P2 = (Point2D)this.P2.clone();
        }
        catch (CloneNotSupportedException cnse) {
            InternalError ie = new InternalError();
            ie.initCause(cnse);
            throw ie;
        }
        return segment;
    }

    public Segment[] getDisplacedSegments(double radius) {
        this.radius = radius;
        double x0 = this.P1.getX();
        double y0 = this.P1.getY();
        double x1 = this.P2.getX();
        double y1 = this.P2.getY();
        double[] p = this.normal(x0, y0, x1, y1);
        LineSegment s1 = new LineSegment(x0 + p[0], y0 + p[1], x1 + p[0], y1 + p[1]);
        LineSegment s2 = new LineSegment(x0 - p[0], y0 - p[1], x1 - p[0], y1 - p[1]);
        return new Segment[]{s1, s2};
    }

    public void reverse() {
        Point2D p = this.P1;
        this.P1 = this.P2;
        this.P2 = p;
    }

    public double[] cp1() {
        return new double[]{this.P2.getX(), this.P2.getY()};
    }

    public double[] cp2() {
        return new double[]{this.P1.getX(), this.P1.getY()};
    }
}

