/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import java.awt.FontFormatException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

final class GlyphMeasurer {
    private final ShortBuffer horizontalGlyphMetrics;
    private final ShortBuffer verticalGlyphMetrics;
    private final int numLongHorizontalMetricsEntries;
    private final int numLongVerticalMetricsEntries;
    private final int horizontalAscent;
    private final int verticalAscent;
    private final int horizontalDescent;
    private final int verticalDescent;
    private final int horizontalLineGap;

    GlyphMeasurer(ByteBuffer hhea, ByteBuffer hmtx, ByteBuffer vhea, ByteBuffer vmtx) throws FontFormatException {
        if (hhea.getInt(0) != 65536 || hhea.getInt(30) != 0) {
            throw new FontFormatException("unsupported hhea format");
        }
        this.horizontalAscent = hhea.getShort(4);
        this.horizontalDescent = hhea.getShort(6);
        this.horizontalLineGap = hhea.getShort(8);
        this.numLongHorizontalMetricsEntries = hhea.getChar(34);
        this.horizontalGlyphMetrics = hmtx.asShortBuffer();
        if (vhea != null) {
            this.verticalAscent = vhea.getShort(4);
            this.verticalDescent = vhea.getShort(6);
            this.numLongVerticalMetricsEntries = vhea.getChar(34);
            this.verticalGlyphMetrics = vmtx.asShortBuffer();
        } else {
            this.verticalAscent = hhea.getChar(10) / 2;
            this.verticalDescent = -this.verticalAscent;
            this.numLongVerticalMetricsEntries = 0;
            this.verticalGlyphMetrics = null;
        }
    }

    public int getAscent(boolean horizontal) {
        return horizontal ? this.horizontalAscent : this.verticalAscent;
    }

    public int getDescent(boolean horizontal) {
        return horizontal ? this.horizontalDescent : this.verticalDescent;
    }

    public int getLineGap(boolean horizontal) {
        return this.horizontalLineGap;
    }

    public int getAdvanceWidth(int glyphIndex, boolean horizontal) {
        if (!horizontal) {
            return 0;
        }
        glyphIndex = Math.min(glyphIndex, this.numLongHorizontalMetricsEntries - 1);
        return this.horizontalGlyphMetrics.get(glyphIndex << 1);
    }

    public int getAdvanceHeight(int glyphIndex, boolean horizontal) {
        if (horizontal) {
            return 0;
        }
        if (this.verticalGlyphMetrics == null) {
            return this.horizontalAscent - this.horizontalDescent + this.horizontalLineGap;
        }
        glyphIndex = Math.min(glyphIndex, this.numLongVerticalMetricsEntries - 1);
        return this.verticalGlyphMetrics.get(glyphIndex << 1);
    }
}

