/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorSpaceConverter;

public class SrgbConverter
implements ColorSpaceConverter {
    public float[] fromCIEXYZ(float[] in) {
        return SrgbConverter.XYZtoRGB(in);
    }

    public float[] toCIEXYZ(float[] in) {
        return SrgbConverter.RGBtoXYZ(in);
    }

    public float[] toRGB(float[] in) {
        float[] out = new float[3];
        System.arraycopy(in, 0, out, 0, 3);
        return out;
    }

    public float[] fromRGB(float[] in) {
        float[] out = new float[3];
        System.arraycopy(in, 0, out, 0, 3);
        return out;
    }

    public static float[] XYZtoRGB(float[] in) {
        float[] temp = new float[]{3.1338f * in[0] - 1.6171f * in[1] - 0.4907f * in[2], -0.9785f * in[0] + 1.916f * in[1] + 0.0334f * in[2], 0.072f * in[0] - 0.229f * in[1] + 1.4056f * in[2]};
        float[] out = new float[3];
        int i = 0;
        while (i < 3) {
            if (temp[i] < 0.0f) {
                temp[i] = 0.0f;
            }
            if (temp[i] > 1.0f) {
                temp[i] = 1.0f;
            }
            out[i] = temp[i] <= 0.00304f ? temp[i] * 12.92f : 1.055f * (float)Math.exp(0.4166666666666667 * Math.log(temp[i])) - 0.055f;
            ++i;
        }
        return out;
    }

    public static float[] RGBtoXYZ(float[] in) {
        float[] temp = new float[3];
        float[] out = new float[3];
        int i = 0;
        while (i < 3) {
            temp[i] = in[i] <= 0.03928f ? in[i] / 12.92f : (float)Math.exp(2.4 * Math.log(((double)in[i] + 0.055) / 1.055));
            ++i;
        }
        out[0] = (float)(0.436063750222 * (double)temp[0] + 0.385149601465 * (double)temp[1] + 0.143086418888 * (double)temp[2]);
        out[1] = (float)(0.222450894035 * (double)temp[0] + 0.71692584775 * (double)temp[1] + 0.060624511256 * (double)temp[2]);
        out[2] = (float)(0.0138985186 * (double)temp[0] + 0.097079690112 * (double)temp[1] + 0.713996045725 * (double)temp[2]);
        return out;
    }
}

