/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorSpaceConverter;

public class LinearRGBConverter
implements ColorSpaceConverter {
    public float[] toRGB(float[] in) {
        float[] out = new float[3];
        int i = 0;
        while (i < 3) {
            float n = in[i];
            if (n < 0.0f) {
                n = 0.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
            out[i] = n <= 0.00304f ? in[0] * 12.92f : 1.055f * (float)Math.exp(0.4166666666666667 * Math.log(n)) - 0.055f;
            ++i;
        }
        return out;
    }

    public float[] fromRGB(float[] in) {
        float[] out = new float[3];
        int i = 0;
        while (i < 3) {
            float n = in[i];
            if (n < 0.0f) {
                n = 0.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
            out[i] = n <= 0.03928f ? (float)((double)n / 12.92) : (float)Math.exp(2.4 * Math.log(((double)n + 0.055) / 1.055));
            ++i;
        }
        return out;
    }

    public float[] fromCIEXYZ(float[] in) {
        float[] out = new float[]{(float)(3.13383065124221 * (double)in[0] - 1.61711949411313 * (double)in[1] - 0.49071914111101 * (double)in[2]), (float)(-0.97847026691142 * (double)in[0] + 1.91597856031996 * (double)in[1] + 0.03340430640699 * (double)in[2]), (float)(0.07203679486279 * (double)in[0] - 0.22903073553113 * (double)in[1] + 1.40557835776234 * (double)in[2])};
        if (out[0] < 0.0f) {
            out[0] = 0.0f;
        }
        if (out[1] < 0.0f) {
            out[1] = 0.0f;
        }
        if (out[2] < 0.0f) {
            out[2] = 0.0f;
        }
        if (out[0] > 1.0f) {
            out[0] = 1.0f;
        }
        if (out[1] > 1.0f) {
            out[1] = 1.0f;
        }
        if (out[2] > 1.0f) {
            out[2] = 1.0f;
        }
        return out;
    }

    public float[] toCIEXYZ(float[] in) {
        float[] out = new float[]{(float)(0.4360637502219 * (double)in[0] + 0.38514960146481 * (double)in[1] + 0.14308641888799 * (double)in[2]), (float)(0.22245089403542 * (double)in[0] + 0.71692584775182 * (double)in[1] + 0.06062451125578 * (double)in[2]), (float)(0.01389851860679 * (double)in[0] + 0.09707969011198 * (double)in[1] + 0.71399604572506 * (double)in[2])};
        return out;
    }
}

