/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNPropertyPage
extends PropertyPage {
    private Text ignoredValue;
    private Text managedValue;
    private Text switchedValue;
    private Text urlValue;
    private Text lastChangedRevisionValue;
    private Text lastChangedDateValue;
    private Text lastCommitAuthorValue;
    private Text textStatusValue;
    private Text mergedValue;
    private Text deletedValue;
    private Text modifiedValue;
    private Text addedValue;
    private Text revisionValue;
    private Text copiedValue;
    private Text urlCopiedFromValue;
    private Text lockOwner;
    private Text lockCreationDate;
    private Text lockComment;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.path"));
        Text pathValueText = new Text(composite, 72);
        pathValueText.setText(((IResource)this.getElement()).getFullPath().toString());
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.url"));
        this.urlValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.revision"));
        this.revisionValue = new Text(composite, 72);
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.ignored"));
        this.ignoredValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.managed"));
        this.managedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.switched"));
        this.switchedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.changedRevision"));
        this.lastChangedRevisionValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.changedDate"));
        this.lastChangedDateValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.changedAuthor"));
        this.lastCommitAuthorValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.status"));
        this.textStatusValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.merged"));
        this.mergedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.deleted"));
        this.deletedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.modified"));
        this.modifiedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.added"));
        this.addedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.copied"));
        this.copiedValue = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.lockOwner"));
        this.lockOwner = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.lockCreationDate"));
        this.lockCreationDate = new Text(composite, 72);
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.lockComment"));
        this.lockComment = new Text(composite, 10);
        try {
            ISVNProperty prop;
            IResource resource = (IResource)this.getElement();
            SVNTeamProvider svnProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId());
            if (svnProvider == null) {
                return;
            }
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (svnResource == null) {
                return;
            }
            LocalResourceStatus status = svnResource.getStatus();
            SVNRevision revision = svnResource.getRevision();
            if (status.getUrlCopiedFrom() != null) {
                label = new Label(composite, 0);
                label.setText(Policy.bind("SVNPropertyPage.copiedFrom"));
                this.urlCopiedFromValue = new Text(composite, 72);
                this.urlCopiedFromValue.setText(status.getUrlCopiedFrom() != null ? status.getUrlCopiedFrom().toString() : "");
            }
            this.ignoredValue.setText(new Boolean(status.isIgnored()).toString());
            this.managedValue.setText(new Boolean(status.isManaged()).toString());
            this.switchedValue.setText(new Boolean(status.isSwitched()).toString());
            this.urlValue.setText(status.getUrlString() != null ? status.getUrlString() : "");
            this.lastChangedRevisionValue.setText(status.getLastChangedRevision() != null ? status.getLastChangedRevision().toString() : "");
            this.lastChangedDateValue.setText(status.getLastChangedDate() != null ? status.getLastChangedDate().toString() : "");
            this.lastCommitAuthorValue.setText(status.getLastCommitAuthor() != null ? status.getLastCommitAuthor() : "");
            this.textStatusValue.setText(status.getTextStatus() != null ? status.getTextStatus().toString() : "");
            this.mergedValue.setText(new Boolean(status.isTextMerged()).toString());
            this.deletedValue.setText(new Boolean(status.isDeleted()).toString());
            this.modifiedValue.setText(new Boolean(status.isTextModified()).toString());
            this.addedValue.setText(new Boolean(status.isAdded()).toString());
            this.revisionValue.setText(revision != null ? revision.toString() : "");
            this.copiedValue.setText(new Boolean(status.isCopied()).toString());
            this.lockOwner.setText(status.getLockOwner() != null ? status.getLockOwner() : "");
            this.lockCreationDate.setText(status.getLockOwner() != null ? status.getLockCreationDate().toString() : "");
            this.lockComment.setText(status.getLockOwner() != null ? status.getLockComment() : "");
            if (status.getLockOwner() == null && status.getUrlString() != null && (prop = svnResource.getSvnProperty("svn:needs-lock")) != null) {
                ISVNClientAdapter client = svnResource.getRepository().getSVNClient();
                try {
                    ISVNInfo info = client.getInfo(status.getUrl());
                    this.lockOwner.setText(info.getLockOwner() != null ? info.getLockOwner() : "");
                    this.lockCreationDate.setText(info.getLockOwner() != null ? info.getLockCreationDate().toString() : "");
                    this.lockComment.setText(info.getLockOwner() != null ? info.getLockComment() : "");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            SVNUIPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, "Property Exception", (Throwable)e));
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.svn_resource_properties_page_context");
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }
}

