/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.text.HTMLPrinter;

public class RubyAnnotationHover
implements IAnnotationHover {
    public static final RubyAnnotationHoverType OVERVIEW_RULER_HOVER = new RubyAnnotationHoverType();
    public static final RubyAnnotationHoverType TEXT_RULER_HOVER = new RubyAnnotationHoverType();
    public static final RubyAnnotationHoverType VERTICAL_RULER_HOVER = new RubyAnnotationHoverType();
    private IPreferenceStore fStore = RubyPlugin.getDefault().getCombinedPreferenceStore();
    private RubyAnnotationHoverType fType;

    public RubyAnnotationHover(RubyAnnotationHoverType rubyAnnotationHoverType) {
        Assert.isTrue((OVERVIEW_RULER_HOVER.equals(rubyAnnotationHoverType) || TEXT_RULER_HOVER.equals(rubyAnnotationHoverType) || VERTICAL_RULER_HOVER.equals(rubyAnnotationHoverType) ? 1 : 0) != 0);
        this.fType = rubyAnnotationHoverType;
    }

    private boolean isDuplicateRubyAnnotation(Map map, Position position, String string) {
        if (map.containsKey(position)) {
            Object v = map.get(position);
            if (string.equals(v)) {
                return true;
            }
            if (v instanceof List) {
                List list = (List)v;
                if (list.contains(string)) {
                    return true;
                }
                list.add(string);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(v);
                arrayList.add(string);
                map.put(position, arrayList);
            }
        } else {
            map.put(position, string);
        }
        return false;
    }

    protected List getRubyAnnotationsForLine(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            String string;
            AnnotationPreference annotationPreference;
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.getText() == null || (position = iAnnotationModel.getPosition(annotation)) == null || (annotationPreference = this.getAnnotationPreference(annotation)) == null || (!OVERVIEW_RULER_HOVER.equals(this.fType) ? (!TEXT_RULER_HOVER.equals(this.fType) ? VERTICAL_RULER_HOVER.equals(this.fType) && (string = annotationPreference.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(string) : ((string = annotationPreference.getTextPreferenceKey()) != null ? !this.fStore.getBoolean(string) : (string = annotationPreference.getHighlightPreferenceKey()) == null || !this.fStore.getBoolean(string))) : (string = annotationPreference.getOverviewRulerPreferenceKey()) == null || !this.fStore.getBoolean(string)) || this.isDuplicateRubyAnnotation(hashMap, position, annotation.getText())) continue;
            switch (this.compareRulerLine(position, iDocument, n)) {
                case 1: {
                    arrayList.add(annotation);
                    break;
                }
                case 2: {
                    arrayList2.add(annotation);
                }
            }
        }
        return this.select(arrayList, arrayList2);
    }

    protected List select(List list, List list2) {
        return list;
    }

    protected int compareRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int n2 = iDocument.getLineOfOffset(position.getOffset());
                if (n == n2) {
                    return 1;
                }
                if (n2 <= n && n <= iDocument.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        List list = this.getRubyAnnotationsForLine(iSourceViewer, n);
        if (list != null) {
            if (list.size() == 1) {
                Annotation annotation = (Annotation)list.get(0);
                String string = annotation.getText();
                if (string != null && string.trim().length() > 0) {
                    return this.formatSingleMessage(string);
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Annotation annotation = (Annotation)iterator.next();
                    String string = annotation.getText();
                    if (string == null || string.trim().length() <= 0) continue;
                    arrayList.add(string.trim());
                }
                if (arrayList.size() == 1) {
                    return this.formatSingleMessage((String)arrayList.get(0));
                }
                if (arrayList.size() > 1) {
                    return this.formatMultipleMessages(arrayList);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog(stringBuffer);
        HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.convertToHTMLContent(string));
        HTMLPrinter.addPageEpilog(stringBuffer);
        return stringBuffer.toString();
    }

    private String formatMultipleMessages(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog(stringBuffer);
        HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.convertToHTMLContent(RubyUIMessages.getString("RubyAnnotationHover.multipleMarkersAtThisLine")));
        HTMLPrinter.startBulletList(stringBuffer);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HTMLPrinter.addBullet(stringBuffer, HTMLPrinter.convertToHTMLContent((String)iterator.next()));
        }
        HTMLPrinter.endBulletList(stringBuffer);
        HTMLPrinter.addPageEpilog(stringBuffer);
        return stringBuffer.toString();
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    private static class RubyAnnotationHoverType {
        RubyAnnotationHoverType() {
        }
    }
}

