/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.rubypeople.rdt.internal.ui.search.GroupByPathStrategy;
import org.rubypeople.rdt.internal.ui.search.GroupByScopeStrategy;
import org.rubypeople.rdt.internal.ui.search.IGroupByStrategy;
import org.rubypeople.rdt.internal.ui.search.RubySearchResult;

public class RubySearchTreeContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult;
    private AbstractTreeViewer fTreeViewer;
    private Map fChildrenMap;
    private IGroupByStrategy groupByStrategy;

    public RubySearchTreeContentProvider(AbstractTreeViewer abstractTreeViewer) {
        this.fTreeViewer = abstractTreeViewer;
        this.setGroupByPath();
    }

    public void setGroupByScope() {
        this.groupByStrategy = new GroupByScopeStrategy();
        this.clear();
    }

    public void setGroupByPath() {
        this.groupByStrategy = new GroupByPathStrategy();
        this.clear();
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof RubySearchResult) {
            this.initialize((RubySearchResult)((Object)object2));
        }
    }

    public synchronized void initialize(AbstractTextSearchResult abstractTextSearchResult) {
        this.fResult = abstractTextSearchResult;
        this.fChildrenMap = new HashMap();
        if (abstractTextSearchResult != null) {
            Object[] objectArray = abstractTextSearchResult.getElements();
            int n = 0;
            while (n < objectArray.length) {
                this.insert(objectArray[n], false);
                ++n;
            }
        }
    }

    protected void insert(Object object, boolean bl) {
        Object object2 = this.getParent(object);
        while (object2 != null) {
            if (this.insertChild(object2, object)) {
                if (bl) {
                    this.fTreeViewer.add(object2, object);
                }
            } else {
                if (bl) {
                    this.fTreeViewer.refresh(object2);
                }
                return;
            }
            object = object2;
            object2 = this.getParent(object);
        }
        if (this.insertChild(this.fResult, object) && bl) {
            this.fTreeViewer.add((Object)this.fResult, object);
        }
    }

    private boolean insertChild(Object object, Object object2) {
        HashSet<Object> hashSet = (HashSet<Object>)this.fChildrenMap.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            this.fChildrenMap.put(object, hashSet);
        }
        return hashSet.add(object2);
    }

    protected void remove(Object object, boolean bl) {
        if (this.hasChildren(object)) {
            if (bl) {
                this.fTreeViewer.refresh(object);
            }
        } else if (this.fResult.getMatchCount(object) == 0) {
            this.fChildrenMap.remove(object);
            Object object2 = this.getParent(object);
            if (object2 != null) {
                this.removeFromSiblings(object, object2);
                this.remove(object2, bl);
            } else {
                this.removeFromSiblings(object, this.fResult);
                if (bl) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (bl) {
            this.fTreeViewer.refresh(object);
        }
    }

    private void removeFromSiblings(Object object, Object object2) {
        Set set = (Set)this.fChildrenMap.get(object2);
        if (set != null) {
            set.remove(object);
        }
    }

    public Object[] getChildren(Object object) {
        Set set = (Set)this.fChildrenMap.get(object);
        if (set == null) {
            return this.EMPTY_ARR;
        }
        return set.toArray();
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public synchronized void elementsChanged(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (this.fResult.getMatchCount(objectArray[n]) > 0) {
                this.insert(objectArray[n], true);
            } else {
                this.remove(objectArray[n], true);
            }
            ++n;
        }
    }

    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object object) {
        return this.groupByStrategy.getParent(object);
    }
}

