/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.testunit.views.OpenSymbolAction;
import org.rubypeople.rdt.testunit.views.RerunAction;
import org.rubypeople.rdt.testunit.views.TestRunInfo;
import org.rubypeople.rdt.testunit.views.TestRunTab;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.testunit.views.TestUnitView;

public class FailureTab
extends TestRunTab
implements IMenuListener {
    private Table fTable;
    private TestUnitView fRunnerViewPart;
    private boolean fMoveSelection = false;
    private final Image fErrorIcon = TestUnitView.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestUnitView.createImage("obj16/testfail.gif");
    private final Image fFailureTabIcon = TestUnitView.createImage("obj16/failures.gif");

    public void createTabControl(CTabFolder cTabFolder, Clipboard clipboard, TestUnitView testUnitView) {
        this.fRunnerViewPart = testUnitView;
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText(this.getName());
        cTabItem.setImage(this.fFailureTabIcon);
        Composite composite = new Composite((Composite)cTabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.fTable = new Table(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fTable.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        this.fTable.setLayoutData((Object)gridData);
        cTabItem.setControl((Control)composite);
        cTabItem.setToolTipText(TestUnitMessages.getString("FailureRunView.tab.tooltip"));
        this.initMenu();
        this.addListeners();
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fFailureTabIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public String getName() {
        return TestUnitMessages.getString("FailureRunView.tab.title");
    }

    public String getSelectedTestId() {
        int n = this.fTable.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getTestInfo(this.fTable.getItem(n)).getTestId();
    }

    public String getAllFailedTestNames() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator", "\n");
        int n = 0;
        while (n < this.fTable.getItemCount()) {
            TestRunInfo testRunInfo = this.getTestInfo(this.fTable.getItem(n));
            stringBuffer.append(testRunInfo.getTestName()).append(string);
            String string2 = testRunInfo.getTrace();
            if (string2 != null) {
                StringReader stringReader = new StringReader(string2);
                BufferedReader bufferedReader = new BufferedReader(stringReader);
                try {
                    String string3;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(String.valueOf(string3) + string);
                    }
                }
                catch (IOException iOException) {
                    stringBuffer.append(string);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getClassName() {
        TableItem tableItem = this.getSelectedItem();
        TestRunInfo testRunInfo = this.getTestInfo(tableItem);
        return testRunInfo.getClassName();
    }

    private String getMethodName() {
        TableItem tableItem = this.getSelectedItem();
        TestRunInfo testRunInfo = this.getTestInfo(tableItem);
        return testRunInfo.getTestMethodName();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.fTable.getSelectionCount() > 0) {
            String string = this.getClassName();
            String string2 = this.getMethodName();
            if (string != null) {
                System.err.println("MethodName: " + string2);
                iMenuManager.add(OpenSymbolAction.forMethod(string, string2, this.getSymbolFinder(), this.getShell()));
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), string, string2, "run"));
                iMenuManager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), string, string2, "debug"));
                iMenuManager.add((IContributionItem)new Separator());
            }
        }
    }

    private ISymbolFinder getSymbolFinder() {
        return RubyCore.getPlugin().getSymbolFinder();
    }

    private TableItem getSelectedItem() {
        int n = this.fTable.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.fTable.getItem(n);
    }

    public void setSelectedTest(String string) {
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            TestRunInfo testRunInfo = this.getTestInfo(tableItem);
            if (testRunInfo.getTestId().equals(string)) {
                this.fTable.setSelection(new TableItem[]{tableItem});
                this.fTable.showItem(tableItem);
                return;
            }
            ++n;
        }
    }

    private TestRunInfo getTestInfo(TableItem tableItem) {
        return (TestRunInfo)tableItem.getData();
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void endTest(String string) {
        TestRunInfo testRunInfo = this.fRunnerViewPart.getTestInfo(string);
        if (testRunInfo == null || testRunInfo.getStatus() == 0) {
            return;
        }
        TableItem tableItem = new TableItem(this.fTable, 0);
        this.updateTableItem(testRunInfo, tableItem);
        this.fTable.showItem(tableItem);
    }

    private void updateTableItem(TestRunInfo testRunInfo, TableItem tableItem) {
        String string = TestUnitMessages.getFormattedString("FailureRunView.labelfmt", new String[]{testRunInfo.getTestMethodName(), testRunInfo.getClassName()});
        tableItem.setText(string);
        if (testRunInfo.getStatus() == 2) {
            tableItem.setImage(this.fFailureIcon);
        } else {
            tableItem.setImage(this.fErrorIcon);
        }
        tableItem.setData((Object)testRunInfo);
    }

    private TableItem findItem(String string) {
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TestRunInfo testRunInfo = this.getTestInfo(tableItemArray[n]);
            if (testRunInfo.getTestId().equals(string)) {
                return tableItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public void activate() {
        this.fMoveSelection = false;
        this.testSelected();
    }

    public void aboutToStart() {
        this.fMoveSelection = false;
        this.fTable.removeAll();
    }

    private void testSelected() {
        this.fRunnerViewPart.handleTestSelected(this.getSelectedTestId());
    }

    private void addListeners() {
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FailureTab.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                FailureTab.this.activate();
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FailureTab.this.disposeIcons();
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                FailureTab.this.handleDoubleClick(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                FailureTab.this.activate();
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FailureTab.this.activate();
            }
        });
    }

    void handleDoubleClick(MouseEvent mouseEvent) {
        if (this.fTable.getSelectionCount() > 0) {
            OpenSymbolAction.forMethod(this.getClassName(), this.getMethodName(), this.getSymbolFinder(), this.getShell()).run();
        }
    }

    private Shell getShell() {
        return this.fTable.getShell();
    }

    public void testStatusChanged(TestRunInfo testRunInfo) {
        TableItem tableItem = this.findItem(testRunInfo.getTestId());
        if (tableItem != null) {
            if (testRunInfo.getStatus() == 0) {
                tableItem.dispose();
                return;
            }
            this.updateTableItem(testRunInfo, tableItem);
        }
        if (tableItem == null && testRunInfo.getStatus() != 0) {
            tableItem = new TableItem(this.fTable, 0);
            this.updateTableItem(testRunInfo, tableItem);
        }
        if (tableItem != null) {
            this.fTable.showItem(tableItem);
        }
    }

    public void selectNext() {
        if (this.fTable.getItemCount() == 0) {
            return;
        }
        int n = this.fTable.getSelectionIndex();
        if (n == -1) {
            n = 0;
        }
        if (this.fMoveSelection) {
            n = Math.min(this.fTable.getItemCount() - 1, n + 1);
        } else {
            this.fMoveSelection = true;
        }
        this.selectTest(n);
    }

    public void selectPrevious() {
        if (this.fTable.getItemCount() == 0) {
            return;
        }
        int n = this.fTable.getSelectionIndex();
        if (n == -1) {
            n = this.fTable.getItemCount() - 1;
        }
        if (this.fMoveSelection) {
            n = Math.max(0, n - 1);
        } else {
            this.fMoveSelection = true;
        }
        this.selectTest(n);
    }

    private void selectTest(int n) {
        TableItem tableItem = this.fTable.getItem(n);
        TestRunInfo testRunInfo = this.getTestInfo(tableItem);
        this.fRunnerViewPart.showTest(testRunInfo);
    }
}

