/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.formatter;

import java.util.Map;
import org.rubypeople.rdt.core.formatter.Indents;

public class IndentationState {
    private String lastIndentationBasedOnLevel = "";
    private int indentationLevel;
    private int offset;
    private int pos;
    private int fixIndentation;
    private String unformattedText;

    public IndentationState(String string, int n, int n2) {
        this.unformattedText = string;
        this.offset = n;
        this.indentationLevel = n2;
        this.pos = 0;
        this.resetFixIndentation();
    }

    public void decIndentationLevel() {
        --this.indentationLevel;
        this.resetFixIndentation();
    }

    public void incIndentationLevel() {
        ++this.indentationLevel;
        this.resetFixIndentation();
    }

    public void incPos(int n) {
        this.pos += n;
    }

    public void resetFixIndentation() {
        this.fixIndentation = -1;
    }

    public int getIndentation() {
        return this.fixIndentation;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPos() {
        return this.pos;
    }

    public String getUnformattedText() {
        return this.unformattedText;
    }

    public void setFixIndentation(int n) {
        this.fixIndentation = n;
    }

    public void setIndentationLevel(int n) {
        this.indentationLevel = n;
        this.resetFixIndentation();
    }

    public void setOffset(int n) {
        this.offset = n;
        this.resetFixIndentation();
    }

    public void setPos(int n) {
        this.pos = n;
    }

    protected String getIndentationString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.getOffset()) {
            stringBuffer.append(" ");
            ++n;
        }
        if (this.getIndentation() != -1) {
            stringBuffer.append(this.lastIndentationBasedOnLevel);
            stringBuffer.append(Indents.createFixIndentString(this.getIndentation(), map));
        } else {
            this.lastIndentationBasedOnLevel = Indents.createIndentString(this.getIndentationLevel(), map);
            stringBuffer.append(this.lastIndentationBasedOnLevel);
        }
        return stringBuffer.toString();
    }
}

