/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.builder.IndexUpdater;
import org.rubypeople.rdt.internal.core.builder.RubySourceFileCollectingVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;

public class MassIndexUpdater {
    private final IndexUpdater updater;
    private final RubyParser parser;

    public MassIndexUpdater(IndexUpdater indexUpdater, RubyParser rubyParser) {
        this.updater = indexUpdater;
        this.parser = rubyParser;
    }

    public MassIndexUpdater(IndexUpdater indexUpdater) {
        this(indexUpdater, new RubyParser());
    }

    public void updateProjects(List list, IProgressMonitor iProgressMonitor) {
        try {
            List list2 = this.findFiles(list);
            iProgressMonitor.beginTask("Update symbol index", list2.size());
            this.processFiles(list2, iProgressMonitor);
        }
        catch (CoreException coreException) {
            RubyCore.log((Exception)((Object)coreException));
        }
    }

    private void processFiles(List list, IProgressMonitor iProgressMonitor) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            iProgressMonitor.subTask(iFile.getFullPath().toString());
            iProgressMonitor.worked(1);
            this.processFile(iFile);
        }
    }

    private void processFile(IFile iFile) {
        try {
            Node node = this.parser.parse(iFile);
            this.updater.update(iFile, node, false);
        }
        catch (CoreException coreException) {
            RubyCore.log((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            RubyCore.log(exception);
        }
    }

    private List findFiles(List list) throws CoreException {
        ArrayList arrayList = new ArrayList();
        RubySourceFileCollectingVisitor rubySourceFileCollectingVisitor = new RubySourceFileCollectingVisitor(arrayList);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            iProject.accept((IResourceProxyVisitor)rubySourceFileCollectingVisitor, 0);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MassIndexUpdater)) {
            return false;
        }
        MassIndexUpdater massIndexUpdater = (MassIndexUpdater)object;
        return this.updater.getClass().equals(massIndexUpdater.updater.getClass()) && this.parser.getClass().equals(massIndexUpdater.parser);
    }

    public int hashCode() {
        return 0;
    }
}

