/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.internal.core.builder.IMarkerManager;
import org.rubypeople.rdt.internal.core.builder.MarkerManager;
import org.rubypeople.rdt.internal.core.builder.RubyCodeAnalyzer;
import org.rubypeople.rdt.internal.core.builder.SingleFileCompiler;
import org.rubypeople.rdt.internal.core.builder.TaskCompiler;
import org.rubypeople.rdt.internal.core.symbols.SymbolIndex;
import org.rubypeople.rdt.internal.core.util.ListUtil;

public abstract class AbstractRdtCompiler {
    protected final IProject project;
    protected final IMarkerManager markerManager;
    protected final SymbolIndex symbolIndex;
    protected final List compilers;

    public AbstractRdtCompiler(IProject iProject, SymbolIndex symbolIndex, IMarkerManager iMarkerManager, List list) {
        this.project = iProject;
        this.symbolIndex = symbolIndex;
        this.markerManager = iMarkerManager;
        this.compilers = list;
    }

    protected abstract void removeMarkers(IMarkerManager var1);

    protected abstract void flushIndexEntries(SymbolIndex var1);

    protected abstract List getFilesToCompile();

    protected abstract void analyzeFiles() throws CoreException;

    protected static List compilers(MarkerManager markerManager) {
        return ListUtil.create(new RubyCodeAnalyzer(markerManager), new TaskCompiler(markerManager));
    }

    public void compile(IProgressMonitor iProgressMonitor) throws CoreException {
        this.analyzeFiles();
        List list = this.getFilesToCompile();
        iProgressMonitor.beginTask("Building " + this.project.getName() + "...", list.size() * this.compilers.size() + 2);
        iProgressMonitor.subTask("Removing Markers...");
        this.removeMarkers(this.markerManager);
        iProgressMonitor.worked(1);
        this.flushIndexEntries(this.symbolIndex);
        iProgressMonitor.worked(1);
        this.compileFiles(list, iProgressMonitor);
        iProgressMonitor.done();
    }

    private void compileFiles(List list, IProgressMonitor iProgressMonitor) throws CoreException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            if (iProgressMonitor.isCanceled()) break;
            iProgressMonitor.subTask(iFile.getFullPath().toString());
            this.compileFile(iFile, iProgressMonitor);
        }
    }

    private void compileFile(IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        Iterator iterator = this.compilers.iterator();
        while (iterator.hasNext()) {
            SingleFileCompiler singleFileCompiler = (SingleFileCompiler)iterator.next();
            singleFileCompiler.compileFile(iFile);
            iProgressMonitor.worked(1);
        }
    }
}

