/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.ScopeNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Visibility;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.core.HandleStack;
import org.rubypeople.rdt.internal.core.ImportContainer;
import org.rubypeople.rdt.internal.core.ImportDeclarationElementInfo;
import org.rubypeople.rdt.internal.core.InfoStack;
import org.rubypeople.rdt.internal.core.MemberElementInfo;
import org.rubypeople.rdt.internal.core.RubyBlock;
import org.rubypeople.rdt.internal.core.RubyClassVar;
import org.rubypeople.rdt.internal.core.RubyConstant;
import org.rubypeople.rdt.internal.core.RubyDynamicVar;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyFieldElementInfo;
import org.rubypeople.rdt.internal.core.RubyGlobal;
import org.rubypeople.rdt.internal.core.RubyImport;
import org.rubypeople.rdt.internal.core.RubyInstVar;
import org.rubypeople.rdt.internal.core.RubyLocalVar;
import org.rubypeople.rdt.internal.core.RubyMethod;
import org.rubypeople.rdt.internal.core.RubyMethodElementInfo;
import org.rubypeople.rdt.internal.core.RubyModule;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.RubyScriptElementInfo;
import org.rubypeople.rdt.internal.core.RubySingletonMethod;
import org.rubypeople.rdt.internal.core.RubyType;
import org.rubypeople.rdt.internal.core.RubyTypeElementInfo;
import org.rubypeople.rdt.internal.core.parser.RubyParser;

public class RubyScriptStructureBuilder
implements NodeVisitor {
    private InfoStack infoStack = new InfoStack();
    private HandleStack modelStack = new HandleStack();
    private RubyScriptElementInfo scriptInfo;
    private IRubyScript script;
    private Visibility currentVisibility = Visibility.PUBLIC;
    private Map newElements;
    private RubyElementInfo importContainerInfo;
    private boolean DEBUG = false;

    public RubyScriptStructureBuilder(IRubyScript iRubyScript, RubyScriptElementInfo rubyScriptElementInfo, Map map) {
        this.script = iRubyScript;
        this.scriptInfo = rubyScriptElementInfo;
        this.newElements = map;
        this.modelStack.push(iRubyScript);
        this.infoStack.push(this.scriptInfo);
        this.DEBUG = RubyParser.isDebugging();
    }

    public Instruction visitAliasNode(AliasNode aliasNode) {
        this.handleNode((Node)aliasNode);
        String string = aliasNode.getNewName();
        Visibility visibility = this.currentVisibility;
        if (string.equals("initialize")) {
            visibility = Visibility.PROTECTED;
        }
        String[] stringArray = new String[]{};
        RubyMethod rubyMethod = new RubyMethod(this.getCurrentType(), string, stringArray);
        this.modelStack.push(rubyMethod);
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        rubyElementInfo.addChild(rubyMethod);
        RubyMethodElementInfo rubyMethodElementInfo = new RubyMethodElementInfo();
        rubyMethodElementInfo.setVisibility(this.convertVisibility(visibility));
        ISourcePosition iSourcePosition = aliasNode.getPosition();
        this.setKeywordRange("alias", iSourcePosition, rubyMethodElementInfo, ":" + string);
        this.infoStack.push(rubyMethodElementInfo);
        this.newElements.put(rubyMethod, rubyMethodElementInfo);
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitAndNode(AndNode andNode) {
        this.handleNode((Node)andNode);
        this.visitNode(andNode.getFirstNode());
        this.visitNode(andNode.getFirstNode());
        return null;
    }

    public Instruction visitArgsNode(ArgsNode argsNode) {
        this.handleNode((Node)argsNode);
        this.visitNode((Node)argsNode.getBlockArgNode());
        if (argsNode.getOptArgs() != null) {
            this.visitIter(argsNode.getOptArgs().iterator());
        }
        return null;
    }

    public Instruction visitArgsCatNode(ArgsCatNode argsCatNode) {
        this.handleNode((Node)argsCatNode);
        this.visitNode(argsCatNode.getFirstNode());
        this.visitNode(argsCatNode.getSecondNode());
        return null;
    }

    public Instruction visitArrayNode(ArrayNode arrayNode) {
        this.handleNode((Node)arrayNode);
        this.visitIter(arrayNode.iterator());
        return null;
    }

    private Instruction visitIter(Iterator iterator) {
        while (iterator.hasNext()) {
            this.visitNode((Node)iterator.next());
        }
        return null;
    }

    public Instruction visitBackRefNode(BackRefNode backRefNode) {
        this.handleNode((Node)backRefNode);
        return null;
    }

    public Instruction visitBeginNode(BeginNode beginNode) {
        this.handleNode((Node)beginNode);
        this.visitNode(beginNode.getBodyNode());
        return null;
    }

    public Instruction visitBignumNode(BignumNode bignumNode) {
        this.handleNode((Node)bignumNode);
        return null;
    }

    public Instruction visitBlockArgNode(BlockArgNode blockArgNode) {
        this.handleNode((Node)blockArgNode);
        return null;
    }

    public Instruction visitBlockNode(BlockNode blockNode) {
        this.handleNode((Node)blockNode);
        this.visitIter(blockNode.iterator());
        return null;
    }

    public Instruction visitBlockPassNode(BlockPassNode blockPassNode) {
        this.handleNode((Node)blockPassNode);
        this.visitNode(blockPassNode.getArgsNode());
        this.visitNode(blockPassNode.getBodyNode());
        this.visitNode(blockPassNode.getIterNode());
        return null;
    }

    public Instruction visitBreakNode(BreakNode breakNode) {
        this.handleNode((Node)breakNode);
        this.visitNode(breakNode.getValueNode());
        return null;
    }

    public Instruction visitConstDeclNode(ConstDeclNode constDeclNode) {
        this.handleNode((Node)constDeclNode);
        String string = constDeclNode.getName();
        RubyElement rubyElement = this.getCurrentType();
        RubyConstant rubyConstant = new RubyConstant(rubyElement, string);
        this.modelStack.push(rubyConstant);
        RubyElementInfo rubyElementInfo = this.getCurrentTypeInfo();
        rubyElementInfo.addChild(rubyConstant);
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        rubyFieldElementInfo.setTypeName(this.estimateValueType(constDeclNode.getValueNode()));
        ISourcePosition iSourcePosition = constDeclNode.getPosition();
        this.setTokenRange(iSourcePosition, rubyFieldElementInfo, string);
        this.infoStack.push(rubyFieldElementInfo);
        this.newElements.put(rubyConstant, rubyFieldElementInfo);
        this.visitNode(constDeclNode.getValueNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode classVarAsgnNode) {
        this.handleNode((Node)classVarAsgnNode);
        String string = classVarAsgnNode.getName();
        RubyElement rubyElement = this.getCurrentType();
        RubyClassVar rubyClassVar = new RubyClassVar(rubyElement, string);
        this.modelStack.push(rubyClassVar);
        RubyElementInfo rubyElementInfo = this.getCurrentTypeInfo();
        rubyElementInfo.addChild(rubyClassVar);
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        rubyFieldElementInfo.setTypeName(this.estimateValueType(classVarAsgnNode.getValueNode()));
        this.setTokenRange(classVarAsgnNode.getPosition(), rubyFieldElementInfo, string);
        this.infoStack.push(rubyFieldElementInfo);
        this.newElements.put(rubyClassVar, rubyFieldElementInfo);
        this.visitNode(classVarAsgnNode.getValueNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitClassVarDeclNode(ClassVarDeclNode classVarDeclNode) {
        this.handleNode((Node)classVarDeclNode);
        String string = classVarDeclNode.getName();
        RubyElement rubyElement = this.getCurrentType();
        RubyClassVar rubyClassVar = new RubyClassVar(rubyElement, classVarDeclNode.getName());
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        rubyFieldElementInfo.setTypeName(this.estimateValueType(classVarDeclNode.getValueNode()));
        rubyFieldElementInfo.setTypeName(this.estimateValueType(classVarDeclNode.getValueNode()));
        this.setTokenRange(classVarDeclNode.getPosition(), rubyFieldElementInfo, string);
        rubyElementInfo.addChild(rubyClassVar);
        this.newElements.put(rubyClassVar, rubyFieldElementInfo);
        this.visitNode(classVarDeclNode.getValueNode());
        return null;
    }

    public Instruction visitClassVarNode(ClassVarNode classVarNode) {
        this.handleNode((Node)classVarNode);
        return null;
    }

    private RubyElementInfo getCurrentTypeInfo() {
        ArrayList<RubyElementInfo> arrayList = new ArrayList<RubyElementInfo>();
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        while (!(rubyElementInfo instanceof RubyTypeElementInfo)) {
            arrayList.add(this.infoStack.pop());
            rubyElementInfo = this.infoStack.peek();
            if (rubyElementInfo == null) break;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.infoStack.push((RubyElementInfo)iterator.next());
        }
        if (rubyElementInfo == null) {
            return this.scriptInfo;
        }
        return rubyElementInfo;
    }

    public Instruction visitCallNode(CallNode callNode) {
        this.handleNode((Node)callNode);
        if (this.DEBUG) {
            System.out.println(callNode.getName());
        }
        this.visitNode(callNode.getReceiverNode());
        this.visitNode(callNode.getArgsNode());
        return null;
    }

    public Instruction visitCaseNode(CaseNode caseNode) {
        this.handleNode((Node)caseNode);
        this.visitNode(caseNode.getCaseNode());
        this.visitNode(caseNode.getFirstWhenNode());
        return null;
    }

    public Instruction visitClassNode(ClassNode classNode) {
        this.handleNode((Node)classNode);
        this.currentVisibility = Visibility.PUBLIC;
        String string = this.getFullyQualifiedName((Node)classNode.getCPath());
        RubyType rubyType = new RubyType(this.modelStack.peek(), string);
        this.modelStack.push(rubyType);
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        rubyElementInfo.addChild(rubyType);
        RubyTypeElementInfo rubyTypeElementInfo = new RubyTypeElementInfo();
        rubyTypeElementInfo.setHandle(rubyType);
        ISourcePosition iSourcePosition = classNode.getPosition();
        this.setKeywordRange("class", iSourcePosition, rubyTypeElementInfo, string);
        String string2 = this.getSuperClassName(classNode.getSuperNode());
        rubyTypeElementInfo.setSuperclassName(string2);
        rubyTypeElementInfo.setIncludedModuleNames(new String[]{"Kernel"});
        this.infoStack.push(rubyTypeElementInfo);
        this.newElements.put(rubyType, rubyTypeElementInfo);
        this.visitNode(classNode.getSuperNode());
        this.visitNode((Node)classNode.getBodyNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    private String getSuperClassName(Node node) {
        if (node == null) {
            return "Object";
        }
        return this.getFullyQualifiedName(node);
    }

    private String getFullyQualifiedName(Node node) {
        if (node == null) {
            return "";
        }
        if (node instanceof ConstNode) {
            ConstNode constNode = (ConstNode)node;
            return constNode.getName();
        }
        if (node instanceof Colon2Node) {
            Colon2Node colon2Node = (Colon2Node)node;
            String string = this.getFullyQualifiedName(colon2Node.getLeftNode());
            if (string.length() > 0) {
                string = String.valueOf(string) + "::";
            }
            return String.valueOf(string) + colon2Node.getName();
        }
        return "";
    }

    private void setKeywordRange(String string, ISourcePosition iSourcePosition, MemberElementInfo memberElementInfo, String string2) {
        int n = iSourcePosition.getStartOffset() + string.length() + 1;
        memberElementInfo.setNameSourceStart(n);
        memberElementInfo.setNameSourceEnd(n + string2.length() - 1);
        memberElementInfo.setSourceRangeStart(iSourcePosition.getStartOffset());
        memberElementInfo.setSourceRangeEnd(iSourcePosition.getEndOffset() - 1);
    }

    public Instruction visitColon2Node(Colon2Node colon2Node) {
        this.handleNode((Node)colon2Node);
        if (this.DEBUG) {
            System.out.println(colon2Node.getName());
        }
        this.visitNode(colon2Node.getLeftNode());
        return null;
    }

    public Instruction visitColon3Node(Colon3Node colon3Node) {
        this.handleNode((Node)colon3Node);
        return null;
    }

    public Instruction visitConstNode(ConstNode constNode) {
        this.handleNode((Node)constNode);
        if (this.DEBUG) {
            System.out.println(constNode.getName());
        }
        return null;
    }

    public Instruction visitDAsgnNode(DAsgnNode dAsgnNode) {
        this.handleNode((Node)dAsgnNode);
        RubyDynamicVar rubyDynamicVar = new RubyDynamicVar(this.modelStack.peek(), dAsgnNode.getName());
        this.modelStack.push(rubyDynamicVar);
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        rubyFieldElementInfo.setTypeName(this.estimateValueType(dAsgnNode.getValueNode()));
        this.infoStack.push(rubyFieldElementInfo);
        this.newElements.put(rubyDynamicVar, rubyFieldElementInfo);
        if (this.DEBUG) {
            System.out.println(dAsgnNode.getName());
        }
        this.visitNode(dAsgnNode.getValueNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitDRegxNode(DRegexpNode dRegexpNode) {
        this.handleNode((Node)dRegexpNode);
        this.visitIter(dRegexpNode.iterator());
        return null;
    }

    public Instruction visitDStrNode(DStrNode dStrNode) {
        this.handleNode((Node)dStrNode);
        this.visitIter(dStrNode.iterator());
        return null;
    }

    public Instruction visitDSymbolNode(DSymbolNode dSymbolNode) {
        this.handleNode((Node)dSymbolNode);
        this.visitNode((Node)dSymbolNode.getNode());
        return null;
    }

    public Instruction visitDVarNode(DVarNode dVarNode) {
        this.handleNode((Node)dVarNode);
        if (this.DEBUG) {
            System.out.println(dVarNode.getName());
        }
        return null;
    }

    public Instruction visitDXStrNode(DXStrNode dXStrNode) {
        this.handleNode((Node)dXStrNode);
        this.visitIter(dXStrNode.iterator());
        return null;
    }

    public Instruction visitDefinedNode(DefinedNode definedNode) {
        this.handleNode((Node)definedNode);
        this.visitNode(definedNode.getExpressionNode());
        return null;
    }

    public Instruction visitDefnNode(DefnNode defnNode) {
        this.handleNode((Node)defnNode);
        String string = defnNode.getName();
        Visibility visibility = this.currentVisibility;
        if (string.equals("initialize")) {
            visibility = Visibility.PROTECTED;
        }
        RubyElement rubyElement = this.getCurrentType();
        String[] stringArray = this.getArgs(defnNode.getArgsNode());
        RubyMethod rubyMethod = new RubyMethod(rubyElement, string, stringArray);
        this.modelStack.push(rubyMethod);
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        rubyElementInfo.addChild(rubyMethod);
        RubyMethodElementInfo rubyMethodElementInfo = new RubyMethodElementInfo();
        rubyMethodElementInfo.setArgumentNames(stringArray);
        rubyMethodElementInfo.setVisibility(this.convertVisibility(visibility));
        ISourcePosition iSourcePosition = defnNode.getPosition();
        this.setKeywordRange("def", iSourcePosition, rubyMethodElementInfo, string);
        this.infoStack.push(rubyMethodElementInfo);
        this.newElements.put(rubyMethod, rubyMethodElementInfo);
        this.visitNode(defnNode.getArgsNode());
        this.visitNode((Node)defnNode.getBodyNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    private int convertVisibility(Visibility visibility) {
        if (visibility == Visibility.PUBLIC) {
            return 0;
        }
        if (visibility == Visibility.PROTECTED) {
            return 1;
        }
        return 2;
    }

    private String[] getArgs(Node node) {
        if (node == null) {
            return new String[0];
        }
        ArgsNode argsNode = (ArgsNode)node;
        boolean bl = false;
        if (argsNode.getRestArg() != -1) {
            bl = true;
        }
        boolean bl2 = false;
        if (argsNode.getBlockArgNode() != null) {
            bl2 = true;
        }
        int n = 0;
        if (argsNode.getOptArgs() != null) {
            n = argsNode.getOptArgs().size();
        }
        List list = this.getArguments(argsNode.getArgs());
        if (n > 0) {
            list.addAll(this.getArguments(argsNode.getOptArgs()));
        }
        if (bl) {
            list.add("*rest");
        }
        if (bl2) {
            list.add("&block");
        }
        return this.stringListToArray(list);
    }

    private String[] stringListToArray(List list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        while (n < list.size()) {
            stringArray[n] = (String)list.get(n);
            ++n;
        }
        return stringArray;
    }

    private List getArguments(ListNode listNode) {
        if (listNode == null) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = listNode.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ArgumentNode) {
                arrayList.add(((ArgumentNode)e).getName());
                continue;
            }
            if (e instanceof LocalAsgnNode) {
                LocalAsgnNode localAsgnNode = (LocalAsgnNode)e;
                String string = localAsgnNode.getName();
                string = String.valueOf(string) + " = ";
                string = String.valueOf(string) + this.stringRepresentation(localAsgnNode.getValueNode());
                arrayList.add(string);
                continue;
            }
            if (!this.DEBUG) continue;
            System.err.println("Reached argument node type we can't handle");
        }
        return arrayList;
    }

    private String stringRepresentation(Node node) {
        if (node == null) {
            return "";
        }
        if (node instanceof HashNode) {
            return "{}";
        }
        if (node instanceof SelfNode) {
            return "self";
        }
        if (node instanceof ConstNode) {
            return ((ConstNode)node).getName();
        }
        if (node instanceof ZArrayNode) {
            return "[]";
        }
        if (node instanceof FixnumNode) {
            return "" + ((FixnumNode)node).getValue();
        }
        if (node instanceof DStrNode) {
            return this.stringRepresentation((DStrNode)node);
        }
        if (node instanceof StrNode) {
            return ((StrNode)node).getValue();
        }
        if (this.DEBUG) {
            System.err.println("Reached node type we don't know how to represent: " + node.getClass().getName());
        }
        return node.toString();
    }

    private String stringRepresentation(DStrNode dStrNode) {
        List list = dStrNode.childNodes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(this.stringRepresentation(node));
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private RubyElement getCurrentType() {
        ArrayList<RubyElement> arrayList = new ArrayList<RubyElement>();
        RubyElement rubyElement = this.modelStack.peek();
        while (!rubyElement.isType(3)) {
            arrayList.add(this.modelStack.pop());
            rubyElement = this.modelStack.peek();
            if (rubyElement == null) break;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.modelStack.push((RubyElement)iterator.next());
        }
        if (rubyElement == null) {
            return (RubyScript)this.script;
        }
        return rubyElement;
    }

    public Instruction visitDefsNode(DefsNode defsNode) {
        this.handleNode((Node)defsNode);
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        String string = this.stringRepresentation(defsNode.getReceiverNode());
        String string2 = string != null && string.trim().length() > 0 ? String.valueOf(string) + "." + defsNode.getName() : defsNode.getName();
        Visibility visibility = this.currentVisibility;
        String[] stringArray = this.getArgs(defsNode.getArgsNode());
        RubyElement rubyElement = this.getCurrentType();
        RubySingletonMethod rubySingletonMethod = new RubySingletonMethod(rubyElement, defsNode.getName(), stringArray);
        this.modelStack.push(rubySingletonMethod);
        rubyElementInfo.addChild(rubySingletonMethod);
        RubyMethodElementInfo rubyMethodElementInfo = new RubyMethodElementInfo();
        this.infoStack.push(rubyMethodElementInfo);
        ISourcePosition iSourcePosition = defsNode.getPosition();
        this.setKeywordRange("def", iSourcePosition, rubyMethodElementInfo, string2);
        rubyMethodElementInfo.setArgumentNames(stringArray);
        rubyMethodElementInfo.setVisibility(this.convertVisibility(visibility));
        this.newElements.put(rubySingletonMethod, rubyMethodElementInfo);
        this.visitNode(defsNode.getReceiverNode());
        this.visitNode(defsNode.getArgsNode());
        this.visitNode((Node)defsNode.getBodyNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitDotNode(DotNode dotNode) {
        this.handleNode((Node)dotNode);
        this.visitNode(dotNode.getBeginNode());
        this.visitNode(dotNode.getEndNode());
        return null;
    }

    public Instruction visitEnsureNode(EnsureNode ensureNode) {
        this.handleNode((Node)ensureNode);
        this.visitNode(ensureNode.getEnsureNode());
        this.visitNode(ensureNode.getBodyNode());
        return null;
    }

    public Instruction visitEvStrNode(EvStrNode evStrNode) {
        this.handleNode((Node)evStrNode);
        this.visitNode(evStrNode.getBody());
        return null;
    }

    public Instruction visitFCallNode(FCallNode fCallNode) {
        ArrayNode arrayNode;
        String string;
        String string2;
        this.handleNode((Node)fCallNode);
        if (this.DEBUG) {
            System.out.println(fCallNode.getName());
        }
        if (((string2 = fCallNode.getName()).equals("require") || string2.equals("load")) && (string = this.getString(arrayNode = (ArrayNode)fCallNode.getArgsNode())) != null) {
            ImportContainer importContainer = (ImportContainer)this.script.getImportContainer();
            if (this.importContainerInfo == null) {
                this.importContainerInfo = new RubyElementInfo();
                this.scriptInfo.addChild(importContainer);
                this.newElements.put(importContainer, this.importContainerInfo);
            }
            RubyImport rubyImport = new RubyImport(importContainer, string);
            ImportDeclarationElementInfo importDeclarationElementInfo = new ImportDeclarationElementInfo();
            this.setKeywordRange(string2, arrayNode.getPosition(), importDeclarationElementInfo, string);
            importDeclarationElementInfo.name = string;
            this.importContainerInfo.addChild(rubyImport);
            this.newElements.put(rubyImport, importDeclarationElementInfo);
        }
        this.visitNode(fCallNode.getArgsNode());
        return null;
    }

    private String getString(ArrayNode arrayNode) {
        DStrNode dStrNode;
        Object e = arrayNode.iterator().next();
        if (e instanceof DStrNode) {
            dStrNode = (DStrNode)e;
            e = dStrNode.iterator().next();
        }
        if (e instanceof StrNode) {
            dStrNode = (StrNode)e;
            return dStrNode.getValue();
        }
        return null;
    }

    public Instruction visitFalseNode(FalseNode falseNode) {
        this.handleNode((Node)falseNode);
        return null;
    }

    public Instruction visitFixnumNode(FixnumNode fixnumNode) {
        this.handleNode((Node)fixnumNode);
        return null;
    }

    public Instruction visitFlipNode(FlipNode flipNode) {
        this.handleNode((Node)flipNode);
        this.visitNode(flipNode.getBeginNode());
        this.visitNode(flipNode.getEndNode());
        return null;
    }

    public Instruction visitFloatNode(FloatNode floatNode) {
        this.handleNode((Node)floatNode);
        return null;
    }

    public Instruction visitForNode(ForNode forNode) {
        this.handleNode((Node)forNode);
        this.visitNode(forNode.getVarNode());
        this.visitNode(forNode.getIterNode());
        this.visitNode(forNode.getBodyNode());
        return null;
    }

    public Instruction visitGlobalAsgnNode(GlobalAsgnNode globalAsgnNode) {
        this.handleNode((Node)globalAsgnNode);
        String string = globalAsgnNode.getName();
        RubyGlobal rubyGlobal = new RubyGlobal(this.script, string);
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        rubyFieldElementInfo.setTypeName(this.estimateValueType(globalAsgnNode.getValueNode()));
        ISourcePosition iSourcePosition = globalAsgnNode.getPosition();
        this.setTokenRange(iSourcePosition, rubyFieldElementInfo, string);
        this.scriptInfo.addChild(rubyGlobal);
        this.newElements.put(rubyGlobal, rubyFieldElementInfo);
        this.visitNode(globalAsgnNode.getValueNode());
        return null;
    }

    private void setTokenRange(ISourcePosition iSourcePosition, RubyFieldElementInfo rubyFieldElementInfo, String string) {
        int n = iSourcePosition.getStartOffset() - string.length() + 1;
        rubyFieldElementInfo.setNameSourceStart(n);
        rubyFieldElementInfo.setNameSourceEnd(iSourcePosition.getStartOffset());
        rubyFieldElementInfo.setSourceRangeStart(n);
        rubyFieldElementInfo.setSourceRangeEnd(iSourcePosition.getStartOffset());
    }

    public Instruction visitGlobalVarNode(GlobalVarNode globalVarNode) {
        this.handleNode((Node)globalVarNode);
        return null;
    }

    public Instruction visitHashNode(HashNode hashNode) {
        this.handleNode((Node)hashNode);
        this.visitNode((Node)hashNode.getListNode());
        return null;
    }

    public Instruction visitInstAsgnNode(InstAsgnNode instAsgnNode) {
        this.handleNode((Node)instAsgnNode);
        String string = instAsgnNode.getName();
        RubyElement rubyElement = this.getCurrentType();
        RubyInstVar rubyInstVar = new RubyInstVar(rubyElement, string);
        RubyElementInfo rubyElementInfo = this.getCurrentTypeInfo();
        rubyElementInfo.addChild(rubyInstVar);
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        ISourcePosition iSourcePosition = instAsgnNode.getPosition();
        this.setTokenRange(iSourcePosition, rubyFieldElementInfo, string);
        rubyFieldElementInfo.setTypeName(this.estimateValueType(instAsgnNode.getValueNode()));
        this.newElements.put(rubyInstVar, rubyFieldElementInfo);
        this.visitNode(instAsgnNode.getValueNode());
        return null;
    }

    private String estimateValueType(Node node) {
        if (node instanceof CallNode) {
            Node node2;
            CallNode callNode = (CallNode)node;
            if (callNode.getName().equals("new") && (node2 = callNode.getReceiverNode()) instanceof ConstNode) {
                ConstNode constNode = (ConstNode)node2;
                return constNode.getName();
            }
        } else {
            if (node instanceof DStrNode) {
                return "String";
            }
            if (node instanceof FixnumNode) {
                return "Fixnum";
            }
            if (node instanceof BignumNode) {
                return "Bignum";
            }
        }
        return "Object";
    }

    public Instruction visitInstVarNode(InstVarNode instVarNode) {
        this.handleNode((Node)instVarNode);
        return null;
    }

    public Instruction visitIfNode(IfNode ifNode) {
        this.handleNode((Node)ifNode);
        this.visitNode(ifNode.getCondition());
        this.visitNode(ifNode.getThenBody());
        this.visitNode(ifNode.getElseBody());
        return null;
    }

    public Instruction visitIterNode(IterNode iterNode) {
        this.handleNode((Node)iterNode);
        RubyBlock rubyBlock = new RubyBlock(this.modelStack.peek());
        this.modelStack.push(rubyBlock);
        this.visitNode(iterNode.getIterNode());
        this.visitNode(iterNode.getVarNode());
        this.visitNode(iterNode.getBodyNode());
        if (this.DEBUG) {
            System.out.println("Iter Node ended");
        }
        this.modelStack.pop();
        return null;
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode localAsgnNode) {
        this.handleNode((Node)localAsgnNode);
        int n = localAsgnNode.getPosition().getStartOffset() - localAsgnNode.getName().length() + 1;
        int n2 = n + localAsgnNode.getName().length();
        RubyLocalVar rubyLocalVar = new RubyLocalVar(this.modelStack.peek(), localAsgnNode.getName(), n, n2);
        this.modelStack.push(rubyLocalVar);
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        rubyElementInfo.addChild(rubyLocalVar);
        RubyFieldElementInfo rubyFieldElementInfo = new RubyFieldElementInfo();
        rubyFieldElementInfo.setTypeName(this.estimateValueType(localAsgnNode.getValueNode()));
        ISourcePosition iSourcePosition = localAsgnNode.getPosition();
        this.setTokenRange(iSourcePosition, rubyFieldElementInfo, localAsgnNode.getName());
        this.infoStack.push(rubyFieldElementInfo);
        this.newElements.put(rubyLocalVar, rubyFieldElementInfo);
        this.visitNode(localAsgnNode.getValueNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitLocalVarNode(LocalVarNode localVarNode) {
        this.handleNode((Node)localVarNode);
        return null;
    }

    public Instruction visitMultipleAsgnNode(MultipleAsgnNode multipleAsgnNode) {
        this.handleNode((Node)multipleAsgnNode);
        this.visitNode((Node)multipleAsgnNode.getHeadNode());
        this.visitNode(multipleAsgnNode.getArgsNode());
        this.visitNode(multipleAsgnNode.getValueNode());
        return null;
    }

    public Instruction visitMatch2Node(Match2Node match2Node) {
        this.handleNode((Node)match2Node);
        this.visitNode(match2Node.getReceiverNode());
        this.visitNode(match2Node.getValueNode());
        return null;
    }

    public Instruction visitMatch3Node(Match3Node match3Node) {
        this.handleNode((Node)match3Node);
        this.visitNode(match3Node.getReceiverNode());
        this.visitNode(match3Node.getValueNode());
        return null;
    }

    public Instruction visitMatchNode(MatchNode matchNode) {
        this.handleNode((Node)matchNode);
        this.visitNode(matchNode.getRegexpNode());
        return null;
    }

    public Instruction visitModuleNode(ModuleNode moduleNode) {
        this.handleNode((Node)moduleNode);
        String string = moduleNode.getCPath().getName();
        RubyModule rubyModule = new RubyModule(this.modelStack.peek(), string);
        this.modelStack.push(rubyModule);
        RubyElementInfo rubyElementInfo = this.infoStack.peek();
        rubyElementInfo.addChild(rubyModule);
        RubyTypeElementInfo rubyTypeElementInfo = new RubyTypeElementInfo();
        rubyTypeElementInfo.setHandle(rubyModule);
        ISourcePosition iSourcePosition = moduleNode.getPosition();
        this.setKeywordRange("module", iSourcePosition, rubyTypeElementInfo, string);
        rubyTypeElementInfo.setSuperclassName("Module");
        this.infoStack.push(rubyTypeElementInfo);
        this.newElements.put(rubyModule, rubyTypeElementInfo);
        this.visitNode((Node)moduleNode.getBodyNode());
        this.modelStack.pop();
        this.infoStack.pop();
        return null;
    }

    public Instruction visitNewlineNode(NewlineNode newlineNode) {
        this.handleNode((Node)newlineNode);
        this.visitNode(newlineNode.getNextNode());
        return null;
    }

    public Instruction visitNextNode(NextNode nextNode) {
        this.handleNode((Node)nextNode);
        this.visitNode(nextNode.getValueNode());
        return null;
    }

    public Instruction visitNilNode(NilNode nilNode) {
        this.handleNode((Node)nilNode);
        return null;
    }

    public Instruction visitNotNode(NotNode notNode) {
        this.handleNode((Node)notNode);
        this.visitNode(notNode.getConditionNode());
        return null;
    }

    public Instruction visitNthRefNode(NthRefNode nthRefNode) {
        this.handleNode((Node)nthRefNode);
        return null;
    }

    public Instruction visitOpElementAsgnNode(OpElementAsgnNode opElementAsgnNode) {
        this.handleNode((Node)opElementAsgnNode);
        this.visitNode(opElementAsgnNode.getReceiverNode());
        this.visitNode(opElementAsgnNode.getArgsNode());
        this.visitNode(opElementAsgnNode.getValueNode());
        return null;
    }

    public Instruction visitOpAsgnNode(OpAsgnNode opAsgnNode) {
        this.handleNode((Node)opAsgnNode);
        this.visitNode(opAsgnNode.getReceiverNode());
        this.visitNode(opAsgnNode.getValueNode());
        return null;
    }

    public Instruction visitOpAsgnAndNode(OpAsgnAndNode opAsgnAndNode) {
        this.handleNode((Node)opAsgnAndNode);
        this.visitNode(opAsgnAndNode.getFirstNode());
        this.visitNode(opAsgnAndNode.getSecondNode());
        return null;
    }

    public Instruction visitOpAsgnOrNode(OpAsgnOrNode opAsgnOrNode) {
        this.handleNode((Node)opAsgnOrNode);
        this.visitNode(opAsgnOrNode.getFirstNode());
        this.visitNode(opAsgnOrNode.getSecondNode());
        return null;
    }

    public Instruction visitOptNNode(OptNNode optNNode) {
        this.handleNode((Node)optNNode);
        this.visitNode(optNNode.getBodyNode());
        return null;
    }

    public Instruction visitOrNode(OrNode orNode) {
        this.handleNode((Node)orNode);
        this.visitNode(orNode.getFirstNode());
        this.visitNode(orNode.getSecondNode());
        return null;
    }

    public Instruction visitPostExeNode(PostExeNode postExeNode) {
        this.handleNode((Node)postExeNode);
        return null;
    }

    public Instruction visitRedoNode(RedoNode redoNode) {
        this.handleNode((Node)redoNode);
        return null;
    }

    public Instruction visitRegexpNode(RegexpNode regexpNode) {
        this.handleNode((Node)regexpNode);
        return null;
    }

    public Instruction visitRescueBodyNode(RescueBodyNode rescueBodyNode) {
        this.handleNode((Node)rescueBodyNode);
        this.visitNode(rescueBodyNode.getExceptionNodes());
        this.visitNode((Node)rescueBodyNode.getOptRescueNode());
        this.visitNode(rescueBodyNode.getBodyNode());
        return null;
    }

    public Instruction visitRescueNode(RescueNode rescueNode) {
        this.handleNode((Node)rescueNode);
        this.visitNode((Node)rescueNode.getRescueNode());
        this.visitNode(rescueNode.getBodyNode());
        this.visitNode(rescueNode.getElseNode());
        return null;
    }

    public Instruction visitRetryNode(RetryNode retryNode) {
        this.handleNode((Node)retryNode);
        return null;
    }

    public Instruction visitReturnNode(ReturnNode returnNode) {
        this.handleNode((Node)returnNode);
        this.visitNode(returnNode.getValueNode());
        return null;
    }

    public Instruction visitSClassNode(SClassNode sClassNode) {
        this.handleNode((Node)sClassNode);
        this.visitNode(sClassNode.getReceiverNode());
        this.visitNode((Node)sClassNode.getBodyNode());
        return null;
    }

    public Instruction visitScopeNode(ScopeNode scopeNode) {
        this.handleNode((Node)scopeNode);
        this.visitNode(scopeNode.getBodyNode());
        return null;
    }

    public Instruction visitSelfNode(SelfNode selfNode) {
        this.handleNode((Node)selfNode);
        return null;
    }

    public Instruction visitSplatNode(SplatNode splatNode) {
        this.handleNode((Node)splatNode);
        this.visitNode(splatNode.getValue());
        return null;
    }

    public Instruction visitStrNode(StrNode strNode) {
        this.handleNode((Node)strNode);
        return null;
    }

    public Instruction visitSuperNode(SuperNode superNode) {
        this.handleNode((Node)superNode);
        this.visitNode(superNode.getArgsNode());
        return null;
    }

    public Instruction visitSValueNode(SValueNode sValueNode) {
        this.handleNode((Node)sValueNode);
        this.visitNode(sValueNode.getValue());
        return null;
    }

    public Instruction visitSymbolNode(SymbolNode symbolNode) {
        this.handleNode((Node)symbolNode);
        return null;
    }

    public Instruction visitToAryNode(ToAryNode toAryNode) {
        this.handleNode((Node)toAryNode);
        this.visitNode(toAryNode.getValue());
        return null;
    }

    public Instruction visitTrueNode(TrueNode trueNode) {
        this.handleNode((Node)trueNode);
        return null;
    }

    public Instruction visitUndefNode(UndefNode undefNode) {
        this.handleNode((Node)undefNode);
        return null;
    }

    public Instruction visitUntilNode(UntilNode untilNode) {
        this.handleNode((Node)untilNode);
        this.visitNode(untilNode.getConditionNode());
        this.visitNode(untilNode.getBodyNode());
        return null;
    }

    public Instruction visitVAliasNode(VAliasNode vAliasNode) {
        this.handleNode((Node)vAliasNode);
        return null;
    }

    public Instruction visitVCallNode(VCallNode vCallNode) {
        this.handleNode((Node)vCallNode);
        String string = vCallNode.getMethodName();
        if (string.equals("public")) {
            this.currentVisibility = Visibility.PUBLIC;
        } else if (string.equals("private")) {
            this.currentVisibility = Visibility.PRIVATE;
        } else if (string.equals("protected")) {
            this.currentVisibility = Visibility.PROTECTED;
        }
        return null;
    }

    public Instruction visitWhenNode(WhenNode whenNode) {
        this.handleNode((Node)whenNode);
        this.visitNode(whenNode.getExpressionNodes());
        this.visitNode(whenNode.getBodyNode());
        this.visitNode(whenNode.getNextCase());
        return null;
    }

    public Instruction visitWhileNode(WhileNode whileNode) {
        this.handleNode((Node)whileNode);
        this.visitNode(whileNode.getConditionNode());
        this.visitNode(whileNode.getBodyNode());
        return null;
    }

    public Instruction visitXStrNode(XStrNode xStrNode) {
        this.handleNode((Node)xStrNode);
        return null;
    }

    public Instruction visitYieldNode(YieldNode yieldNode) {
        this.handleNode((Node)yieldNode);
        this.visitNode(yieldNode.getArgsNode());
        return null;
    }

    public Instruction visitZArrayNode(ZArrayNode zArrayNode) {
        this.handleNode((Node)zArrayNode);
        return null;
    }

    public Instruction visitZSuperNode(ZSuperNode zSuperNode) {
        this.handleNode((Node)zSuperNode);
        return null;
    }

    private Instruction visitNode(Node node) {
        if (node != null) {
            node.accept((NodeVisitor)this);
        }
        return null;
    }

    private Instruction handleNode(Node node) {
        if (this.DEBUG) {
            System.out.println(String.valueOf(node.toString()) + ", position -> " + node.getPosition());
        }
        return null;
    }
}

