/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.rubypeople.rdt.internal.debug.core.RubyLineBreakpoint;

public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ManageBreakpointRulerAction(IVerticalRulerInfo iVerticalRulerInfo, ITextEditor iTextEditor) {
        this.fRuler = iVerticalRulerInfo;
        this.fTextEditor = iTextEditor;
        this.fAddLabel = "Add Breakpoint";
        this.fRemoveLabel = "Remove Breakpoint";
    }

    public void update() {
        this.fMarkers = this.getBreakpoints();
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected List getBreakpoints() {
        ArrayList<IBreakpoint> arrayList = new ArrayList<IBreakpoint>();
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel == null) {
            return arrayList;
        }
        try {
            IResource iResource = this.getResource();
            if (iResource == null) {
                return arrayList;
            }
            IMarker[] iMarkerArray = iResource.findMarkers("org.rubypeople.rdt.debug.core.RubyBreakpointMarker", false, 2);
            IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IDocument iDocument = this.getDocument();
            int n = 0;
            while (n < iMarkerArray.length) {
                IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint(iMarkerArray[n]);
                if (iBreakpoint != null && iBreakpointManager.isRegistered(iBreakpoint) && this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument)) {
                    arrayList.add(iBreakpoint);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            System.out.println(coreException.getStatus());
        }
        return arrayList;
    }

    protected IResource getResource() {
        IResource iResource;
        IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)iEditorInput.getAdapter((Class)clazz2);
        }
        return iResource;
    }

    protected boolean includesRulerLine(Position position, IDocument iDocument) {
        if (position != null) {
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = this.fRuler.getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        return iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected void addMarker() {
        IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
        this.getDocument();
        int n = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
        try {
            new RubyLineBreakpoint((IResource)((IFileEditorInput)iEditorInput).getFile(), n);
        }
        catch (CoreException coreException) {
            System.out.println(coreException.getMessage());
        }
    }

    protected void removeMarkers(List list) {
        Iterator iterator = this.fMarkers.iterator();
        while (iterator.hasNext()) {
            IBreakpoint iBreakpoint = (IBreakpoint)iterator.next();
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(iBreakpoint, true);
                return;
            }
            catch (CoreException coreException) {}
        }
    }
}

