/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.matcher;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.matcher.PatternMatcher;

public class MatcherHelper {
    public static boolean matches(PatternMatcher m, String exp, String str) {
        return m.getMatcher(exp).matches(str);
    }

    public static boolean matches(PatternMatcher m, ModuleId exp, ModuleId mid) {
        return MatcherHelper.matches(m, exp.getOrganisation(), mid.getOrganisation()) && MatcherHelper.matches(m, exp.getName(), mid.getName());
    }

    public static boolean matches(PatternMatcher m, ModuleRevisionId exp, ModuleRevisionId mrid) {
        return MatcherHelper.matches(m, exp.getOrganisation(), mrid.getOrganisation()) && MatcherHelper.matches(m, exp.getName(), mrid.getName()) && MatcherHelper.matches(m, exp.getRevision(), mrid.getRevision());
    }

    public static boolean matches(PatternMatcher m, ArtifactId exp, ArtifactId aid) {
        return MatcherHelper.matches(m, exp.getModuleId().getOrganisation(), aid.getModuleId().getOrganisation()) && MatcherHelper.matches(m, exp.getModuleId().getName(), aid.getModuleId().getName()) && MatcherHelper.matches(m, exp.getName(), aid.getName()) && MatcherHelper.matches(m, exp.getExt(), aid.getExt()) && MatcherHelper.matches(m, exp.getType(), aid.getType());
    }

    public static boolean isExact(PatternMatcher m, ModuleRevisionId exp) {
        return MatcherHelper.isExact(m, exp.getOrganisation()) && MatcherHelper.isExact(m, exp.getName()) && MatcherHelper.isExact(m, exp.getRevision());
    }

    public static boolean isExact(PatternMatcher m, ModuleId exp) {
        return MatcherHelper.isExact(m, exp.getOrganisation()) && MatcherHelper.isExact(m, exp.getName());
    }

    public static boolean isExact(PatternMatcher m, String exp) {
        return m.getMatcher(exp).isExact();
    }
}

