/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.external.m2.PomModuleDescriptorParser;
import fr.jayasoft.ivy.repository.url.URLResource;
import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;

public class IvyConvertPom
extends IvyTask {
    private File _pomFile = null;
    private File _ivyFile = null;

    public File getPomFile() {
        return this._pomFile;
    }

    public void setPomFile(File file) {
        this._pomFile = file;
    }

    public File getIvyFile() {
        return this._ivyFile;
    }

    public void setIvyFile(File ivyFile) {
        this._ivyFile = ivyFile;
    }

    public void execute() throws BuildException {
        try {
            if (this._pomFile == null) {
                throw new BuildException("source pom file is required for convertpom task");
            }
            if (this._ivyFile == null) {
                throw new BuildException("destination ivy file is required for convertpom task");
            }
            ModuleDescriptor md = PomModuleDescriptorParser.getInstance().parseDescriptor(new Ivy(), this._pomFile.toURL(), false);
            PomModuleDescriptorParser.getInstance().toIvyFile(this._pomFile.toURL().openStream(), new URLResource(this._pomFile.toURL()), this.getIvyFile(), md);
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given pom file to url: " + this._pomFile + ": " + e, (Throwable)e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in pom file " + this._pomFile + ": " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("impossible convert given pom file to ivy file: " + e + " from=" + this._pomFile + " to=" + this._ivyFile, (Throwable)e);
        }
    }
}

