/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.extendable.UnmodifiableExtendableItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModuleRevisionId
extends UnmodifiableExtendableItem {
    private static final String ENCODE_SEPARATOR = ":#@#:";
    private static final String ENCODE_PREFIX = "+";
    private static final String NULL_ENCODE = "@#:NULL:#@";
    private ModuleId _moduleId;
    private String _branch;
    private String _revision;
    private int _hash;

    public static ModuleRevisionId newInstance(String organisation, String name, String revision) {
        return new ModuleRevisionId(new ModuleId(organisation, name), revision);
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String revision, Map extraAttributes) {
        return new ModuleRevisionId(new ModuleId(organisation, name), revision, extraAttributes);
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision) {
        return new ModuleRevisionId(new ModuleId(organisation, name), branch, revision);
    }

    public static ModuleRevisionId newInstance(String organisation, String name, String branch, String revision, Map extraAttributes) {
        return new ModuleRevisionId(new ModuleId(organisation, name), branch, revision, extraAttributes);
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId mrid, String rev) {
        return new ModuleRevisionId(mrid.getModuleId(), mrid.getBranch(), rev, mrid.getExtraAttributes());
    }

    public ModuleRevisionId(ModuleId moduleId, String revision) {
        this(moduleId, null, revision, null);
    }

    public ModuleRevisionId(ModuleId moduleId, String branch, String revision) {
        this(moduleId, branch, revision, null);
    }

    public ModuleRevisionId(ModuleId moduleId, String revision, Map extraAttributes) {
        this(moduleId, null, revision, extraAttributes);
    }

    public ModuleRevisionId(ModuleId moduleId, String branch, String revision, Map extraAttributes) {
        super(null, extraAttributes);
        this._moduleId = moduleId;
        this._branch = branch == null ? IvyContext.getContext().getIvy().getDefaultBranch(moduleId) : branch;
        this._revision = revision;
        this._hash = this._hashCode();
        this.setStandardAttribute("organisation", this._moduleId.getOrganisation());
        this.setStandardAttribute("module", this._moduleId.getName());
        this.setStandardAttribute("branch", this._branch);
        this.setStandardAttribute("revision", this._revision);
    }

    public ModuleId getModuleId() {
        return this._moduleId;
    }

    public String getName() {
        return this.getModuleId().getName();
    }

    public String getOrganisation() {
        return this.getModuleId().getOrganisation();
    }

    public String getRevision() {
        return this._revision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleRevisionId)) {
            return false;
        }
        ModuleRevisionId other = (ModuleRevisionId)obj;
        return (other.getRevision() == null ? this.getRevision() == null : other.getRevision().equals(this.getRevision())) && (other.getBranch() == null ? this.getBranch() == null : other.getBranch().equals(this.getBranch())) && other.getModuleId().equals(this.getModuleId()) && ((Object)other.getExtraAttributes()).equals(this.getExtraAttributes());
    }

    public int hashCode() {
        return this._hash;
    }

    public int _hashCode() {
        int hash = 31;
        hash = hash * 13 + (this.getBranch() == null ? 0 : this.getBranch().hashCode());
        hash = hash * 13 + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        hash = hash * 13 + this.getModuleId().hashCode();
        hash = hash * 13 + ((Object)this.getAttributes()).hashCode();
        return hash;
    }

    public String toString() {
        return "[ " + this._moduleId.getOrganisation() + " | " + this._moduleId.getName() + (this._branch == null || this._branch.length() == 0 ? "" : " | " + this._branch) + " | " + (this._revision == null ? "NONE" : this._revision) + " ]";
    }

    public String encodeToString() {
        StringBuffer buf = new StringBuffer();
        Map attributes = this.getAttributes();
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String attName = (String)iter.next();
            String value = (String)attributes.get(attName);
            value = value == null ? NULL_ENCODE : value;
            buf.append(ENCODE_PREFIX).append(attName).append(ENCODE_SEPARATOR).append(ENCODE_PREFIX).append(value).append(ENCODE_SEPARATOR);
        }
        return buf.toString();
    }

    public static ModuleRevisionId decode(String encoded) {
        String[] parts = encoded.split(ENCODE_SEPARATOR);
        if (parts.length % 2 != 0) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "'");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < parts.length; i += 2) {
            String attName = parts[i];
            if (!attName.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': " + attName + " doesn't start with " + ENCODE_PREFIX);
            }
            attName = attName.substring(1);
            String attValue = parts[i + 1];
            if (!attValue.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': " + attValue + " doesn't start with " + ENCODE_PREFIX);
            }
            if (NULL_ENCODE.equals(attValue = attValue.substring(1))) {
                attValue = null;
            }
            attributes.put(attName, attValue);
        }
        String org = (String)attributes.remove("organisation");
        String mod = (String)attributes.remove("module");
        String rev = (String)attributes.remove("revision");
        String branch = (String)attributes.remove("branch");
        if (org == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no organisation");
        }
        if (mod == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no module name");
        }
        if (rev == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no revision");
        }
        return ModuleRevisionId.newInstance(org, mod, branch, rev, attributes);
    }

    public String getBranch() {
        return this._branch;
    }
}

