/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.ConflictManager;
import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.DependencyArtifactDescriptor;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.License;
import fr.jayasoft.ivy.MDArtifact;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.matcher.MatcherHelper;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import fr.jayasoft.ivy.namespace.NameSpaceHelper;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.namespace.NamespaceTransformer;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.status.StatusManager;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.version.VersionMatcher;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorWriter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DefaultModuleDescriptor
implements ModuleDescriptor {
    private ModuleRevisionId _revId;
    private ModuleRevisionId _resolvedRevId;
    private String _status = StatusManager.getCurrent().getDefaultStatus();
    private Date _publicationDate;
    private Date _resolvedPublicationDate;
    private List _dependencies = new ArrayList();
    private Map _configurations = new LinkedHashMap();
    private Map _artifactsByConf = new HashMap();
    private Collection _artifacts = new LinkedHashSet();
    private boolean _isDefault = false;
    private Map _conflictManagers = new LinkedHashMap();
    private List _licenses = new ArrayList();
    private String _homePage;
    private long _lastModified = 0L;
    private Namespace _namespace;
    private boolean _mappingOverride;
    private ModuleDescriptorParser _parser;
    private Resource _resource;

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId mrid) {
        return DefaultModuleDescriptor.newDefaultInstance(mrid, null);
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId mrid, String[] confs, boolean transitive, boolean changing) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName() + "-caller", "working"), "integration", null, true);
        for (int i = 0; i < confs.length; ++i) {
            moduleDescriptor.addConfiguration(new Configuration(confs[i]));
        }
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(moduleDescriptor, mrid, true, changing, transitive);
        for (int j = 0; j < confs.length; ++j) {
            dd.addDependencyConfiguration(confs[j], confs[j]);
        }
        moduleDescriptor.addDependency(dd);
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId[] mrid, boolean transitive, boolean changing) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("caller", "all-caller", "working"), "integration", null, true);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        for (int i = 0; i < mrid.length; ++i) {
            DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(moduleDescriptor, mrid[i], true, changing, transitive);
            dd.addDependencyConfiguration("default", "*");
            moduleDescriptor.addDependency(dd);
        }
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId mrid, DependencyArtifactDescriptor[] artifacts) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(mrid, "release", null, true);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        if (artifacts != null && artifacts.length > 0) {
            for (int i = 0; i < artifacts.length; ++i) {
                moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, artifacts[i].getName(), artifacts[i].getType(), artifacts[i].getExt(), artifacts[i].getUrl(), null));
            }
        } else {
            moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, mrid.getName(), "jar", "jar"));
        }
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newBasicInstance(ModuleRevisionId mrid, Date publicationDate) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(mrid, "release", publicationDate, false);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, mrid.getName(), "jar", "jar"));
        return moduleDescriptor;
    }

    public static ModuleDescriptor transformInstance(ModuleDescriptor md, Namespace ns) {
        NamespaceTransformer t = ns.getToSystemTransformer();
        if (t.isIdentity()) {
            return md;
        }
        DefaultModuleDescriptor nmd = new DefaultModuleDescriptor(md.getParser(), md.getResource());
        nmd._revId = t.transform(md.getModuleRevisionId());
        nmd._resolvedRevId = t.transform(md.getResolvedModuleRevisionId());
        nmd._status = md.getStatus();
        nmd._publicationDate = md.getPublicationDate();
        nmd._resolvedPublicationDate = md.getResolvedPublicationDate();
        DependencyDescriptor[] dd = md.getDependencies();
        for (int i = 0; i < dd.length; ++i) {
            nmd._dependencies.add(NameSpaceHelper.toSystem(dd[i], ns));
        }
        Configuration[] confs = md.getConfigurations();
        for (int i = 0; i < confs.length; ++i) {
            nmd._configurations.put(confs[i].getName(), confs[i]);
            Artifact[] arts = md.getArtifacts(confs[i].getName());
            for (int j = 0; j < arts.length; ++j) {
                nmd.addArtifact(confs[i].getName(), NameSpaceHelper.transform(arts[j], t));
            }
        }
        nmd.setDefault(md.isDefault());
        if (md instanceof DefaultModuleDescriptor) {
            DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
            nmd._conflictManagers.putAll(dmd._conflictManagers);
        } else {
            Message.warn("transformed module descriptor is not a default module descriptor: impossible to copy conflict manager configuration: " + md);
        }
        nmd._licenses.addAll(Arrays.asList(md.getLicenses()));
        nmd._homePage = md.getHomePage();
        nmd._lastModified = md.getLastModified();
        nmd._namespace = ns;
        return nmd;
    }

    public DefaultModuleDescriptor(ModuleRevisionId id, String status, Date pubDate) {
        this(id, status, pubDate, false);
    }

    public DefaultModuleDescriptor(ModuleRevisionId id, String status, Date pubDate, boolean isDefault) {
        if (id == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        if (status == null) {
            throw new NullPointerException("null status not allowed");
        }
        this._revId = id;
        this._resolvedRevId = id;
        this._status = status;
        this._publicationDate = pubDate;
        this._resolvedPublicationDate = this._publicationDate == null ? new Date() : this._publicationDate;
        this._isDefault = isDefault;
    }

    public DefaultModuleDescriptor(ModuleDescriptorParser parser, Resource res) {
        this._parser = parser;
        this._resource = res;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void setPublicationDate(Date publicationDate) {
        this._publicationDate = publicationDate;
        if (this._resolvedPublicationDate == null) {
            this._resolvedPublicationDate = this._publicationDate == null ? new Date() : this._publicationDate;
        }
    }

    public Date getPublicationDate() {
        return this._publicationDate;
    }

    public void setResolvedPublicationDate(Date publicationDate) {
        if (publicationDate == null) {
            throw new NullPointerException("null publication date not allowed");
        }
        this._resolvedPublicationDate = publicationDate;
    }

    public Date getResolvedPublicationDate() {
        return this._resolvedPublicationDate;
    }

    public void setModuleRevisionId(ModuleRevisionId revId) {
        if (revId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        this._revId = revId;
        if (this._resolvedRevId == null) {
            this._resolvedRevId = this._revId;
        }
    }

    public void setResolvedModuleRevisionId(ModuleRevisionId revId) {
        this._resolvedRevId = revId;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void addDependency(DependencyDescriptor dependency) {
        this._dependencies.add(dependency);
    }

    public void addConfiguration(Configuration conf) {
        this._configurations.put(conf.getName(), conf);
    }

    public void addArtifact(String conf, Artifact artifact) {
        ArrayList<Artifact> artifacts = (ArrayList<Artifact>)this._artifactsByConf.get(conf);
        if (artifacts == null) {
            artifacts = new ArrayList<Artifact>();
            this._artifactsByConf.put(conf, artifacts);
        }
        artifacts.add(artifact);
        this._artifacts.add(artifact);
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this._revId;
    }

    public ModuleRevisionId getResolvedModuleRevisionId() {
        return this._resolvedRevId;
    }

    public String getStatus() {
        return this._status;
    }

    public Configuration[] getConfigurations() {
        return this._configurations.values().toArray(new Configuration[this._configurations.size()]);
    }

    public String[] getConfigurationsNames() {
        return this._configurations.keySet().toArray(new String[this._configurations.size()]);
    }

    public String[] getPublicConfigurationsNames() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator iter = this._configurations.values().iterator();
        while (iter.hasNext()) {
            Configuration conf = (Configuration)iter.next();
            if (conf.getVisibility() != Configuration.Visibility.PUBLIC) continue;
            ret.add(conf.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Configuration getConfiguration(String confName) {
        return (Configuration)this._configurations.get(confName);
    }

    public Artifact[] getArtifacts(String conf) {
        Collection artifacts = (Collection)this._artifactsByConf.get(conf);
        if (artifacts == null) {
            return new Artifact[0];
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    public Artifact[] getAllArtifacts() {
        return this._artifacts.toArray(new Artifact[this._artifacts.size()]);
    }

    public DependencyDescriptor[] getDependencies() {
        return this._dependencies.toArray(new DependencyDescriptor[this._dependencies.size()]);
    }

    public boolean dependsOn(VersionMatcher matcher, ModuleDescriptor md) {
        Iterator iter = this._dependencies.iterator();
        while (iter.hasNext()) {
            DependencyDescriptor dd = (DependencyDescriptor)iter.next();
            if (!dd.getDependencyId().equals(md.getModuleRevisionId().getModuleId())) continue;
            if (md.getResolvedModuleRevisionId().getRevision() == null) {
                return true;
            }
            if (!matcher.accept(dd.getDependencyRevisionId(), md)) continue;
            return true;
        }
        return false;
    }

    public void toIvyFile(File destFile) throws ParseException, IOException {
        if (this._parser != null && this._resource != null) {
            this._parser.toIvyFile(this._resource.openStream(), this._resource, destFile, this);
        } else {
            XmlModuleDescriptorWriter.write(this, destFile);
        }
    }

    public String toString() {
        return "module: " + this._revId + " status=" + this._status + " publication=" + this._publicationDate + " configurations=" + this._configurations + " artifacts=" + this._artifactsByConf + " dependencies=" + this._dependencies;
    }

    public void setDefault(boolean b) {
        this._isDefault = b;
    }

    public void addConflictManager(ModuleId moduleId, PatternMatcher matcher, ConflictManager manager) {
        this._conflictManagers.put(new ModuleIdMatcher(matcher, moduleId), manager);
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        Iterator iter = this._conflictManagers.keySet().iterator();
        while (iter.hasNext()) {
            ModuleIdMatcher matcher = (ModuleIdMatcher)iter.next();
            if (!matcher.matches(moduleId)) continue;
            return (ConflictManager)this._conflictManagers.get(matcher);
        }
        return null;
    }

    public void addLicense(License license) {
        this._licenses.add(license);
    }

    public License[] getLicenses() {
        return this._licenses.toArray(new License[this._licenses.size()]);
    }

    public String getHomePage() {
        return this._homePage;
    }

    public void setHomePage(String homePage) {
        this._homePage = homePage;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(long lastModified) {
        this._lastModified = lastModified;
    }

    public Namespace getNamespace() {
        if (this._namespace == null || !this.isNamespaceUseful()) {
            return null;
        }
        return this._namespace;
    }

    public boolean isNamespaceUseful() {
        Iterator iter = this._dependencies.iterator();
        while (iter.hasNext()) {
            DependencyDescriptor dd = (DependencyDescriptor)iter.next();
            if (dd.getAllDependencyArtifactsExcludes().length <= 0) continue;
            return true;
        }
        return false;
    }

    public void setNamespace(Namespace ns) {
        this._namespace = ns;
    }

    public void check() {
        Iterator iter = this._configurations.values().iterator();
        while (iter.hasNext()) {
            Configuration conf = (Configuration)iter.next();
            String[] ext = conf.getExtends();
            for (int i = 0; i < ext.length; ++i) {
                if (this._configurations.containsKey(ext[i].trim())) continue;
                throw new IllegalStateException("unknown configuration '" + ext[i] + "'. It is extended by " + conf.getName());
            }
        }
    }

    public void setMappingOverride(boolean override) {
        this._mappingOverride = override;
    }

    public boolean isMappingOverride() {
        return this._mappingOverride;
    }

    public String getAttribute(String attName) {
        return this._resolvedRevId.getAttribute(attName);
    }

    public Map getAttributes() {
        return this._resolvedRevId.getAttributes();
    }

    public String getExtraAttribute(String attName) {
        return this._resolvedRevId.getExtraAttribute(attName);
    }

    public Map getExtraAttributes() {
        return this._resolvedRevId.getExtraAttributes();
    }

    public String getStandardAttribute(String attName) {
        return this._resolvedRevId.getStandardAttribute(attName);
    }

    public Map getStandardAttributes() {
        return this._resolvedRevId.getStandardAttributes();
    }

    public ModuleDescriptorParser getParser() {
        return this._parser;
    }

    public Resource getResource() {
        return this._resource;
    }

    private static class ModuleIdMatcher {
        private PatternMatcher _matcher;
        private ModuleId _mid;

        public ModuleIdMatcher(PatternMatcher matcher, ModuleId mid) {
            this._matcher = matcher;
            this._mid = mid;
        }

        public boolean matches(ModuleId mid) {
            return MatcherHelper.matches(this._matcher, this._mid, mid);
        }
    }
}

