/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.extendable.UnmodifiableExtendableItem;
import java.util.Map;

public class ArtifactRevisionId
extends UnmodifiableExtendableItem {
    private ArtifactId _artifactId;
    private ModuleRevisionId _mrid;

    public static ArtifactRevisionId newInstance(ModuleRevisionId mrid, String name, String type, String ext) {
        return ArtifactRevisionId.newInstance(mrid, name, type, ext, null);
    }

    public static ArtifactRevisionId newInstance(ModuleRevisionId mrid, String name, String type, String ext, Map extraAttributes) {
        return new ArtifactRevisionId(new ArtifactId(mrid.getModuleId(), name, type, ext), mrid, extraAttributes);
    }

    public ArtifactRevisionId(ArtifactId artifactId, ModuleRevisionId mrid) {
        this(artifactId, mrid, null);
    }

    public ArtifactRevisionId(ArtifactId artifactId, ModuleRevisionId mrid, Map extraAttributes) {
        super(null, extraAttributes);
        this._artifactId = artifactId;
        this._mrid = mrid;
        this.setStandardAttribute("organisation", this.getModuleRevisionId().getOrganisation());
        this.setStandardAttribute("module", this.getModuleRevisionId().getName());
        this.setStandardAttribute("revision", this.getModuleRevisionId().getRevision());
        this.setStandardAttribute("artifact", this.getName());
        this.setStandardAttribute("type", this.getType());
        this.setStandardAttribute("ext", this.getExt());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArtifactRevisionId)) {
            return false;
        }
        ArtifactRevisionId arid = (ArtifactRevisionId)obj;
        return this.getArtifactId().equals(arid.getArtifactId()) && this.getModuleRevisionId().equals(arid.getModuleRevisionId()) && ((Object)this.getExtraAttributes()).equals(arid.getExtraAttributes());
    }

    public int hashCode() {
        int hash = 17;
        hash += this.getArtifactId().hashCode() * 37;
        hash += this.getModuleRevisionId().hashCode() * 37;
        return hash += ((Object)this.getExtraAttributes()).hashCode() * 37;
    }

    public String toString() {
        return "[ " + this.getModuleRevisionId().getOrganisation() + " | " + this.getModuleRevisionId().getName() + " | " + this.getModuleRevisionId().getRevision() + " :: " + this.getName() + " . " + this.getExt() + " ( " + this.getType() + " ) ]";
    }

    public ArtifactId getArtifactId() {
        return this._artifactId;
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this._mrid;
    }

    public String getName() {
        return this._artifactId.getName();
    }

    public String getType() {
        return this._artifactId.getType();
    }

    public String getExt() {
        return this._artifactId.getExt();
    }

    public String getRevision() {
        return this._mrid.getRevision();
    }
}

