/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.AssignedFieldMap;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockType;
import edu.umd.cs.findbugs.ba.BlockTypeAnalysis;
import edu.umd.cs.findbugs.ba.BytecodeScanner;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilder;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.CFGBuilderFactory;
import edu.umd.cs.findbugs.ba.CompactLocationNumbering;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.DominatorsAnalysis;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeChooser;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockAnalysis;
import edu.umd.cs.findbugs.ba.LockChecker;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.PostDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.PruneInfeasibleExceptionEdges;
import edu.umd.cs.findbugs.ba.PruneUnconditionalExceptionThrowerEdges;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ReturnPathAnalysis;
import edu.umd.cs.findbugs.ba.ReturnPathDataflow;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ca.CallListAnalysis;
import edu.umd.cs.findbugs.ba.ca.CallListDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantAnalysis;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.heap.LoadAnalysis;
import edu.umd.cs.findbugs.ba.heap.LoadDataflow;
import edu.umd.cs.findbugs.ba.heap.StoreAnalysis;
import edu.umd.cs.findbugs.ba.heap.StoreDataflow;
import edu.umd.cs.findbugs.ba.npe.DerefFinder;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.ReturnPathTypeAnalysis;
import edu.umd.cs.findbugs.ba.npe.ReturnPathTypeDataflow;
import edu.umd.cs.findbugs.ba.npe.UsagesRequiringNonNullValues;
import edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSetAnalysis;
import edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSetDataflow;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.util.MapCache;
import edu.umd.cs.findbugs.util.TopologicalSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassContext {
    public static final boolean DEBUG;
    private static final int PRUNED_INFEASIBLE_EXCEPTIONS = 1;
    private static final int PRUNED_UNCONDITIONAL_THROWERS = 2;
    private static final int REFINED = 4;
    private static final boolean TIME_ANALYSES;
    private static final boolean DEBUG_CFG;
    private static final boolean DUMP_DATAFLOW_ANALYSIS;
    private static int depth;
    private final Set<String> busyCFGSet = new HashSet<String>();
    private JavaClass jclass;
    private AnalysisContext analysisContext;
    private List<AnalysisFactory<?>> analysisFactoryList = new LinkedList();
    private NoExceptionAnalysisFactory<MethodGen> methodGenFactory = new NoExceptionAnalysisFactory<MethodGen>("MethodGen construction"){

        @Override
        @CheckForNull
        protected MethodGen analyze(Method method) {
            if (method.getCode() == null) {
                return null;
            }
            try {
                int codeLength;
                String methodName = method.getName();
                if (ClassContext.this.analysisContext.getBoolProperty(3) && ((codeLength = method.getCode().getLength()) > 3000 || (methodName.equals("<clinit>") || methodName.equals("getContents")) && codeLength > 1000)) {
                    ClassContext.this.getLookupFailureCallback().reportSkippedAnalysis(new JavaClassAndMethod(ClassContext.this.jclass, method).toMethodDescriptor());
                    return null;
                }
                return new MethodGen(method, ClassContext.this.jclass.getClassName(), ClassContext.this.getConstantPoolGen());
            }
            catch (Exception e) {
                AnalysisContext.logError("Error constructing methodGen", e);
                return null;
            }
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private CFGFactory cfgFactory = new CFGFactory();
    private AnalysisFactory<UsagesRequiringNonNullValues> derefFactory = new AnalysisFactory<UsagesRequiringNonNullValues>("Dereference factory"){

        @Override
        protected UsagesRequiringNonNullValues analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            return DerefFinder.getAnalysis(ClassContext.this, method);
        }

        @Override
        public boolean isDataflow() {
            return false;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<ValueNumberDataflow> vnaDataflowFactory = new DataflowAnalysisFactory<ValueNumberDataflow>("value number analysis"){

        @Override
        protected ValueNumberDataflow analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                throw new MethodUnprofitableException(ClassContext.this.getJavaClass(), method);
            }
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            LoadedFieldSet loadedFieldSet = ClassContext.this.getLoadedFieldSet(method);
            ValueNumberAnalysis analysis = new ValueNumberAnalysis(methodGen, dfs, loadedFieldSet, ClassContext.this.getLookupFailureCallback());
            analysis.setMergeTree(new MergeTree(analysis.getFactory()));
            CFG cfg = ClassContext.this.getCFG(method);
            ValueNumberDataflow vnaDataflow = new ValueNumberDataflow(cfg, analysis);
            vnaDataflow.execute();
            if (DUMP_DATAFLOW_ANALYSIS) {
                TreeSet<Location> tree = new TreeSet<Location>();
                Iterator<Location> locs = cfg.locationIterator();
                while (locs.hasNext()) {
                    Location loc = locs.next();
                    tree.add(loc);
                }
                System.out.println(new StringBuffer().append("\n\nValue number analysis for ").append(method.getName()).append(" {").toString());
                for (Location loc : tree) {
                    System.out.println(new StringBuffer().append("\nBefore: ").append(vnaDataflow.getFactAtLocation(loc)).toString());
                    System.out.println(new StringBuffer().append("Location: ").append(loc).toString());
                    System.out.println(new StringBuffer().append("After: ").append(vnaDataflow.getFactAfterLocation(loc)).toString());
                }
                System.out.println("}\n");
            }
            return vnaDataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<IsNullValueDataflow> invDataflowFactory = new DataflowAnalysisFactory<IsNullValueDataflow>("null value analysis"){

        @Override
        protected IsNullValueDataflow analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                throw new MethodUnprofitableException(ClassContext.this.getJavaClass(), method);
            }
            CFG cfg = ClassContext.this.getCFG(method);
            ValueNumberDataflow vnaDataflow = ClassContext.this.getValueNumberDataflow(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            AssertionMethods assertionMethods = ClassContext.this.getAssertionMethods();
            IsNullValueAnalysis invAnalysis = new IsNullValueAnalysis(methodGen, cfg, vnaDataflow, dfs, assertionMethods);
            invAnalysis.setClassAndMethod(new JavaClassAndMethod(ClassContext.this.getJavaClass(), method));
            IsNullValueDataflow invDataflow = new IsNullValueDataflow(cfg, invAnalysis);
            invDataflow.execute();
            if (DUMP_DATAFLOW_ANALYSIS) {
                TreeSet<Location> tree = new TreeSet<Location>();
                Iterator<Location> locs = cfg.locationIterator();
                while (locs.hasNext()) {
                    Location loc = locs.next();
                    tree.add(loc);
                }
                System.out.println(new StringBuffer().append("\n\nInv analysis for ").append(method.getName()).append(" {").toString());
                for (Location loc : tree) {
                    System.out.println(new StringBuffer().append("\nBefore: ").append(invDataflow.getFactAtLocation(loc)).toString());
                    System.out.println(new StringBuffer().append("Location: ").append(loc).toString());
                    System.out.println(new StringBuffer().append("After: ").append(invDataflow.getFactAfterLocation(loc)).toString());
                }
                System.out.println("}\n");
            }
            return invDataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<TypeDataflow> typeDataflowFactory = new DataflowAnalysisFactory<TypeDataflow>("type analysis"){

        @Override
        protected TypeDataflow analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                throw new MethodUnprofitableException(ClassContext.this.getJavaClass(), method);
            }
            CFG cfg = ClassContext.this.getRawCFG(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            ExceptionSetFactory exceptionSetFactory = ClassContext.this.getExceptionSetFactory(method);
            TypeAnalysis typeAnalysis = new TypeAnalysis(method, methodGen, cfg, dfs, ClassContext.this.getLookupFailureCallback(), exceptionSetFactory);
            if (ClassContext.this.analysisContext.getBoolProperty(2)) {
                typeAnalysis.setValueNumberDataflow(ClassContext.this.getValueNumberDataflow(method));
            }
            typeAnalysis.setFieldStoreTypeDatabase(ClassContext.this.analysisContext.getFieldStoreTypeDatabase());
            TypeDataflow typeDataflow = new TypeDataflow(cfg, typeAnalysis);
            typeDataflow.execute();
            if (TypeAnalysis.DEBUG) {
                ClassContext.dumpTypeDataflow(method, cfg, typeDataflow);
            }
            return typeDataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private NoDataflowAnalysisFactory<DepthFirstSearch> dfsFactory = new NoDataflowAnalysisFactory<DepthFirstSearch>("depth first search"){

        @Override
        protected DepthFirstSearch analyze(Method method) throws CFGBuilderException {
            CFG cfg = ClassContext.this.getRawCFG(method);
            DepthFirstSearch dfs = new DepthFirstSearch(cfg);
            dfs.search();
            return dfs;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private NoDataflowAnalysisFactory<ReverseDepthFirstSearch> rdfsFactory = new NoDataflowAnalysisFactory<ReverseDepthFirstSearch>("reverse depth first search"){

        @Override
        protected ReverseDepthFirstSearch analyze(Method method) throws CFGBuilderException {
            CFG cfg = ClassContext.this.getRawCFG(method);
            ReverseDepthFirstSearch rdfs = new ReverseDepthFirstSearch(cfg);
            rdfs.search();
            return rdfs;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private NoExceptionAnalysisFactory<UnpackedCode> unpackedCodeFactory = new NoExceptionAnalysisFactory<UnpackedCode>("unpacked bytecode"){

        @Override
        protected UnpackedCode analyze(Method method) {
            Code code = method.getCode();
            if (code == null) {
                return null;
            }
            byte[] instructionList = code.getCode();
            UnpackedBytecodeCallback callback = new UnpackedBytecodeCallback(instructionList.length);
            BytecodeScanner scanner = new BytecodeScanner();
            scanner.scan(instructionList, callback);
            return callback.getUnpackedCode();
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<LockDataflow> lockDataflowFactory = new DataflowAnalysisFactory<LockDataflow>("lock set analysis"){

        @Override
        protected LockDataflow analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                throw new MethodUnprofitableException(ClassContext.this.getJavaClass(), method);
            }
            ValueNumberDataflow vnaDataflow = ClassContext.this.getValueNumberDataflow(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            CFG cfg = ClassContext.this.getCFG(method);
            LockAnalysis analysis = new LockAnalysis(methodGen, vnaDataflow, dfs);
            LockDataflow dataflow = new LockDataflow(cfg, analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<LockChecker> lockCheckerFactory = new DataflowAnalysisFactory<LockChecker>("lock checker meta-analysis"){

        @Override
        protected LockChecker analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            LockChecker lockChecker = new LockChecker(ClassContext.this, method);
            lockChecker.execute();
            return lockChecker;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<ReturnPathDataflow> returnPathDataflowFactory = new DataflowAnalysisFactory<ReturnPathDataflow>("return path analysis"){

        @Override
        protected ReturnPathDataflow analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            CFG cfg = ClassContext.this.getCFG(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            ReturnPathAnalysis analysis = new ReturnPathAnalysis(dfs);
            ReturnPathDataflow dataflow = new ReturnPathDataflow(cfg, analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<DominatorsAnalysis> nonExceptionDominatorsAnalysisFactory = new DataflowAnalysisFactory<DominatorsAnalysis>("non-exception dominators analysis"){

        @Override
        protected DominatorsAnalysis analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            CFG cfg = ClassContext.this.getCFG(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            DominatorsAnalysis analysis = new DominatorsAnalysis(cfg, dfs, true);
            Dataflow dataflow = new Dataflow(cfg, analysis);
            dataflow.execute();
            return analysis;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<PostDominatorsAnalysis> nonExceptionPostDominatorsAnalysisFactory = new DataflowAnalysisFactory<PostDominatorsAnalysis>("non-exception postdominators analysis"){

        @Override
        protected PostDominatorsAnalysis analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            CFG cfg = ClassContext.this.getCFG(method);
            ReverseDepthFirstSearch rdfs = ClassContext.this.getReverseDepthFirstSearch(method);
            PostDominatorsAnalysis analysis = new PostDominatorsAnalysis(cfg, rdfs, ClassContext.this.getDepthFirstSearch(method), true);
            Dataflow dataflow = new Dataflow(cfg, analysis);
            dataflow.execute();
            return analysis;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<PostDominatorsAnalysis> nonImplicitExceptionPostDominatorsAnalysisFactory = new DataflowAnalysisFactory<PostDominatorsAnalysis>("non-implicit-exception postdominators analysis"){

        @Override
        protected PostDominatorsAnalysis analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            CFG cfg = ClassContext.this.getCFG(method);
            PostDominatorsAnalysis analysis = new PostDominatorsAnalysis(cfg, ClassContext.this.getReverseDepthFirstSearch(method), ClassContext.this.getDepthFirstSearch(method), new EdgeChooser(){

                public boolean choose(Edge edge) {
                    return !edge.isExceptionEdge() || edge.isFlagSet(2);
                }
            });
            Dataflow dataflow = new Dataflow(cfg, analysis);
            dataflow.execute();
            return analysis;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private NoExceptionAnalysisFactory<ExceptionSetFactory> exceptionSetFactoryFactory = new NoExceptionAnalysisFactory<ExceptionSetFactory>("exception set factory"){

        @Override
        protected ExceptionSetFactory analyze(Method method) {
            return new ExceptionSetFactory();
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private NoExceptionAnalysisFactory<String[]> parameterSignatureListFactory = new NoExceptionAnalysisFactory<String[]>("parameter signature list factory"){

        @Override
        protected String[] analyze(Method method) {
            SignatureParser parser = new SignatureParser(method.getSignature());
            ArrayList<String> resultList = new ArrayList<String>();
            Iterator<String> i = parser.parameterSignatureIterator();
            while (i.hasNext()) {
                resultList.add(i.next());
            }
            return resultList.toArray(new String[resultList.size()]);
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<ConstantDataflow> constantDataflowFactory = new DataflowAnalysisFactory<ConstantDataflow>("constant propagation analysis"){

        @Override
        @CheckForNull
        protected ConstantDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                return null;
            }
            ConstantAnalysis analysis = new ConstantAnalysis(methodGen, ClassContext.this.getDepthFirstSearch(method));
            ConstantDataflow dataflow = new ConstantDataflow(ClassContext.this.getCFG(method), analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<LoadDataflow> loadDataflowFactory = new DataflowAnalysisFactory<LoadDataflow>("field load analysis"){

        @Override
        @CheckForNull
        protected LoadDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                return null;
            }
            LoadAnalysis analysis = new LoadAnalysis(ClassContext.this.getDepthFirstSearch(method), ClassContext.this.getConstantPoolGen());
            LoadDataflow dataflow = new LoadDataflow(ClassContext.this.getCFG(method), analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<StoreDataflow> storeDataflowFactory = new DataflowAnalysisFactory<StoreDataflow>("field store analysis"){

        @Override
        @CheckForNull
        protected StoreDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                return null;
            }
            StoreAnalysis analysis = new StoreAnalysis(ClassContext.this.getDepthFirstSearch(method), ClassContext.this.getConstantPoolGen());
            StoreDataflow dataflow = new StoreDataflow(ClassContext.this.getCFG(method), analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private static final BitSet fieldInstructionOpcodeSet;
    private NoExceptionAnalysisFactory<LoadedFieldSet> loadedFieldSetFactory = new NoExceptionAnalysisFactory<LoadedFieldSet>("loaded field set factory"){

        @Override
        protected LoadedFieldSet analyze(Method method) {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                return null;
            }
            InstructionList il = methodGen.getInstructionList();
            LoadedFieldSet loadedFieldSet = new LoadedFieldSet(methodGen);
            for (InstructionHandle handle = il.getStart(); handle != null; handle = handle.getNext()) {
                Instruction ins = handle.getInstruction();
                short opcode = ins.getOpcode();
                try {
                    if (opcode == 184) {
                        InnerClassAccess access;
                        INVOKESTATIC inv = (INVOKESTATIC)ins;
                        if (!Hierarchy.isInnerClassAccess(inv, ClassContext.this.getConstantPoolGen()) || (access = Hierarchy.getInnerClassAccess(inv, ClassContext.this.getConstantPoolGen())) == null) continue;
                        if (access.isLoad()) {
                            loadedFieldSet.addLoad(handle, access.getField());
                            continue;
                        }
                        loadedFieldSet.addStore(handle, access.getField());
                        continue;
                    }
                    if (!fieldInstructionOpcodeSet.get(opcode)) continue;
                    boolean isLoad = opcode == 180 || opcode == 178;
                    XField field = Hierarchy.findXField((FieldInstruction)ins, ClassContext.this.getConstantPoolGen());
                    if (field == null) continue;
                    if (isLoad) {
                        loadedFieldSet.addLoad(handle, field);
                        continue;
                    }
                    loadedFieldSet.addStore(handle, field);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    ClassContext.this.analysisContext.getLookupFailureCallback().reportMissingClass(e);
                }
            }
            return loadedFieldSet;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<LiveLocalStoreDataflow> liveLocalStoreDataflowFactory = new DataflowAnalysisFactory<LiveLocalStoreDataflow>("live local stores analysis"){

        @Override
        protected LiveLocalStoreDataflow analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                return null;
            }
            CFG cfg = ClassContext.this.getCFG(method);
            ReverseDepthFirstSearch rdfs = ClassContext.this.getReverseDepthFirstSearch(method);
            LiveLocalStoreAnalysis analysis = new LiveLocalStoreAnalysis(methodGen, rdfs, ClassContext.this.getDepthFirstSearch(method));
            LiveLocalStoreDataflow dataflow = new LiveLocalStoreDataflow(cfg, analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<Dataflow<BlockType, BlockTypeAnalysis>> blockTypeDataflowFactory = new DataflowAnalysisFactory<Dataflow<BlockType, BlockTypeAnalysis>>("block type analysis"){

        @Override
        protected Dataflow<BlockType, BlockTypeAnalysis> analyze(Method method) throws DataflowAnalysisException, CFGBuilderException {
            CFG cfg = ClassContext.this.getCFG(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            BlockTypeAnalysis analysis = new BlockTypeAnalysis(dfs);
            Dataflow<BlockType, BlockTypeAnalysis> dataflow = new Dataflow<BlockType, BlockTypeAnalysis>(cfg, analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<CallListDataflow> callListDataflowFactory = new DataflowAnalysisFactory<CallListDataflow>("call list analysis"){

        @Override
        protected CallListDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            CallListAnalysis analysis = new CallListAnalysis(ClassContext.this.getCFG(method), ClassContext.this.getDepthFirstSearch(method), ClassContext.this.getConstantPoolGen());
            CallListDataflow dataflow = new CallListDataflow(ClassContext.this.getCFG(method), analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private AnalysisFactory<UnconditionalValueDerefDataflow> unconditionalValueDerefDataflowFactory = new DataflowAnalysisFactory<UnconditionalValueDerefDataflow>("unconditional value dereference analysis"){

        @Override
        protected UnconditionalValueDerefDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            CFG cfg = ClassContext.this.getCFG(method);
            ValueNumberDataflow vnd = ClassContext.this.getValueNumberDataflow(method);
            UnconditionalValueDerefAnalysis analysis = new UnconditionalValueDerefAnalysis(ClassContext.this.getReverseDepthFirstSearch(method), ClassContext.this.getDepthFirstSearch(method), cfg, method, ClassContext.this.getMethodGen(method), vnd, ClassContext.this.getAssertionMethods());
            IsNullValueDataflow inv = ClassContext.this.getIsNullValueDataflow(method);
            analysis.clearDerefsOnNonNullBranches(inv);
            TypeDataflow typeDataflow = ClassContext.this.getTypeDataflow(method);
            analysis.setTypeDataflow(typeDataflow);
            UnconditionalValueDerefDataflow dataflow = new UnconditionalValueDerefDataflow(ClassContext.this.getCFG(method), analysis);
            dataflow.execute();
            if (UnconditionalValueDerefAnalysis.DEBUG) {
                ClassContext.dumpDataflowInformation(method, cfg, vnd, inv, dataflow, typeDataflow);
            }
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private NoDataflowAnalysisFactory<CompactLocationNumbering> compactLocationNumberingFactory = new NoDataflowAnalysisFactory<CompactLocationNumbering>("compact location numbering"){

        @Override
        protected CompactLocationNumbering analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            if (method.getCode() == null) {
                return null;
            }
            CFG cfg = ClassContext.this.getCFG(method);
            return new CompactLocationNumbering(cfg);
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private DataflowAnalysisFactory<DefinitelyNullSetDataflow> definitelyNullSetDataflowFactory = new DataflowAnalysisFactory<DefinitelyNullSetDataflow>("definitely null set dataflow"){

        @Override
        protected DefinitelyNullSetDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            CFG cfg = ClassContext.this.getCFG(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            ValueNumberDataflow vnaDataflow = ClassContext.this.getValueNumberDataflow(method);
            CompactLocationNumbering compactLocationNumbering = ClassContext.this.getCompactLocationNumbering(method);
            DefinitelyNullSetAnalysis analysis = new DefinitelyNullSetAnalysis(dfs, vnaDataflow, compactLocationNumbering);
            DefinitelyNullSetDataflow dataflow = new DefinitelyNullSetDataflow(cfg, analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private DataflowAnalysisFactory<ReturnPathTypeDataflow> returnPathTypeDataflowFactory = new DataflowAnalysisFactory<ReturnPathTypeDataflow>("return path type dataflow"){

        @Override
        protected ReturnPathTypeDataflow analyze(Method method) throws CFGBuilderException, DataflowAnalysisException {
            CFG cfg = ClassContext.this.getCFG(method);
            DepthFirstSearch dfs = ClassContext.this.getDepthFirstSearch(method);
            ReverseDepthFirstSearch rdfs = ClassContext.this.getReverseDepthFirstSearch(method);
            ReturnPathTypeAnalysis analysis = new ReturnPathTypeAnalysis(cfg, rdfs, dfs);
            ReturnPathTypeDataflow dataflow = new ReturnPathTypeDataflow(cfg, analysis);
            dataflow.execute();
            return dataflow;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }
    };
    private ClassGen classGen;
    private AssignedFieldMap assignedFieldMap;
    private AssertionMethods assertionMethods;
    @CheckForNull
    List<Method> methodsInCallOrder = null;
    Method cachedMethod;
    CFG cachedCFG = null;
    static MapCache<XMethod, BitSet> cachedBitsets;
    static MapCache<XMethod, Set<Integer>> cachedLoopExits;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$ClassContext;

    private static void indent() {
        for (int i = 0; i < depth; ++i) {
            System.out.print("  ");
        }
    }

    public ClassContext(JavaClass jclass, AnalysisContext analysisContext) {
        this.jclass = jclass;
        this.analysisContext = analysisContext;
        this.classGen = null;
        this.assignedFieldMap = null;
        this.assertionMethods = null;
    }

    void purgeAnalysisResultsAfterCFGPruning(Method method) {
        for (AnalysisFactory<?> factory : this.analysisFactoryList) {
            if (!factory.isDataflow()) continue;
            factory.purge(method);
        }
    }

    public JavaClass getJavaClass() {
        return this.jclass;
    }

    public Method getMethod(MethodGen methodGen) {
        Method[] methodList;
        for (Method method : methodList = this.jclass.getMethods()) {
            if (!method.getName().equals(methodGen.getName()) || !method.getSignature().equals(methodGen.getSignature()) || method.getAccessFlags() != methodGen.getAccessFlags()) continue;
            return method;
        }
        return null;
    }

    @NonNull
    public List<Method> getMethodsInCallOrder() {
        if (this.methodsInCallOrder != null) {
            return this.methodsInCallOrder;
        }
        List<Method> methodList = Arrays.asList(this.getJavaClass().getMethods());
        final HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method m : methodList) {
            map.put(new StringBuffer().append(m.getName()).append(m.getSignature()).toString(), m);
        }
        final ConstantPoolGen cpg = this.getConstantPoolGen();
        final String thisClassName = this.getJavaClass().getClassName();
        this.methodsInCallOrder = TopologicalSort.sortByCallGraph(methodList, new TopologicalSort.OutEdges<Method>(){

            @Override
            public Collection<Method> getOutEdges(Method method) {
                HashSet<Method> result = new HashSet<Method>();
                try {
                    CFG cfg = ClassContext.this.getCFG(method);
                    Iterator<Location> i = cfg.locationIterator();
                    while (i.hasNext()) {
                        String methodKey;
                        Method method2;
                        String signature;
                        InvokeInstruction inv;
                        String className;
                        Instruction ins = i.next().getHandle().getInstruction();
                        if (!(ins instanceof InvokeInstruction) || !thisClassName.equals(className = (inv = (InvokeInstruction)ins).getClassName(cpg)) || (signature = inv.getSignature(cpg)).indexOf(76) < 0 && signature.indexOf(91) < 0 || (method2 = (Method)map.get(methodKey = new StringBuffer().append(inv.getMethodName(cpg)).append(signature).toString())) == null) continue;
                        result.add(method2);
                    }
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError(new StringBuffer().append("Error getting methods called by ").append(thisClassName).append(".").append(method.getName()).append(":").append(method.getSignature()).toString(), e);
                }
                return result;
            }

            @Override
            public /* synthetic */ Collection getOutEdges(Object x0) {
                return this.getOutEdges((Method)x0);
            }
        });
        if (!$assertionsDisabled && methodList.size() != this.methodsInCallOrder.size()) {
            throw new AssertionError();
        }
        return this.methodsInCallOrder;
    }

    public AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public RepositoryLookupFailureCallback getLookupFailureCallback() {
        return this.analysisContext.getLookupFailureCallback();
    }

    @CheckForNull
    public MethodGen getMethodGen(Method method) {
        return this.methodGenFactory.getAnalysis(method);
    }

    public CFG getRawCFG(Method method) throws CFGBuilderException {
        return this.cfgFactory.getRawCFG(method);
    }

    public CFG getCFG(Method method) throws CFGBuilderException {
        if (method == this.cachedMethod) {
            return this.cachedCFG;
        }
        CFG cfg = this.cfgFactory.getRefinedCFG(method);
        this.cachedMethod = method;
        this.cachedCFG = cfg;
        return cfg;
    }

    @NonNull
    public ConstantPoolGen getConstantPoolGen() {
        if (this.classGen == null) {
            this.classGen = new ClassGen(this.jclass);
        }
        return this.classGen.getConstantPool();
    }

    public UsagesRequiringNonNullValues getUsagesRequiringNonNullValues(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.derefFactory.getAnalysis(method);
    }

    public ValueNumberDataflow getValueNumberDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.vnaDataflowFactory.getAnalysis(method);
    }

    public IsNullValueDataflow getIsNullValueDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.invDataflowFactory.getAnalysis(method);
    }

    public TypeDataflow getTypeDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.typeDataflowFactory.getAnalysis(method);
    }

    public DepthFirstSearch getDepthFirstSearch(Method method) throws CFGBuilderException {
        return this.dfsFactory.getAnalysis(method);
    }

    public ReverseDepthFirstSearch getReverseDepthFirstSearch(Method method) throws CFGBuilderException {
        return this.rdfsFactory.getAnalysis(method);
    }

    @CheckForNull
    public BitSet getBytecodeSet(Method method) {
        return ClassContext.getBytecodeSet(this.jclass, method);
    }

    @CheckForNull
    public static BitSet getBytecodeSet(JavaClass clazz, Method method) {
        XMethod xmethod = XFactory.createXMethod(clazz, method);
        if (cachedBitsets.containsKey(xmethod)) {
            return cachedBitsets.get(xmethod);
        }
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        byte[] instructionList = code.getCode();
        UnpackedBytecodeCallback callback = new UnpackedBytecodeCallback(instructionList.length);
        BytecodeScanner scanner = new BytecodeScanner();
        scanner.scan(instructionList, callback);
        UnpackedCode unpackedCode = callback.getUnpackedCode();
        BitSet result = null;
        if (unpackedCode != null) {
            result = unpackedCode.getBytecodeSet();
        }
        cachedBitsets.put(xmethod, result);
        return result;
    }

    @CheckForNull
    public static Set<Integer> getLoopExitBranches(Method method, MethodGen methodGen) {
        XMethod xmethod = XFactory.createXMethod(methodGen);
        if (cachedLoopExits.containsKey(xmethod)) {
            return cachedLoopExits.get(xmethod);
        }
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        byte[] instructionList = code.getCode();
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < instructionList.length; ++i) {
            if (!ClassContext.checkForBranchExit(instructionList, i)) continue;
            result.add(new Integer(i));
        }
        if (result.size() == 0) {
            result = TigerSubstitutes.emptySet();
        }
        cachedLoopExits.put(xmethod, result);
        return result;
    }

    static short getBranchOffset(byte[] codeBytes, int pos) {
        int branchByte1 = 0xFF & codeBytes[pos];
        int branchByte2 = 0xFF & codeBytes[pos + 1];
        short branchOffset = (short)(branchByte1 << 8 | branchByte2);
        return branchOffset;
    }

    static boolean checkForBranchExit(byte[] codeBytes, int pos) {
        if (pos < 0 || pos + 2 >= codeBytes.length) {
            return false;
        }
        switch (0xFF & codeBytes[pos]) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                break;
            }
            default: {
                return false;
            }
        }
        int branchTarget = pos + ClassContext.getBranchOffset(codeBytes, pos + 1);
        if (branchTarget - 3 < pos || branchTarget >= codeBytes.length) {
            return false;
        }
        if ((codeBytes[branchTarget - 3] & 0xFF) != 167) {
            return false;
        }
        int backBranchTarget = branchTarget + ClassContext.getBranchOffset(codeBytes, branchTarget - 2);
        return backBranchTarget <= pos && backBranchTarget + 12 >= pos;
    }

    public short[] getOffsetToOpcodeMap(Method method) {
        UnpackedCode unpackedCode = this.unpackedCodeFactory.getAnalysis(method);
        return unpackedCode != null ? unpackedCode.getOffsetToBytecodeMap() : null;
    }

    public LockDataflow getLockDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.lockDataflowFactory.getAnalysis(method);
    }

    public LockChecker getLockChecker(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.lockCheckerFactory.getAnalysis(method);
    }

    public ReturnPathDataflow getReturnPathDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.returnPathDataflowFactory.getAnalysis(method);
    }

    public DominatorsAnalysis getNonExceptionDominatorsAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.nonExceptionDominatorsAnalysisFactory.getAnalysis(method);
    }

    public PostDominatorsAnalysis getNonImplicitExceptionDominatorsAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.nonImplicitExceptionPostDominatorsAnalysisFactory.getAnalysis(method);
    }

    public PostDominatorsAnalysis getNonExceptionPostDominatorsAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.nonExceptionPostDominatorsAnalysisFactory.getAnalysis(method);
    }

    public ExceptionSetFactory getExceptionSetFactory(Method method) {
        return this.exceptionSetFactoryFactory.getAnalysis(method);
    }

    public String[] getParameterSignatureList(Method method) {
        return this.parameterSignatureListFactory.getAnalysis(method);
    }

    public LoadedFieldSet getLoadedFieldSet(Method method) {
        return this.loadedFieldSetFactory.getAnalysis(method);
    }

    public LiveLocalStoreDataflow getLiveLocalStoreDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.liveLocalStoreDataflowFactory.getAnalysis(method);
    }

    public Dataflow<BlockType, BlockTypeAnalysis> getBlockTypeDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.blockTypeDataflowFactory.getAnalysis(method);
    }

    public AssignedFieldMap getAssignedFieldMap() throws ClassNotFoundException {
        if (this.assignedFieldMap == null) {
            this.assignedFieldMap = new AssignedFieldMap(this);
        }
        return this.assignedFieldMap;
    }

    public AssertionMethods getAssertionMethods() {
        if (this.assertionMethods == null) {
            this.assertionMethods = new AssertionMethods(this.jclass);
        }
        return this.assertionMethods;
    }

    public ConstantDataflow getConstantDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.constantDataflowFactory.getAnalysis(method);
    }

    public LoadDataflow getLoadDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.loadDataflowFactory.getAnalysis(method);
    }

    public StoreDataflow getStoreDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.storeDataflowFactory.getAnalysis(method);
    }

    public CallListDataflow getCallListDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.callListDataflowFactory.getAnalysis(method);
    }

    public static BitSet linesMentionedMultipleTimes(Method method) {
        BitSet lineMentionedMultipleTimes = new BitSet();
        Code code = method.getCode();
        if (code == null || code.getExceptionTable() == null) {
            return lineMentionedMultipleTimes;
        }
        BitSet foundOnce = new BitSet();
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        int lineNum = -1;
        if (lineNumberTable != null) {
            for (LineNumber line : lineNumberTable.getLineNumberTable()) {
                int newLine = line.getLineNumber();
                if (newLine == lineNum || newLine == -1) continue;
                lineNum = newLine;
                if (foundOnce.get(lineNum)) {
                    lineMentionedMultipleTimes.set(lineNum);
                    continue;
                }
                foundOnce.set(lineNum);
            }
        }
        return lineMentionedMultipleTimes;
    }

    public UnconditionalValueDerefDataflow getUnconditionalValueDerefDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.unconditionalValueDerefDataflowFactory.getAnalysis(method);
    }

    public CompactLocationNumbering getCompactLocationNumbering(Method method) throws CFGBuilderException {
        return this.compactLocationNumberingFactory.getAnalysis(method);
    }

    public DefinitelyNullSetDataflow getDefinitelyNullSetDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return (DefinitelyNullSetDataflow)this.definitelyNullSetDataflowFactory.getAnalysis(method);
    }

    public ReturnPathTypeDataflow getReturnPathTypeDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return (ReturnPathTypeDataflow)this.returnPathTypeDataflowFactory.getAnalysis(method);
    }

    public void dumpDataflowInformation(Method method) {
        try {
            ClassContext.dumpDataflowInformation(method, this.getCFG(method), this.getValueNumberDataflow(method), this.getIsNullValueDataflow(method), this.getUnconditionalValueDerefDataflow(method), this.getTypeDataflow(method));
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError(new StringBuffer().append("Could not dump data information for ").append(this.getJavaClass().getClassName()).append(".").append(method.getName()).toString(), e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError(new StringBuffer().append("Could not dump data information for ").append(this.getJavaClass().getClassName()).append(".").append(method.getName()).toString(), e);
        }
    }

    public static void dumpDataflowInformation(Method method, CFG cfg, ValueNumberDataflow vnd, IsNullValueDataflow inv, UnconditionalValueDerefDataflow dataflow, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        System.out.println(new StringBuffer().append("\n\n{ UnconditionalValueDerefAnalysis analysis for ").append(method.getName()).toString());
        TreeSet<Location> tree = new TreeSet<Location>();
        Iterator<Location> locs = cfg.locationIterator();
        while (locs.hasNext()) {
            Location loc = locs.next();
            tree.add(loc);
        }
        for (Location loc : tree) {
            UnconditionalValueDerefSet factAfterLocation = (UnconditionalValueDerefSet)dataflow.getFactAfterLocation(loc);
            System.out.println(new StringBuffer().append("\n Pre: ").append(factAfterLocation).toString());
            System.out.println(new StringBuffer().append("Vna: ").append(vnd.getFactAtLocation(loc)).toString());
            System.out.println(new StringBuffer().append("inv: ").append(inv.getFactAtLocation(loc)).toString());
            if (typeDataflow != null) {
                System.out.println(new StringBuffer().append("type: ").append(typeDataflow.getFactAtLocation(loc)).toString());
            }
            System.out.println(new StringBuffer().append("Location: ").append(loc).toString());
            System.out.println(new StringBuffer().append("Post: ").append(dataflow.getFactAtLocation(loc)).toString());
            System.out.println(new StringBuffer().append("Vna: ").append(vnd.getFactAfterLocation(loc)).toString());
            System.out.println(new StringBuffer().append("inv: ").append(inv.getFactAfterLocation(loc)).toString());
            if (typeDataflow == null) continue;
            System.out.println(new StringBuffer().append("type: ").append(typeDataflow.getFactAfterLocation(loc)).toString());
        }
        System.out.println("}\n\n");
    }

    public static void dumpTypeDataflow(Method method, CFG cfg, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        System.out.println(new StringBuffer().append("\n\n{ Type analysis for ").append(cfg.getMethodGen().getClassName()).append(".").append(method.getName()).toString());
        TreeSet<Location> tree = new TreeSet<Location>();
        Iterator<Location> locs = cfg.locationIterator();
        while (locs.hasNext()) {
            Location loc = locs.next();
            tree.add(loc);
        }
        for (Location loc : tree) {
            System.out.println(new StringBuffer().append("\n Pre: ").append(typeDataflow.getFactAtLocation(loc)).toString());
            System.out.println(new StringBuffer().append("Location: ").append(loc).toString());
            System.out.println(new StringBuffer().append("Post: ").append(typeDataflow.getFactAfterLocation(loc)).toString());
        }
        System.out.println("}\n\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$ba$ClassContext == null ? (class$edu$umd$cs$findbugs$ba$ClassContext = ClassContext.class$("edu.umd.cs.findbugs.ba.ClassContext")) : class$edu$umd$cs$findbugs$ba$ClassContext).desiredAssertionStatus();
        DEBUG = SystemProperties.getBoolean("classContext.debug");
        TIME_ANALYSES = SystemProperties.getBoolean("classContext.timeAnalyses");
        DEBUG_CFG = SystemProperties.getBoolean("classContext.debugCFG");
        DUMP_DATAFLOW_ANALYSIS = SystemProperties.getBoolean("dataflow.dump");
        fieldInstructionOpcodeSet = new BitSet();
        fieldInstructionOpcodeSet.set(180);
        fieldInstructionOpcodeSet.set(181);
        fieldInstructionOpcodeSet.set(178);
        fieldInstructionOpcodeSet.set(179);
        cachedBitsets = new MapCache(64);
        cachedLoopExits = new MapCache(13);
    }

    private static class UnpackedBytecodeCallback
    implements BytecodeScanner.Callback {
        private BitSet bytecodeSet = new BitSet();
        private short[] offsetToOpcodeMap;

        public UnpackedBytecodeCallback(int codeSize) {
            this.offsetToOpcodeMap = new short[codeSize];
        }

        public void handleInstruction(int opcode, int index) {
            this.bytecodeSet.set(opcode);
            this.offsetToOpcodeMap[index] = (short)opcode;
        }

        public UnpackedCode getUnpackedCode() {
            return new UnpackedCode(this.bytecodeSet, this.offsetToOpcodeMap);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DataflowAnalysisFactory<Analysis>
    extends AnalysisFactory<Analysis> {
        DataflowAnalysisFactory(String desc) {
            super(desc);
        }

        @Override
        public boolean isDataflow() {
            return true;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CFGFactory
    extends AnalysisFactory<CFG> {
        public CFGFactory() {
            super("CFG construction");
        }

        @Override
        public CFG getAnalysis(Method method) throws CFGBuilderException {
            try {
                return (CFG)super.getAnalysis(method);
            }
            catch (DataflowAnalysisException e) {
                throw new IllegalStateException("Should not happen");
            }
        }

        public CFG getRawCFG(Method method) throws CFGBuilderException {
            return this.getAnalysis(method);
        }

        public CFG getRefinedCFG(Method method) throws CFGBuilderException {
            boolean PRUNE_UNCONDITIONAL_EXCEPTION_THROWER_EDGES;
            EdgeTypes pruner;
            boolean PRUNE_INFEASIBLE_EXCEPTION_EDGES;
            CFG cfg = this.getRawCFG(method);
            if (cfg.isFlagSet(4)) {
                return cfg;
            }
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                JavaClassAndMethod javaClassAndMethod = new JavaClassAndMethod(ClassContext.this.jclass, method);
                ClassContext.this.getLookupFailureCallback().reportSkippedAnalysis(javaClassAndMethod.toMethodDescriptor());
                throw new MethodUnprofitableException(javaClassAndMethod);
            }
            cfg.setMethodName(SignatureConverter.convertMethodSignature(methodGen));
            cfg.setMethodGen(methodGen);
            String methodId = new StringBuffer().append(methodGen.getClassName()).append(".").append(methodGen.getName()).append(":").append(methodGen.getSignature()).toString();
            if (DEBUG_CFG) {
                ClassContext.indent();
                System.out.println(new StringBuffer().append("CC: getting refined CFG for ").append(methodId).toString());
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("ClassContext: request to prune ").append(methodId).toString());
            }
            if (!ClassContext.this.busyCFGSet.add(methodId)) {
                return cfg;
            }
            cfg.setFlags(4);
            boolean changed = false;
            boolean ASSUME_ASSERTIONS_ENABLED = true;
            if (ASSUME_ASSERTIONS_ENABLED) {
                LinkedList<Edge> edgesToRemove = new LinkedList<Edge>();
                Iterator i = cfg.edgeIterator();
                while (i.hasNext()) {
                    Edge e = (Edge)i.next();
                    if (e.getType() != 1) continue;
                    try {
                        GETSTATIC getStatic;
                        BasicBlock source = (BasicBlock)e.getSource();
                        InstructionHandle last = source.getLastInstruction();
                        Instruction lastInstruction = last.getInstruction();
                        InstructionHandle prev = last.getPrev();
                        Instruction prevInstruction = prev.getInstruction();
                        if (!(prevInstruction instanceof GETSTATIC) || !(lastInstruction instanceof IFNE) || !(getStatic = (GETSTATIC)prevInstruction).getFieldName(methodGen.getConstantPool()).equals("$assertionsDisabled") || !getStatic.getSignature(methodGen.getConstantPool()).equals("Z")) continue;
                        edgesToRemove.add(e);
                    }
                    catch (RuntimeException exception) {}
                }
                for (Edge e : edgesToRemove) {
                    cfg.removeEdge(e);
                }
            }
            if ((PRUNE_INFEASIBLE_EXCEPTION_EDGES = ClassContext.this.analysisContext.getBoolProperty(0)) && !cfg.isFlagSet(1)) {
                try {
                    TypeDataflow typeDataflow = ClassContext.this.getTypeDataflow(method);
                    pruner = new PruneInfeasibleExceptionEdges(cfg, methodGen, typeDataflow);
                    ((PruneInfeasibleExceptionEdges)pruner).execute();
                    changed = changed || ((PruneInfeasibleExceptionEdges)pruner).wasCFGModified();
                }
                catch (DataflowAnalysisException e) {
                }
                catch (ClassNotFoundException e) {
                    ClassContext.this.getLookupFailureCallback().reportMissingClass(e);
                }
            }
            cfg.setFlags(cfg.getFlags() | 1);
            boolean bl = PRUNE_UNCONDITIONAL_EXCEPTION_THROWER_EDGES = !ClassContext.this.analysisContext.getBoolProperty(1);
            if (PRUNE_UNCONDITIONAL_EXCEPTION_THROWER_EDGES && !cfg.isFlagSet(2)) {
                try {
                    pruner = new PruneUnconditionalExceptionThrowerEdges(ClassContext.this, ClassContext.this.jclass, method, methodGen, cfg, ClassContext.this.getConstantPoolGen(), ClassContext.this.analysisContext);
                    ((PruneUnconditionalExceptionThrowerEdges)pruner).execute();
                    changed = changed || ((PruneUnconditionalExceptionThrowerEdges)pruner).wasCFGModified();
                }
                catch (DataflowAnalysisException e) {
                    // empty catch block
                }
            }
            cfg.setFlags(cfg.getFlags() | 2);
            if (changed) {
                ClassContext.this.purgeAnalysisResultsAfterCFGPruning(method);
            }
            ClassContext.this.busyCFGSet.remove(methodId);
            return cfg;
        }

        @Override
        protected CFG analyze(Method method) throws CFGBuilderException {
            MethodGen methodGen = ClassContext.this.getMethodGen(method);
            if (methodGen == null) {
                JavaClassAndMethod javaClassAndMethod = new JavaClassAndMethod(ClassContext.this.jclass, method);
                ClassContext.this.getLookupFailureCallback().reportSkippedAnalysis(javaClassAndMethod.toMethodDescriptor());
                throw new MethodUnprofitableException(javaClassAndMethod);
            }
            CFGBuilder cfgBuilder = CFGBuilderFactory.create(methodGen);
            cfgBuilder.build();
            return cfgBuilder.getCFG();
        }

        @Override
        public boolean isDataflow() {
            return false;
        }

        @Override
        protected /* synthetic */ Object analyze(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.analyze(x0);
        }

        @Override
        public /* synthetic */ Object getAnalysis(Method x0) throws CFGBuilderException, DataflowAnalysisException {
            return this.getAnalysis(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NoDataflowAnalysisFactory<Analysis>
    extends AnalysisFactory<Analysis> {
        public NoDataflowAnalysisFactory(String analysisName) {
            super(analysisName);
        }

        @Override
        public Analysis getAnalysis(Method method) throws CFGBuilderException {
            try {
                return super.getAnalysis(method);
            }
            catch (DataflowAnalysisException e) {
                throw new IllegalStateException("Should not happen");
            }
        }

        @Override
        public boolean isDataflow() {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NoExceptionAnalysisFactory<Analysis>
    extends AnalysisFactory<Analysis> {
        public NoExceptionAnalysisFactory(String analysisName) {
            super(analysisName);
        }

        @Override
        public Analysis getAnalysis(Method method) {
            try {
                return super.getAnalysis(method);
            }
            catch (DataflowAnalysisException e) {
                throw new IllegalStateException("Should not happen");
            }
            catch (CFGBuilderException e) {
                throw new IllegalStateException("Should not happen");
            }
        }

        @Override
        public boolean isDataflow() {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnalysisFactory<Analysis> {
        private String analysisName;
        private HashMap<Method, AnalysisResult<Analysis>> map = new HashMap();

        public AnalysisFactory(String analysisName) {
            this.analysisName = analysisName;
            ClassContext.this.analysisFactoryList.add(this);
        }

        @CheckForNull
        public Analysis getAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
            AnalysisResult<Analysis> result = this.map.get(method);
            if (result == null) {
                if (TIME_ANALYSES) {
                    ++depth;
                    ClassContext.indent();
                    System.out.println(new StringBuffer().append("CC: Starting ").append(this.analysisName).append(" for ").append(SignatureConverter.convertMethodSignature(ClassContext.this.jclass, method)).append(":").toString());
                }
                long begin = System.currentTimeMillis();
                result = new AnalysisResult();
                try {
                    Analysis analysis = this.analyze(method);
                    result.setAnalysis(analysis);
                }
                catch (CFGBuilderException e) {
                    result.setCFGBuilderException(e);
                }
                catch (DataflowAnalysisException e) {
                    result.setDataflowAnalysisException(e);
                }
                catch (AnalysisException e) {
                    result.setAnalysisException(e);
                }
                if (TIME_ANALYSES) {
                    long end = System.currentTimeMillis();
                    ClassContext.indent();
                    System.out.println(new StringBuffer().append("CC: finished ").append(this.analysisName).append(" in ").append(end - begin).append(" millis").toString());
                    --depth;
                }
                this.map.put(method, result);
            }
            return result.getAnalysis();
        }

        @CheckForNull
        protected abstract Analysis analyze(Method var1) throws CFGBuilderException, DataflowAnalysisException;

        public abstract boolean isDataflow();

        public void purge(Method method) {
            this.map.remove(method);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnalysisResult<Analysis> {
        private boolean analysisSetExplicitly;
        private Analysis analysis;
        private AnalysisException analysisException;
        private CFGBuilderException cfgBuilderException;
        private DataflowAnalysisException dataflowAnalysisException;

        private AnalysisResult() {
        }

        public Analysis getAnalysis() throws CFGBuilderException, DataflowAnalysisException {
            if (this.analysisSetExplicitly) {
                return this.analysis;
            }
            if (this.dataflowAnalysisException != null) {
                throw this.dataflowAnalysisException;
            }
            if (this.analysisException != null) {
                throw this.analysisException;
            }
            if (this.cfgBuilderException != null) {
                throw this.cfgBuilderException;
            }
            throw new IllegalStateException();
        }

        public void setAnalysis(@Nullable Analysis analysis) {
            this.analysisSetExplicitly = true;
            this.analysis = analysis;
        }

        public void setAnalysisException(AnalysisException analysisException) {
            this.analysisException = analysisException;
        }

        public void setCFGBuilderException(CFGBuilderException cfgBuilderException) {
            this.cfgBuilderException = cfgBuilderException;
        }

        public void setDataflowAnalysisException(DataflowAnalysisException dataflowException) {
            this.dataflowAnalysisException = dataflowException;
        }
    }

    private static class UnpackedCode {
        private BitSet bytecodeSet;
        private short[] offsetToBytecodeMap;

        public UnpackedCode(BitSet bytecodeSet, short[] offsetToBytecodeMap) {
            this.bytecodeSet = bytecodeSet;
            this.offsetToBytecodeMap = offsetToBytecodeMap;
        }

        public BitSet getBytecodeSet() {
            return this.bytecodeSet;
        }

        public short[] getOffsetToBytecodeMap() {
            return this.offsetToBytecodeMap;
        }
    }
}

