/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.epic.core.util.ProcessOutput;
import org.epic.core.util.StringReaderThread;

public class ProcessExecutor {
    private boolean disposed;
    private boolean ignoreBrokenPipe;
    private final String charsetName;
    private final StringReaderThread stdout = new StringReaderThread(":ProcessExecutor:stdout");
    private final StringReaderThread stderr = new StringReaderThread(":ProcessExecutor:stderr");

    public ProcessExecutor() {
        this(null);
    }

    public ProcessExecutor(String charsetName) {
        this.charsetName = null;
    }

    public void dispose() {
        this.disposed = true;
        try {
            this.stdout.dispose();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.stderr.dispose();
        }
        catch (InterruptedException interruptedException) {}
    }

    public ProcessOutput execute(List commandLine, String input, File workingDir) throws InterruptedException, IOException {
        return this.execute(commandLine.toArray(new String[commandLine.size()]), input, workingDir);
    }

    public ProcessOutput execute(String[] commandLine, String input, File workingDir) throws InterruptedException, IOException {
        if (this.disposed) {
            throw new IllegalStateException("ProcessExecutor disposed");
        }
        Process proc = null;
        try {
            OutputStreamWriter inputWriter;
            InputStreamReader stdoutReader;
            InputStreamReader stderrReader;
            proc = Runtime.getRuntime().exec(commandLine, null, workingDir);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
            InputStream procStderr = proc.getErrorStream();
            InputStream procStdout = proc.getInputStream();
            OutputStream procStdin = proc.getOutputStream();
            if (this.charsetName != null) {
                stderrReader = new InputStreamReader(procStderr, this.charsetName);
                stdoutReader = new InputStreamReader(procStdout, this.charsetName);
                inputWriter = new OutputStreamWriter(procStdin, this.charsetName);
            } else {
                stderrReader = new InputStreamReader(procStderr);
                stdoutReader = new InputStreamReader(procStdout);
                inputWriter = new OutputStreamWriter(procStdin);
            }
            this.stderr.read(stderrReader);
            this.stdout.read(stdoutReader);
            if (input.length() > 0) {
                ((Writer)inputWriter).write(input.charAt(0));
                ((Writer)inputWriter).flush();
                try {
                    inputWriter.write(input.substring(1));
                    ((Writer)inputWriter).flush();
                }
                catch (IOException e) {
                    this.brokenPipe(e);
                }
            }
            ((Writer)inputWriter).close();
            ProcessOutput ret = new ProcessOutput(this.stdout.getResult(), this.stderr.getResult());
            ((Reader)stderrReader).close();
            ((Reader)stdoutReader).close();
            return ret;
        }
        catch (InterruptedException e) {
            if (proc != null) {
                proc.destroy();
            }
            throw e;
        }
        catch (IOException e) {
            if (proc != null) {
                proc.destroy();
            }
            throw e;
        }
    }

    public void ignoreBrokenPipe() {
        this.ignoreBrokenPipe = true;
    }

    protected void brokenPipe(IOException e) throws IOException {
        if (!this.ignoreBrokenPipe) {
            throw e;
        }
    }
}

