/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlMainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text executableText;
    private Text browserLabelText;
    private Button warningsCheckBox;
    private Button taintCheckBox;
    private Button debugConsoleCheckBox;
    private Button suspendAtFirstCheckBox;
    private Button validateCheckBox;
    private Scale syntaxCheckInterval;
    private Combo interpreterTypeCombo;
    private Label syntaxIntervalSecondsLabel;
    private Composite fParent;
    private String[] intepreterTypes = new String[]{"Standard", "Cygwin"};

    protected Control createContents(Composite parent) {
        this.fParent = parent;
        Composite top = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        top.setLayout((Layout)layout);
        Composite buttonComposite = new Composite(top, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)buttonLayout);
        data = new GridData(1810);
        buttonComposite.setLayoutData((Object)data);
        Label executableLabel = new Label(buttonComposite, 0);
        executableLabel.setText("Perl executable:");
        this.executableText = new Text(buttonComposite, 2048);
        Button browseButton = new Button(buttonComposite, 0x1000008);
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileBrowser = new FileDialog(PerlMainPreferencePage.this.fParent.getShell());
                String dir = fileBrowser.open();
                if (dir != null) {
                    PerlMainPreferencePage.this.executableText.setText("\"" + dir + "\"");
                }
            }
        });
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.executableText.setLayoutData((Object)data);
        this.executableText.setText(PerlEditorPlugin.getDefault().getExecutablePreference());
        new Label(buttonComposite, 0).setText("Interpreter type:");
        this.interpreterTypeCombo = new Combo(buttonComposite, 8);
        this.interpreterTypeCombo.setItems(this.intepreterTypes);
        this.interpreterTypeCombo.setText(PerlEditorPlugin.getDefault().getPreferenceStore().getString("INTERPRETER_TYPE"));
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.warningsCheckBox = new Button(top, 32);
        this.warningsCheckBox.setText("Enable warnings");
        this.warningsCheckBox.setSelection(PerlEditorPlugin.getDefault().getWarningsPreference());
        this.warningsCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.taintCheckBox = new Button(top, 32);
        this.taintCheckBox.setText("Enable taint mode");
        this.taintCheckBox.setSelection(PerlEditorPlugin.getDefault().getTaintPreference());
        this.taintCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.debugConsoleCheckBox = new Button(top, 32);
        this.debugConsoleCheckBox.setText("Enable debugger console (experimental)");
        this.debugConsoleCheckBox.setSelection(PerlEditorPlugin.getDefault().getDebugConsolePreference());
        this.debugConsoleCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.suspendAtFirstCheckBox = new Button(top, 32);
        this.suspendAtFirstCheckBox.setText("Suspend debugger at first statement");
        this.suspendAtFirstCheckBox.setSelection(PerlEditorPlugin.getDefault().getSuspendAtFirstPreference());
        this.suspendAtFirstCheckBox.setLayoutData((Object)data);
        Composite browserComposite = new Composite(top, 0);
        GridLayout browserLayout = new GridLayout();
        browserLayout.numColumns = 2;
        browserComposite.setLayout((Layout)browserLayout);
        data = new GridData(1810);
        browserComposite.setLayoutData((Object)data);
        Label browserLabel = new Label(browserComposite, 0);
        browserLabel.setText("Default Web-Start page:");
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.browserLabelText = new Text(browserComposite, 2048);
        this.browserLabelText.setLayoutData((Object)data);
        this.browserLabelText.setText(PerlEditorPlugin.getDefault().getWebBrowserPreference());
        Composite syntaxIntervalComposite = new Composite(top, 0);
        GridLayout syncIntervalLayout = new GridLayout();
        syncIntervalLayout.numColumns = 3;
        syntaxIntervalComposite.setLayout((Layout)syncIntervalLayout);
        data = new GridData(1810);
        syntaxIntervalComposite.setLayoutData((Object)data);
        this.validateCheckBox = new Button(syntaxIntervalComposite, 32);
        this.validateCheckBox.setText("Validate source when idle for ");
        this.validateCheckBox.setSelection(PerlEditorPlugin.getDefault().getSyntaxValidationPreference());
        this.syntaxCheckInterval = new Scale(syntaxIntervalComposite, 256);
        this.syntaxCheckInterval.setMinimum(1);
        this.syntaxCheckInterval.setMaximum(10000);
        this.syntaxCheckInterval.setIncrement(100);
        this.syntaxIntervalSecondsLabel = new Label(syntaxIntervalComposite, 0);
        int interval = PerlEditorPlugin.getDefault().getPreferenceStore().getInt("SYNTAX_VALIDATION_IDLE_INTERVAL");
        float intervalDisplay = (float)Math.round((float)interval / 10.0f) / 100.0f;
        this.syntaxIntervalSecondsLabel.setText(String.valueOf(intervalDisplay) + " seconds  ");
        this.syntaxCheckInterval.setSelection(interval);
        this.syntaxCheckInterval.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                float intervalDisplay = (float)Math.round((float)PerlMainPreferencePage.this.syntaxCheckInterval.getSelection() / 10.0f) / 100.0f;
                PerlMainPreferencePage.this.syntaxIntervalSecondsLabel.setText(String.valueOf(intervalDisplay) + " seconds  ");
            }
        });
        syntaxIntervalComposite.setLayoutData((Object)data);
        return new Composite(parent, 0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerlEditorPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.executableText.setText(PerlEditorPlugin.getDefault().getDefaultExecutablePreference());
        this.warningsCheckBox.setSelection(PerlEditorPlugin.getDefault().getDefaultWarningsPreference());
        this.taintCheckBox.setSelection(PerlEditorPlugin.getDefault().getDefaultTaintPreference());
        this.interpreterTypeCombo.setText("Standard");
        this.browserLabelText.setText(PerlEditorPlugin.getDefault().getDefaultWebBrowserPreference());
        this.validateCheckBox.setSelection(PerlEditorPlugin.getDefault().getDefaultSyntaxValidationPreference());
        float intervalDisplay = (float)Math.round(40.0f) / 100.0f;
        this.syntaxIntervalSecondsLabel.setText(String.valueOf(intervalDisplay) + " seconds ");
        this.syntaxCheckInterval.setSelection(400);
    }

    public boolean performOk() {
        PerlEditorPlugin.getDefault().setExecutablePreference(this.executableText.getText());
        PerlEditorPlugin.getDefault().setWarningsPreference(this.warningsCheckBox.getSelection());
        PerlEditorPlugin.getDefault().setTaintPreference(this.taintCheckBox.getSelection());
        PerlEditorPlugin.getDefault().setDebugConsolePreference(this.debugConsoleCheckBox.getSelection());
        PerlEditorPlugin.getDefault().setSuspendAtFirstPreference(this.suspendAtFirstCheckBox.getSelection());
        PerlEditorPlugin.getDefault().setSyntaxValidationPreference(this.validateCheckBox.getSelection());
        PerlEditorPlugin.getDefault().getPreferenceStore().setValue("INTERPRETER_TYPE", this.interpreterTypeCombo.getText());
        PerlEditorPlugin.getDefault().getPreferenceStore().setValue("SYNTAX_VALIDATION_IDLE_INTERVAL", this.syntaxCheckInterval.getSelection());
        PerlEditorPlugin.getDefault().setWebBrowserPreference(this.browserLabelText.getText());
        return super.performOk();
    }
}

