/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGen;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Generator
extends CodeGen {
    protected String basePackage;
    public static int EMF_MODEL_PROJECT_STYLE = 1;
    public static int EMF_EDIT_PROJECT_STYLE = 2;
    public static int EMF_EDITOR_PROJECT_STYLE = 4;
    public static int EMF_XML_PROJECT_STYLE = 8;
    public static int EMF_PLUGIN_PROJECT_STYLE = 16;
    public static int EMF_EMPTY_PROJECT_STYLE = 32;
    public static int EMF_TESTS_PROJECT_STYLE = 64;

    public static void main(String[] args) {
        new Generator().run(args);
    }

    public void printGenerateUsage() {
        System.out.println("Usage arguments:");
        System.out.println("  [-platform | -data] <workspace-directory> ");
        System.out.println("  [-projects ] <project-root-directory> ");
        System.out.println("  [-dynamicTemplates] [-forceOverwrite | -diff]");
        System.out.println("  [-generateSchema] [-nonNLSMarkers]");
        System.out.println("  [-codeFormatting { default | <profile-file> } ]");
        System.out.println("  [-model] [-edit] [-editor]");
        System.out.println("  [-autoBuild <true|false>]");
        System.out.println("  <genmodel-file>");
        System.out.println("  [ <target-root-directory> ]");
        System.out.println("");
        System.out.println("For example:");
        System.out.println("");
        System.out.println("  generate result/model/Extended.genmodel");
    }

    public Object run(Object object) {
        return PlatformRunnable.run(this, object);
    }

    protected String findOrCreateContainerHelper(String rootLocation, String encodedPath, Monitor progressMonitor) throws CoreException {
        return EclipseHelper.findOrCreateContainerHelper(rootLocation, encodedPath, progressMonitor);
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, IProgressMonitor progressMonitor, int style) {
        return Generator.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, Collections.EMPTY_LIST);
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, IProgressMonitor progressMonitor, int style, List pluginVariables) {
        return EclipseHelper.createEMFProject(javaSource, projectLocationPath, referencedProjects, BasicMonitor.toMonitor((IProgressMonitor)progressMonitor), style, pluginVariables);
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, Monitor progressMonitor, int style) {
        return Generator.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, Collections.EMPTY_LIST);
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, Monitor progressMonitor, int style, List pluginVariables) {
        return EclipseHelper.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, pluginVariables);
    }

    public void printStatus(String prefix, IStatus status) {
        System.err.print(prefix);
        System.err.println(status.getMessage());
        IStatus[] children = status.getChildren();
        String childPrefix = "  " + prefix;
        int i = 0;
        while (i < children.length) {
            this.printStatus(childPrefix, children[i]);
            ++i;
        }
    }

    public static void setSDODefaults(GenModel genModel) {
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("org.eclipse.emf.ecore.sdo.InternalEDataObject");
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.eclipse.emf.ecore.sdo.util.ESequence");
        genModel.setFeatureMapWrapperClass("org.eclipse.emf.ecore.sdo.util.BasicESequence");
        genModel.setSuppressEMFTypes(true);
        genModel.setSuppressEMFMetaData(true);
        genModel.getModelPluginVariables().add((Object)"EMF_COMMONJ_SDO=org.eclipse.emf.commonj.sdo");
        genModel.getModelPluginVariables().add((Object)"EMF_ECORE_SDO=org.eclipse.emf.ecore.sdo");
        genModel.getStaticPackages().add((Object)"http://www.eclipse.org/emf/2003/SDO");
    }

    public static class PlatformRunnable
    extends Generator
    implements IPlatformRunnable {
        public Object run(Object object) {
            return PlatformRunnable.run(this, object);
        }

        public static Object run(Generator generator, Object object) {
            try {
                String[] arguments = (String[])object;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(arguments, generator, workspace){
                    private final /* synthetic */ String[] val$arguments;
                    private final /* synthetic */ Generator val$generator;
                    private final /* synthetic */ IWorkspace val$workspace;
                    {
                        this.val$arguments = stringArray;
                        this.val$generator = generator;
                        this.val$workspace = iWorkspace;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
                        try {
                            block55: {
                                try {
                                    IWorkspaceDescription description;
                                    if (this.val$arguments.length == 0) {
                                        this.val$generator.printGenerateUsage();
                                        break block55;
                                    }
                                    if ("-ecore2GenModel".equalsIgnoreCase(this.val$arguments[0])) {
                                        Path ecorePath = new Path(this.val$arguments[1]);
                                        this.val$generator.basePackage = this.val$arguments[2];
                                        String prefix = this.val$arguments[3];
                                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                                        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                                        URI ecoreURI = URI.createFileURI((String)ecorePath.toString());
                                        Resource resource = resourceSet.getResource(ecoreURI, true);
                                        EPackage ePackage = (EPackage)resource.getContents().get(0);
                                        IPath genModelPath = ecorePath.removeFileExtension().addFileExtension("genmodel");
                                        progressMonitor.beginTask("", 2);
                                        progressMonitor.subTask("Creating " + genModelPath);
                                        URI genModelURI = URI.createFileURI((String)genModelPath.toString());
                                        Resource genModelResource = Resource.Factory.Registry.INSTANCE.getFactory(genModelURI).createResource(genModelURI);
                                        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
                                        genModelResource.getContents().add((Object)genModel);
                                        resourceSet.getResources().add((Object)genModelResource);
                                        genModel.setModelDirectory("/TargetProject/src");
                                        genModel.getForeignModel().add((Object)ecorePath.toString());
                                        genModel.initialize(Collections.singleton(ePackage));
                                        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
                                        genModel.setModelName(genModelURI.trimFileExtension().lastSegment());
                                        genPackage.setPrefix(prefix);
                                        genPackage.setBasePackage(this.val$generator.basePackage);
                                        progressMonitor.worked(1);
                                        if (this.val$arguments.length > 4 && "-sdo".equals(this.val$arguments[4])) {
                                            PlatformRunnable.setSDODefaults(genModel);
                                        }
                                        genModelResource.save(Collections.EMPTY_MAP);
                                        break block55;
                                    }
                                    String rootLocation = null;
                                    boolean dynamicTemplates = false;
                                    boolean diff = false;
                                    boolean forceOverwrite = false;
                                    boolean generateSchema = false;
                                    boolean nonNLSMarkers = false;
                                    boolean codeFormatting = false;
                                    String profileFile = null;
                                    boolean model = false;
                                    boolean edit = false;
                                    boolean editor = false;
                                    boolean tests = false;
                                    Boolean autoBuild = null;
                                    int index = 0;
                                    while (index < this.val$arguments.length && this.val$arguments[index].startsWith("-")) {
                                        if (this.val$arguments[index].equalsIgnoreCase("-projects")) {
                                            rootLocation = new File(this.val$arguments[++index]).getAbsoluteFile().getCanonicalPath();
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-autoBuild")) {
                                            autoBuild = Boolean.valueOf(this.val$arguments[++index]);
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-dynamicTemplates")) {
                                            dynamicTemplates = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-diff")) {
                                            diff = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-forceOverwrite")) {
                                            forceOverwrite = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-generateSchema")) {
                                            generateSchema = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-nonNLSMarkers")) {
                                            nonNLSMarkers = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-codeFormatting")) {
                                            codeFormatting = true;
                                            if ("default".equals(profileFile = this.val$arguments[++index])) {
                                                profileFile = null;
                                            }
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-model")) {
                                            model = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-edit")) {
                                            edit = true;
                                        } else if (this.val$arguments[index].equalsIgnoreCase("-editor")) {
                                            editor = true;
                                        } else {
                                            if (!this.val$arguments[index].equalsIgnoreCase("-tests")) throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unrecognized argument: '" + this.val$arguments[index] + "'", null));
                                            tests = true;
                                        }
                                        ++index;
                                    }
                                    if (!(model || edit || editor || tests)) {
                                        model = true;
                                    }
                                    String genModelName = this.val$arguments[index++];
                                    progressMonitor.beginTask("Generating " + genModelName, 2);
                                    if (autoBuild != null && (description = this.val$workspace.getDescription()).isAutoBuilding() != autoBuild.booleanValue()) {
                                        description.setAutoBuilding(autoBuild.booleanValue());
                                        try {
                                            this.val$workspace.setDescription(description);
                                        }
                                        catch (CoreException coreException) {
                                            this.val$generator.printStatus("Unable to set autoBuild to " + autoBuild.toString() + ".  Code generation will proceed normally.", coreException.getStatus());
                                        }
                                    }
                                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                                    URI genModelURI = URI.createFileURI((String)new File(genModelName).getAbsoluteFile().getCanonicalPath());
                                    Resource genModelResource = resourceSet.getResource(genModelURI, true);
                                    GenModel genModel = (GenModel)genModelResource.getContents().get(0);
                                    IStatus status = genModel.validate();
                                    if (!status.isOK()) {
                                        this.val$generator.printStatus("", status);
                                        break block55;
                                    }
                                    org.eclipse.emf.codegen.ecore.generator.Generator gen = new org.eclipse.emf.codegen.ecore.generator.Generator();
                                    gen.setInput(genModel);
                                    if (dynamicTemplates) {
                                        genModel.setDynamicTemplates(true);
                                    }
                                    if (forceOverwrite) {
                                        genModel.setForceOverwrite(true);
                                    }
                                    if (diff) {
                                        genModel.setRedirection(".{0}.new");
                                    }
                                    if (index < this.val$arguments.length) {
                                        Path path = new Path(genModel.getModelDirectory());
                                        Path targetRootDirectory = new Path(this.val$arguments[index]);
                                        targetRootDirectory = new Path(targetRootDirectory.toFile().getAbsoluteFile().getCanonicalPath());
                                        CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)new Path(path.segment(0)), (boolean)true, (IPath)targetRootDirectory, (IProgressMonitor)BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1)));
                                    } else {
                                        String modelDirectory = genModel.getModelDirectory();
                                        genModel.setModelDirectory(this.val$generator.findOrCreateContainerHelper(rootLocation, modelDirectory, monitor));
                                        String editDirectory = genModel.getEditDirectory();
                                        if (edit && editDirectory != null) {
                                            genModel.setEditDirectory(this.val$generator.findOrCreateContainerHelper(rootLocation, editDirectory, monitor));
                                        }
                                        String editorDirectory = genModel.getEditorDirectory();
                                        if (editor && editorDirectory != null) {
                                            genModel.setEditorDirectory(this.val$generator.findOrCreateContainerHelper(rootLocation, editorDirectory, monitor));
                                        }
                                        String testsDirectory = genModel.getTestsDirectory();
                                        if (tests && testsDirectory != null) {
                                            genModel.setTestsDirectory(this.val$generator.findOrCreateContainerHelper(rootLocation, testsDirectory, monitor));
                                        }
                                    }
                                    genModel.setCanGenerate(true);
                                    genModel.setUpdateClasspath(false);
                                    if (generateSchema) {
                                        genModel.setGenerateSchema(true);
                                    }
                                    if (nonNLSMarkers) {
                                        genModel.setNonNLSMarkers(true);
                                    }
                                    if (codeFormatting) {
                                        genModel.setCodeFormatting(true);
                                    }
                                    if (profileFile != null) {
                                        Map options = CodeFormatterProfileParser.parse(profileFile);
                                        if (options == null) {
                                            throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unable to read profile file: '" + profileFile + "'", null));
                                        }
                                        gen.getOptions().codeFormatterOptions = options;
                                    }
                                    if (model) {
                                        gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                    }
                                    if (edit) {
                                        gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                    }
                                    if (editor) {
                                        gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                    }
                                    if (tests) {
                                        gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                    }
                                }
                                catch (CoreException exception) {
                                    throw exception;
                                }
                                catch (Exception exception) {
                                    throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "EMF Error", (Throwable)exception));
                                }
                            }
                            Object var28_45 = null;
                        }
                        catch (Throwable throwable) {
                            Object var28_44 = null;
                            progressMonitor.done();
                            throw throwable;
                        }
                        progressMonitor.done();
                    }
                };
                workspace.run(runnable, (IProgressMonitor)new CodeGenUtil.EclipseUtil.StreamProgressMonitor(System.out));
                return new Integer(0);
            }
            catch (Exception exception) {
                generator.printGenerateUsage();
                exception.printStackTrace();
                CodeGenEcorePlugin.INSTANCE.log(exception);
                return new Integer(1);
            }
        }
    }

    static class CodeFormatterProfileParser
    extends DefaultHandler {
        private Map options = null;
        private String SETTING = "setting";
        private String ID = "id";
        private String VALUE = "value";
        private String EMPTY = "";

        CodeFormatterProfileParser() {
        }

        public void startDocument() {
            this.options = new HashMap();
        }

        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) {
            if (this.EMPTY.equals(namespaceURI) && this.SETTING.equals(localName)) {
                String id = atts.getValue(this.EMPTY, this.ID);
                String value = atts.getValue(this.EMPTY, this.VALUE);
                if (id != null && value != null) {
                    this.options.put(id, value);
                }
            }
        }

        public Map getOptions() {
            return this.options;
        }

        public static Map parse(String systemID) {
            try {
                XMLReader parser = XMLReaderFactory.createXMLReader();
                CodeFormatterProfileParser handler = new CodeFormatterProfileParser();
                parser.setContentHandler(handler);
                parser.parse(systemID);
                return handler.getOptions();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, Monitor monitor, int style, List pluginVariables) {
            IProgressMonitor progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
            String projectName = javaSource.segment(0);
            IProject project = null;
            try {
                try {
                    boolean isInitiallyEmpty;
                    IJavaProject javaProject;
                    UniqueEList classpathEntries;
                    block46: {
                        String[] natureIds;
                        classpathEntries = new UniqueEList();
                        progressMonitor.beginTask("", 10);
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_CreatingEMFProject_message", new Object[]{projectName, projectLocationPath != null ? projectLocationPath.toOSString() : projectName}));
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        project = workspace.getRoot().getProject(projectName);
                        if (!project.exists()) {
                            File projectFile;
                            IPath location = projectLocationPath;
                            if (location == null) {
                                location = workspace.getRoot().getLocation().append(projectName);
                            }
                            if ((projectFile = new File((location = location.append(".project")).toString())).exists()) {
                                projectFile.renameTo(new File(String.valueOf(location.toString()) + ".old"));
                            }
                        }
                        javaProject = JavaCore.create((IProject)project);
                        IProjectDescription projectDescription = null;
                        if (!project.exists()) {
                            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                            projectDescription.setLocation(projectLocationPath);
                            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        } else {
                            projectDescription = project.getDescription();
                            classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                        }
                        isInitiallyEmpty = classpathEntries.isEmpty();
                        if (referencedProjects.size() != 0 && (style & (EMF_PLUGIN_PROJECT_STYLE | EMF_EMPTY_PROJECT_STYLE)) == 0) {
                            projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                            Iterator i = referencedProjects.iterator();
                            while (i.hasNext()) {
                                IProject referencedProject = (IProject)i.next();
                                IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                                classpathEntries.add(referencedProjectClasspathEntry);
                            }
                        }
                        if ((natureIds = projectDescription.getNatureIds()) == null) {
                            natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
                        } else {
                            boolean hasJavaNature = false;
                            boolean hasPDENature = false;
                            int i = 0;
                            while (true) {
                                if (i >= natureIds.length) {
                                    if (!hasJavaNature) {
                                        String[] oldNatureIds = natureIds;
                                        natureIds = new String[oldNatureIds.length + 1];
                                        System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                                        natureIds[oldNatureIds.length] = "org.eclipse.jdt.core.javanature";
                                    }
                                    if (hasPDENature) break;
                                    String[] oldNatureIds = natureIds;
                                    natureIds = new String[oldNatureIds.length + 1];
                                    System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                                    natureIds[oldNatureIds.length] = "org.eclipse.pde.PluginNature";
                                    break;
                                }
                                if ("org.eclipse.jdt.core.javanature".equals(natureIds[i])) {
                                    hasJavaNature = true;
                                }
                                if ("org.eclipse.pde.PluginNature".equals(natureIds[i])) {
                                    hasPDENature = true;
                                }
                                ++i;
                            }
                        }
                        projectDescription.setNatureIds(natureIds);
                        ICommand[] builders = projectDescription.getBuildSpec();
                        if (builders == null) {
                            builders = new ICommand[]{};
                        }
                        boolean hasManifestBuilder = false;
                        boolean hasSchemaBuilder = false;
                        int i = 0;
                        while (true) {
                            if (i >= builders.length) {
                                if (!hasManifestBuilder) {
                                    ICommand[] oldBuilders = builders;
                                    builders = new ICommand[oldBuilders.length + 1];
                                    System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
                                    builders[oldBuilders.length] = projectDescription.newCommand();
                                    builders[oldBuilders.length].setBuilderName("org.eclipse.pde.ManifestBuilder");
                                }
                                if (!hasSchemaBuilder) {
                                    ICommand[] oldBuilders = builders;
                                    builders = new ICommand[oldBuilders.length + 1];
                                    System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
                                    builders[oldBuilders.length] = projectDescription.newCommand();
                                    builders[oldBuilders.length].setBuilderName("org.eclipse.pde.SchemaBuilder");
                                }
                                projectDescription.setBuildSpec(builders);
                                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                IProject sourceContainer = project;
                                if (javaSource.segmentCount() > 1 && !(sourceContainer = project.getFolder(javaSource.removeFirstSegments(1).makeAbsolute())).exists()) {
                                    ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                if (isInitiallyEmpty) {
                                    break;
                                }
                                break block46;
                            }
                            if ("org.eclipse.pde.ManifestBuilder".equals(builders[i].getBuilderName())) {
                                hasManifestBuilder = true;
                            }
                            if ("org.eclipse.pde.SchemaBuilder".equals(builders[i].getBuilderName())) {
                                hasSchemaBuilder = true;
                            }
                            ++i;
                        }
                        IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSource);
                        Iterator i2 = classpathEntries.iterator();
                        while (true) {
                            if (!i2.hasNext()) break;
                            IClasspathEntry classpathEntry = (IClasspathEntry)i2.next();
                            if (!classpathEntry.getPath().isPrefixOf(javaSource)) continue;
                            i2.remove();
                        }
                        classpathEntries.add(0, sourceClasspathEntry);
                        IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                        Iterator i3 = classpathEntries.iterator();
                        while (true) {
                            if (!i3.hasNext()) {
                                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
                                break;
                            }
                            IClasspathEntry classpathEntry = (IClasspathEntry)i3.next();
                            if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                            i3.remove();
                        }
                    }
                    if ((style & EMF_EMPTY_PROJECT_STYLE) == 0) {
                        Iterator i;
                        if ((style & EMF_PLUGIN_PROJECT_STYLE) != 0) {
                            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                            i = classpathEntries.iterator();
                            while (i.hasNext()) {
                                IClasspathEntry classpathEntry = (IClasspathEntry)i.next();
                                if ((classpathEntry.getEntryKind() != 4 || "JRE_LIB".equals(classpathEntry.getPath().toString())) && classpathEntry.getEntryKind() != 2) continue;
                                i.remove();
                            }
                        } else {
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_CORE_RUNTIME", (String)"org.eclipse.core.runtime");
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_CORE_RESOURCES", (String)"org.eclipse.core.resources");
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_COMMON", (String)"org.eclipse.emf.common");
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_ECORE", (String)"org.eclipse.emf.ecore");
                            if ((style & EMF_XML_PROJECT_STYLE) != 0) {
                                CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_ECORE_XMI", (String)"org.eclipse.emf.ecore.xmi");
                            }
                            if ((style & EMF_MODEL_PROJECT_STYLE) == 0) {
                                CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_EDIT", (String)"org.eclipse.emf.edit");
                                if ((style & EMF_EDIT_PROJECT_STYLE) == 0) {
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_SWT", (String)"org.eclipse.swt");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_JFACE", (String)"org.eclipse.jface");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_VIEWS", (String)"org.eclipse.ui.views");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_EDITORS", (String)"org.eclipse.ui.editors");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_IDE", (String)"org.eclipse.ui.ide");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_WORKBENCH", (String)"org.eclipse.ui.workbench");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_COMMON_UI", (String)"org.eclipse.emf.common.ui");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_EDIT_UI", (String)"org.eclipse.emf.edit.ui");
                                    if ((style & EMF_XML_PROJECT_STYLE) == 0) {
                                        CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_ECORE_XMI", (String)"org.eclipse.emf.ecore.xmi");
                                    }
                                }
                            }
                            if ((style & EMF_TESTS_PROJECT_STYLE) != 0) {
                                CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"JUNIT", (String)"org.junit");
                            }
                            if (pluginVariables != null) {
                                i = pluginVariables.iterator();
                                while (i.hasNext()) {
                                    String id;
                                    String name;
                                    Object variable = i.next();
                                    if (variable instanceof IClasspathEntry) {
                                        classpathEntries.add(variable);
                                        continue;
                                    }
                                    if (!(variable instanceof String)) continue;
                                    String pluginVariable = (String)variable;
                                    int index = pluginVariable.indexOf("=");
                                    if (index == -1) {
                                        name = pluginVariable.replace('.', '_').toUpperCase();
                                        id = pluginVariable;
                                    } else {
                                        name = pluginVariable.substring(0, index);
                                        id = pluginVariable.substring(index + 1);
                                    }
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)name, (String)id);
                                }
                            }
                        }
                    }
                    javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    if (isInitiallyEmpty) {
                        javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            catch (Throwable throwable) {
                Object var25_36 = null;
                progressMonitor.done();
                throw throwable;
            }
            {
                Object var25_37 = null;
            }
            progressMonitor.done();
            return project;
        }

        public static String findOrCreateContainerHelper(String rootLocation, String encodedPath, Monitor progressMonitor) throws CoreException {
            int index = encodedPath.indexOf("/./");
            if (encodedPath.endsWith("/.") && index != -1) {
                Path modelProjectLocation = new Path(encodedPath.substring(0, index));
                Path fragmentPath = new Path(encodedPath.substring(index + 3, encodedPath.length() - 2));
                IPath projectRelativePath = new Path(modelProjectLocation.lastSegment()).append((IPath)fragmentPath);
                CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)progressMonitor, (int)1)));
                return projectRelativePath.makeAbsolute().toString();
            }
            if (rootLocation != null) {
                index = encodedPath.indexOf("/org.");
                if (index == -1) {
                    index = encodedPath.indexOf("/com.");
                }
                if (index == -1) {
                    index = encodedPath.indexOf("/javax.");
                }
                if (index != -1) {
                    Path projectRelativePath = new Path(encodedPath.substring(index, encodedPath.length()));
                    if ((index = encodedPath.indexOf("/", index + 5)) != -1) {
                        Path modelProjectLocation = new Path(String.valueOf(rootLocation) + "/" + encodedPath.substring(0, index));
                        CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)progressMonitor, (int)1)));
                        return projectRelativePath.makeAbsolute().toString();
                    }
                }
            }
            return encodedPath;
        }
    }
}

